<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'laravel/laravel';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'asm89/stack-cors' => 'v2.2.0@50f57105bad3d97a43ec4a485eb57daf347eafea',
  'aws/aws-crt-php' => 'v1.2.7@d71d9906c7bb63a28295447ba12e74723bd3730e',
  'aws/aws-sdk-php' => '3.337.3@06dfc8f76423b49aaa181debd25bbdc724c346d6',
  'barryvdh/laravel-dompdf' => 'v2.2.0@c96f90c97666cebec154ca1ffb67afed372114d8',
  'box/spout' => 'v3.3.0@9bdb027d312b732515b884a341c0ad70372c6295',
  'brian2694/laravel-toastr' => '5.59@60f90a7b25973549c3992b3dc5965d4f0e27838c',
  'brick/math' => '0.12.1@f510c0a40911935b77b86859eb5223d58d660df1',
  'carbonphp/carbon-doctrine-types' => '2.1.0@99f76ffa36cce3b70a4a6abce41dba15ca2e84cb',
  'ckeditor/ckeditor' => '4.25.0@acc0804803dcf44d452deee74363f66e617c0fc4',
  'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d',
  'defuse/php-encryption' => 'v2.4.0@f53396c2d34225064647a05ca76c1da9d99e5828',
  'dflydev/dot-access-data' => 'v3.0.3@a23a2bf4f31d3518f3ecb38660c95715dfead60f',
  'doctrine/annotations' => '1.14.4@253dca476f70808a5aeed3a47cc2cc88c5cab915',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/common' => '3.5.0@d9ea4a54ca2586db781f0265d36bea731ac66ec5',
  'doctrine/dbal' => '3.9.4@ec16c82f20be1a7224e65ac67144a29199f87959',
  'doctrine/deprecations' => '1.1.4@31610dbb31faa98e6b5447b62340826f54fbc4e9',
  'doctrine/event-manager' => '2.0.1@b680156fa328f1dfd874fd48c7026c41570b9c6e',
  'doctrine/inflector' => '2.0.10@5817d0659c5b50c9b950feb9af7b9668e2c436bc',
  'doctrine/lexer' => '1.2.3@c268e882d4dbdd85e36e4ad69e02dc284f89d229',
  'doctrine/persistence' => '4.0.0@45004aca79189474f113cbe3a53847c2115a55fa',
  'dompdf/dompdf' => 'v2.0.8@c20247574601700e1f7c8dab39310fca1964dc52',
  'dragonmantank/cron-expression' => 'v3.4.0@8c784d071debd117328803d86b2097615b457500',
  'egulias/email-validator' => '2.1.25@0dbf5d78455d4d6a41d186da50adc1122ec066f4',
  'fideloper/proxy' => '4.4.2@a751f2bc86dd8e6cfef12dc0cbdada82f5a18750',
  'firebase/php-jwt' => 'v6.11.0@8f718f4dfc9c5d5f0c994cdfd103921b43592712',
  'fruitcake/laravel-cors' => 'v2.2.0@783a74f5e3431d7b9805be8afb60fd0a8f743534',
  'graham-campbell/result-type' => 'v1.1.3@3ba905c11371512af9d9bdd27d99b782216b6945',
  'gregwar/captcha' => 'v1.2.1@229d3cdfe33d6f1349e0aec94a26e9205a6db08e',
  'guzzlehttp/guzzle' => '7.8.2@f4152d9eb85c445fe1f992001d1748e8bec070d2',
  'guzzlehttp/promises' => '2.0.4@f9c436286ab2892c7db7be8c8da4ef61ccf7b455',
  'guzzlehttp/psr7' => '1.9.1@e4490cabc77465aaee90b20cfc9a770f8c04be6b',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'kingflamez/laravelrave' => 'v4.2.1@4443497c306e0b912feb77156d8947c1456e05b4',
  'laminas/laminas-diactoros' => '2.26.0@6584d44eb8e477e89d453313b858daac6183cddc',
  'laravel/framework' => 'v8.83.29@d841a226a50c715431952a10260ba4fac9e91cc4',
  'laravel/passport' => 'v10.4.2@4bfdb9610575a0c84a6810701f4fd45fb8ab3888',
  'laravel/sanctum' => 'v2.15.1@31fbe6f85aee080c4dc2f9b03dc6dd5d0ee72473',
  'laravel/serializable-closure' => 'v1.3.7@4f48ade902b94323ca3be7646db16209ec76be3d',
  'laravel/socialite' => 'v5.17.0@77be8be7ee5099aed8ca7cfddc1bf6f9ab3fc159',
  'laravel/tinker' => 'v2.10.0@ba4d51eb56de7711b3a37d63aa0643e99a339ae5',
  'laravelpkg/laravelchk' => 'dev-master@4d88f6e0c5b4b5c6c3cfb305b1320288efb84708',
  'lcobucci/clock' => '3.3.1@db3713a61addfffd615b79bf0bc22f0ccc61b86b',
  'lcobucci/jwt' => '4.3.0@4d7de2fe0d51a96418c0d04004986e410e87f6b4',
  'league/commonmark' => '2.6.1@d990688c91cedfb69753ffc2512727ec646df2ad',
  'league/config' => 'v1.2.0@754b3604fb2984c71f4af4a9cbe7b57f346ec1f3',
  'league/event' => '2.2.0@d2cc124cf9a3fab2bb4ff963307f60361ce4d119',
  'league/flysystem' => '1.1.10@3239285c825c152bcc315fe0e87d6b55f5972ed1',
  'league/flysystem-aws-s3-v3' => '1.0.30@af286f291ebab6877bac0c359c6c2cb017eb061d',
  'league/glide' => '1.7.2@8dba756ada0b8e525bf6f1f7d1bd83c1e99e124e',
  'league/mime-type-detection' => '1.16.0@2d6702ff215bf922936ccc1ad31007edc76451b9',
  'league/oauth1-client' => 'v1.11.0@f9c94b088837eb1aae1ad7c4f23eb65cc6993055',
  'league/oauth2-server' => '8.5.5@cc8778350f905667e796b3c2364a9d3bd7a73518',
  'league/uri' => '7.5.1@81fb5145d2644324614cc532b28efd0215bda430',
  'league/uri-interfaces' => '7.5.0@08cfc6c4f3d811584fb09c37e2849e6a7f9b0742',
  'madnest/madzipper' => 'v1.2.2@cb3cc4c98d4f8434dc32f295876220311d4d4217',
  'masterminds/html5' => '2.9.0@f5ac2c0b0a2eefca70b2ce32a5809992227e75a6',
  'mercadopago/dx-php' => '2.6.2@f5f97bd96dfcb3bafdfba634b3bc757025238caa',
  'milon/barcode' => '8.0.1@a1b1ee1a743c1368597f1742e6ee4765333a15a1',
  'monolog/monolog' => '2.10.0@5cf826f2991858b54d5c3809bee745560a1042a7',
  'mpdf/mpdf' => 'v8.2.5@e175b05e3e00977b85feb96a8cccb174ac63621f',
  'mpdf/psr-http-message-shim' => '1.0.0@3206e6b80b6d2479e148ee497e9f2bebadc919db',
  'mpdf/psr-log-aware-trait' => 'v2.0.0@7a077416e8f39eb626dee4246e0af99dd9ace275',
  'mtdowling/jmespath.php' => '2.8.0@a2a865e05d5f420b50cc2f85bb78d565db12a6bc',
  'myclabs/deep-copy' => '1.12.1@123267b2c49fbf30d78a7b2d333f6be754b94845',
  'nesbot/carbon' => '2.72.6@1e9d50601e7035a4c61441a208cb5bed73e108c5',
  'nette/schema' => 'v1.3.2@da801d52f0354f70a638673c4a0f04e16529431d',
  'nette/utils' => 'v4.0.5@736c567e257dbe0fcf6ce81b4d6dbe05c6899f96',
  'nexmo/laravel' => '2.4.1@029bdc19fc58cd6ef0aa75c7041d82b9d9dc61bd',
  'nicmart/tree' => '0.3.1@c55ba47c64a3cb7454c22e6d630729fc2aab23ff',
  'nikic/php-parser' => 'v5.4.0@447a020a1f875a434d62f2a401f53b82a396e494',
  'nwidart/laravel-modules' => '8.2.0@6ade5ec19e81a0e4807834886a2c47509d069cb7',
  'nyholm/psr7' => '1.8.2@a71f2b11690f4b24d099d6b16690a90ae14fc6f3',
  'opis/closure' => '3.6.3@3d81e4309d2a927abbe66df935f4bb60082805ad',
  'paragonie/constant_time_encoding' => 'v3.0.0@df1e7fde177501eee2037dd159cf04f5f301a512',
  'paragonie/random_compat' => 'v9.99.100@996434e5492cb4c3edcb9168db6fbb1359ef965a',
  'paypal/rest-api-sdk-php' => '1.14.0@72e2f2466975bf128a31e02b15110180f059fc04',
  'phenx/php-font-lib' => '0.5.6@a1681e9793040740a405ac5b189275059e2a9863',
  'phenx/php-svg-lib' => '0.5.4@46b25da81613a9cf43c83b2a8c2c1bdab27df691',
  'phpoption/phpoption' => '1.9.3@e3fac8b24f56113f7cb96af14958c0dd16330f54',
  'phpseclib/phpseclib' => '3.0.43@709ec107af3cb2f385b9617be72af8cf62441d02',
  'psr/cache' => '3.0.0@aa5030cfa5405eccfdcb1083ce040c2cb8d253bf',
  'psr/clock' => '1.0.0@e41a24703d4560fd0acb709162f73b8adfc3aa0d',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '1.1@cb6ce4845ce34a8ad9e68117c10ee90a29919eba',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'psy/psysh' => 'v0.12.7@d73fa3c74918ef4522bb8a3bf9cab39161c4b57c',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ramsey/collection' => '2.0.0@a4b48764bfbb8f3a6a4d1aeb1a35bb5e9ecac4a5',
  'ramsey/uuid' => '4.7.6@91039bc1faa45ba123c4328958e620d382ec7088',
  'rap2hpoutre/fast-excel' => 'v3.2.0@28183f3a90179386bfadcd0083129c247ce49fbe',
  'razorpay/razorpay' => '2.9.0@a3d7c2bcb416091edd6a76eb5a7600eaf00ac837',
  'rmccue/requests' => 'v2.0.15@877cd66169755899682f1595e057334b40d9d149',
  'sabberworm/php-css-parser' => 'v8.7.0@f414ff953002a9b18e3a116f5e462c56f21237cf',
  'seshac/laravel-shiprocket-api' => '2.0.0@db0317479dae00d6561143cb4184832e8bc1ce5e',
  'setasign/fpdi' => 'v2.6.2@9e013b376939c0d4029f54150d2a16f3c67a5797',
  'socialiteproviders/apple' => '5.6.1@e00ff7c06e4df297aaeace4e454b2054d6bebe95',
  'socialiteproviders/manager' => 'v4.8.0@e93acc38f8464cc775a2b8bf09df311d1fdfefcb',
  'spatie/browsershot' => '3.61.0@14d75679390b8b84a71b3a17dc5905928deeb887',
  'spatie/crawler' => '6.0.2@276ecb429a770474695a1278a9ad3e719fbef259',
  'spatie/image' => '1.10.6@897e819848096ea8eee8ed4a3531c6166f9a99e0',
  'spatie/image-optimizer' => '1.8.0@4fd22035e81d98fffced65a8c20d9ec4daa9671c',
  'spatie/laravel-sitemap' => '5.9.2@df5c3db511e08a8e64a3d7e28613ab018a99e95d',
  'spatie/robots-txt' => '2.3.0@acc7f4438813989d0427624f7901232084916170',
  'spatie/temporary-directory' => '2.3.0@580eddfe9a0a41a902cac6eeb8f066b42e65a32b',
  'stripe/stripe-php' => 'v7.128.0@c704949c49b72985c76cc61063aa26fefbd2724e',
  'swiftmailer/swiftmailer' => 'v6.3.0@8a5d5072dca8f48460fce2f4131fcc495eec654c',
  'symfony/console' => 'v5.4.47@c4ba980ca61a9eb18ee6bcc73f28e475852bb1ed',
  'symfony/css-selector' => 'v7.2.0@601a5ce9aaad7bf10797e3663faefce9e26c24e2',
  'symfony/deprecation-contracts' => 'v3.5.1@74c71c939a79f7d5bf3c1ce9f5ea37ba0114c6f6',
  'symfony/dom-crawler' => 'v5.4.48@b57df76f4757a9a8dfbb57ba48d7780cc20776c6',
  'symfony/error-handler' => 'v5.4.46@d19ede7a2cafb386be9486c580649d0f9e3d0363',
  'symfony/event-dispatcher' => 'v6.4.13@0ffc48080ab3e9132ea74ef4e09d8dcf26bf897e',
  'symfony/event-dispatcher-contracts' => 'v3.5.1@7642f5e970b672283b7823222ae8ef8bbc160b9f',
  'symfony/finder' => 'v5.4.45@63741784cd7b9967975eec610b256eed3ede022b',
  'symfony/http-foundation' => 'v5.4.48@3f38b8af283b830e1363acd79e5bc3412d055341',
  'symfony/http-kernel' => 'v5.4.48@c2dbfc92b851404567160d1ecf3fb7d9b7bde9b0',
  'symfony/mime' => 'v5.4.45@8c1b9b3e5b52981551fc6044539af1d974e39064',
  'symfony/polyfill-ctype' => 'v1.31.0@a3cc8b044a6ea513310cbd48ef7333b384945638',
  'symfony/polyfill-iconv' => 'v1.31.0@48becf00c920479ca2e910c22a5a39e5d47ca956',
  'symfony/polyfill-intl-grapheme' => 'v1.31.0@b9123926e3b7bc2f98c02ad54f6a4b02b91a8abe',
  'symfony/polyfill-intl-idn' => 'v1.31.0@c36586dcf89a12315939e00ec9b4474adcb1d773',
  'symfony/polyfill-intl-normalizer' => 'v1.31.0@3833d7255cc303546435cb650316bff708a1c75c',
  'symfony/polyfill-mbstring' => 'v1.31.0@85181ba99b2345b0ef10ce42ecac37612d9fd341',
  'symfony/polyfill-php73' => 'v1.31.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.31.0@60328e362d4c2c802a54fcbf04f9d3fb892b4cf8',
  'symfony/process' => 'v5.4.47@5d1662fb32ebc94f17ddb8d635454a776066733d',
  'symfony/psr-http-message-bridge' => 'v2.3.1@581ca6067eb62640de5ff08ee1ba6850a0ee472e',
  'symfony/routing' => 'v5.4.48@dd08c19879a9b37ff14fd30dcbdf99a4cf045db1',
  'symfony/service-contracts' => 'v3.5.1@e53260aabf78fb3d63f8d79d69ece59f80d5eda0',
  'symfony/string' => 'v6.4.15@73a5e66ea2e1677c98d4449177c5a9cf9d8b4c6f',
  'symfony/translation' => 'v5.4.45@98f26acc99341ca4bab345fb14d7b1d7cb825bed',
  'symfony/translation-contracts' => 'v2.5.4@450d4172653f38818657022252f9d81be89ee9a8',
  'symfony/var-dumper' => 'v5.4.48@42f18f170aa86d612c3559cfb3bd11a375df32c8',
  'tijsverkoyen/css-to-inline-styles' => 'v2.3.0@0d72ac1c00084279c1816675284073c5a337c20d',
  'twilio/sdk' => '6.44.4@08aad5f377e2245b9cd7508e7762d95e7392fa4d',
  'unicodeveloper/laravel-paystack' => '1.2.0@4d540e081f63f8ceca42ded5668da8ec93a3a084',
  'vlucas/phpdotenv' => 'v5.6.1@a59a13791077fe3d44f90e7133eb68e7d22eaff2',
  'voku/portable-ascii' => '1.6.1@87337c91b9dfacee02452244ee14ab3c43bc485a',
  'vonage/client' => '2.4.0@29f23e317d658ec1c3e55cf778992353492741d7',
  'vonage/client-core' => '2.10.1@0e5c6bf4af22cae60a3f1098b75c25d70bac242f',
  'vonage/nexmo-bridge' => '0.1.2@e9f63cd468b7e0edd73d0c90d0406d6b961f9eb7',
  'webmozart/assert' => '1.11.0@11cb2199493b2f8a3b53e7f19068fc6aac760991',
  'amirami/localizator' => 'v0.7.1-alpha@f61264953cb59fbec4a9d8fb3feaec27ce9c47aa',
  'barryvdh/laravel-debugbar' => 'v3.7.0@3372ed65e6d2039d663ed19aa699956f9d346271',
  'doctrine/instantiator' => '2.0.0@c6222283fa3f4ac679f8b9ced9a4e23f163e80d0',
  'facade/flare-client-php' => '1.10.0@213fa2c69e120bca4c51ba3e82ed1834ef3f41b8',
  'facade/ignition' => '2.17.7@b4f5955825bb4b74cba0f94001761c46335c33e9',
  'facade/ignition-contracts' => '1.0.2@3c921a1cdba35b68a7f0ccffc6dffc1995b18267',
  'fakerphp/faker' => 'v1.24.1@e0ee18eb1e6dc3cda3ce9fd97e5a0689a88a64b5',
  'filp/whoops' => '2.17.0@075bc0c26631110584175de6523ab3f1652eb28e',
  'hamcrest/hamcrest-php' => 'v2.0.1@8c3d0a3f6af734494ad8f6fbbee0ba92422859f3',
  'laravel/sail' => 'v1.25.0@e81a7bd7ac1a745ccb25572830fecf74a89bb48a',
  'maximebf/debugbar' => 'v1.23.5@eeabd61a1f19ba5dcd5ac4585a477130ee03ce25',
  'mockery/mockery' => '1.6.12@1f4efdd7d3beafe9807b08156dfcb176d18f1699',
  'nunomaduro/collision' => 'v5.11.0@8b610eef8582ccdc05d8f2ab23305e2d37049461',
  'phar-io/manifest' => '2.0.4@54750ef60c58e43759730615a392c31c80e23176',
  'phar-io/version' => '3.2.1@4f7fd7836c6f332bb2933569e566a0d6c4cbed74',
  'phpunit/php-code-coverage' => '9.2.32@85402a822d1ecf1db1096959413d35e1c37cf1a5',
  'phpunit/php-file-iterator' => '3.0.6@cf1c2e7c203ac650e352f4cc675a7021e7d1b3cf',
  'phpunit/php-invoker' => '3.1.1@5a10147d0aaf65b58940a0b72f71c9ac0423cc67',
  'phpunit/php-text-template' => '2.0.4@5da5f67fc95621df9ff4c4e5a84d6a8a2acf7c28',
  'phpunit/php-timer' => '5.0.3@5a63ce20ed1b5bf577850e2c4e87f4aa902afbd2',
  'phpunit/phpunit' => '9.6.22@f80235cb4d3caa59ae09be3adf1ded27521d1a9c',
  'sebastian/cli-parser' => '1.0.2@2b56bea83a09de3ac06bb18b92f068e60cc6f50b',
  'sebastian/code-unit' => '1.0.8@1fc9f64c0927627ef78ba436c9b17d967e68e120',
  'sebastian/code-unit-reverse-lookup' => '2.0.3@ac91f01ccec49fb77bdc6fd1e548bc70f7faa3e5',
  'sebastian/comparator' => '4.0.8@fa0f136dd2334583309d32b62544682ee972b51a',
  'sebastian/complexity' => '2.0.3@25f207c40d62b8b7aa32f5ab026c53561964053a',
  'sebastian/diff' => '4.0.6@ba01945089c3a293b01ba9badc29ad55b106b0bc',
  'sebastian/environment' => '5.1.5@830c43a844f1f8d5b7a1f6d6076b784454d8b7ed',
  'sebastian/exporter' => '4.0.6@78c00df8f170e02473b682df15bfcdacc3d32d72',
  'sebastian/global-state' => '5.0.7@bca7df1f32ee6fe93b4d4a9abbf69e13a4ada2c9',
  'sebastian/lines-of-code' => '1.0.4@e1e4a170560925c26d424b6a03aed157e7dcc5c5',
  'sebastian/object-enumerator' => '4.0.4@5c9eeac41b290a3712d88851518825ad78f45c71',
  'sebastian/object-reflector' => '2.0.4@b4f479ebdbf63ac605d183ece17d8d7fe49c15c7',
  'sebastian/recursion-context' => '4.0.5@e75bd0f07204fec2a0af9b0f3cfe97d05f92efc1',
  'sebastian/resource-operations' => '3.0.4@05d5692a7993ecccd56a03e40cd7e5b09b1d404e',
  'sebastian/type' => '3.2.1@75e2c2a32f5e0b3aef905b9ed0b179b953b3d7c7',
  'sebastian/version' => '3.0.2@c6c1022351a901512170118436c764e473f6de8c',
  'symfony/yaml' => 'v6.4.13@e99b4e94d124b29ee4cf3140e1b537d2dad8cec9',
  'theseer/tokenizer' => '1.2.3@737eda637ed5e28c3413cb1ebe8bb52cbf1ca7a2',
  'laravel/laravel' => '1.0.0+no-version-set@',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
