<?php $__env->startSection('title', \App\CPU\translate('Product List')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">  <!-- Page Heading -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a
                        href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(\App\CPU\translate('Dashboard')); ?></a></li>
                <?php if($pro['data'] != null && $pro->first()->request_status == 0): ?>
                    <li class="breadcrumb-item"
                        aria-current="page"><?php echo e(\App\CPU\translate('New')); ?> <?php echo e(\App\CPU\translate('Products')); ?></li>
                <?php elseif($pro['data'] != null && $pro->first()->request_status == 1): ?>
                    <li class="breadcrumb-item"
                        aria-current="page"><?php echo e(\App\CPU\translate('Approved')); ?> <?php echo e(\App\CPU\translate('Products')); ?></li>
                <?php elseif($pro['data'] != null && $pro->first()->request_status == 2): ?>
                    <li class="breadcrumb-item"
                        aria-current="page"><?php echo e(\App\CPU\translate('Denied')); ?> <?php echo e(\App\CPU\translate('Products')); ?></li>
                <?php else: ?>
                    <li class="breadcrumb-item" aria-current="page"><?php echo e(\App\CPU\translate('Products')); ?>  </li>
                <?php endif; ?>
            </ol>
        </nav>

        <div class="row __mt-20">
            <div class="col-md-12">
                <div class="card">
                    <?php if($pro->first() != null && $pro->first()->added_by == 'in_house'): ?>
                        <div class="card-header">
                            <h5><?php echo e(\App\CPU\translate('product_table')); ?></h5>
                            <a href="<?php echo e(route('admin.product.add-new')); ?>" class="btn btn--primary  float-right">
                                <i class="tio-add-circle"></i>
                                <span class="text"><?php echo e(\App\CPU\translate('Add new product')); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="datatable"
                                   class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Product Name')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('purchase_price')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('selling_price')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('verify_status')); ?></th>
                                    <?php if($pro->first() != null && $pro->first()->request_status != 2): ?>
                                        <th><?php echo e(\App\CPU\translate('featured')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Active')); ?> <?php echo e(\App\CPU\translate('status')); ?></th>
                                    <?php endif; ?>
                                    <th class="text-center __w-5px"><?php echo e(\App\CPU\translate('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $pro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <th scope="row"><?php echo e($k+1); ?></th>
                                        <td>
                                            <a href="<?php echo e(route('admin.product.view',[$p['id']])); ?>">
                                                <?php echo e(substr($p['name'],0,20)); ?><?php echo e(strlen($p['name'])>20?'...':''); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['purchase_price']))); ?>

                                        </td>
                                        <td>
                                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['unit_price']))); ?>

                                        </td>
                                        <td>
                                            <?php if($p->request_status == 0): ?>
                                                <label class="badge badge-warning"><?php echo e(\App\CPU\translate('New Request')); ?></label>
                                            <?php elseif($p->request_status == 1): ?>
                                                <label class="badge badge-success"><?php echo e(\App\CPU\translate('Approved')); ?></label>
                                            <?php elseif($p->request_status == 2): ?>
                                                <label class="badge badge-danger"><?php echo e(\App\CPU\translate('Denied')); ?></label>
                                            <?php endif; ?>
                                        </td>
                                        <?php if($p->request_status != 2): ?>
                                            <td>
                                                <label class="switch">
                                                    <input type="checkbox"
                                                           onclick="featured_status('<?php echo e($p['id']); ?>')" <?php echo e($p->featured == 1?'checked':''); ?>>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                            <td>
                                                <label class="switch switch-status">
                                                    <input type="checkbox" class="status"
                                                           id="<?php echo e($p['id']); ?>" <?php echo e($p->status == 1?'checked':''); ?>>
                                                    <span class="slider round"></span>
                                                </label>
                                            </td>
                                        <?php endif; ?>
                                        <td>
                                            <a class="btn btn--primary btn-sm"
                                               href="<?php echo e(route('admin.product.edit',[$p['id']])); ?>">
                                                <i class="tio-edit"></i><?php echo e(\App\CPU\translate('Edit')); ?>

                                            </a>
                                            <a class="btn btn-danger btn-sm" href="javascript:"
                                               onclick="form_alert('product-<?php echo e($p['id']); ?>','Want to delete this item ?')">
                                                <i class="tio-add-to-trash"></i> <?php echo e(\App\CPU\translate('Delete')); ?>

                                            </a>
                                            <form action="<?php echo e(route('admin.product.delete',[$p['id']])); ?>"
                                                  method="post" id="product-<?php echo e($p['id']); ?>">
                                                <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        <?php echo e($pro->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <!-- Page level custom scripts -->
    <script>

        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.product.status-update')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    console.log(data)
                    if (data.success == true) {
                        toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                    } else {
                        toastr.error('<?php echo e(\App\CPU\translate('Status updated failed. Product must be approved')); ?>');
                        location.reload();
                    }
                }
            });
        });

        function featured_status(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.product.featured-status')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function () {
                    toastr.success('<?php echo e(\App\CPU\translate('Featured status updated successfully')); ?>');
                }
            });
        }

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/product/list-seller.blade.php ENDPATH**/ ?>