<?php $__env->startSection('title',\App\CPU\translate('My Loyalty Point')); ?>

<?php $__env->startSection('content'); ?>

    <div class="container text-center">
        <h3 class="headerTitle my-3"><?php echo e(\App\CPU\translate('my_loyalty_point')); ?></h3>
    </div>

    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-4 mt-3 rtl"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <!-- Sidebar-->
        <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content  -->
            <section class="col-lg-9 col-md-9">
                <?php
                    $wallet_status = App\CPU\Helpers::get_business_settings('wallet_status');
                    $loyalty_point_status = App\CPU\Helpers::get_business_settings('loyalty_point_status');
                ?>
                <div class="card __card">
                    <div class="card-header border-0">
                        <div class="d-flex flex-wrap __gap-6 justify-content-between align-items-center __gap-15">
                            <div>
                                <span>
                                    <?php echo e(\App\CPU\translate('loyalty_point_history')); ?>

                                </span>
                            </div>
                            <div>
                                <span>
                                    <?php echo e(\App\CPU\translate('total_loyalty_point')); ?> : <?php echo e($total_loyalty_point); ?>

                                </span>
                            </div>
                            <div>
                                <?php if($wallet_status == 1 && $loyalty_point_status == 1): ?>
                                <button type="button" class="btn btn--primary" data-toggle="modal" data-target="#convertToCurrency">
                                    <?php echo e(\App\CPU\translate('convert_to_currency')); ?>

                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table __table">
                                <thead class="thead-light">
                                <tr>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO "><?php echo e(\App\CPU\translate('SL')); ?></span></div>
                                    </td>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO"><?php echo e(\App\CPU\translate('transaction_type')); ?> </span>
                                        </div>
                                    </td>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO"><?php echo e(\App\CPU\translate('credit')); ?> </span>
                                        </div>
                                    </td>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('debit')); ?></span></div>
                                    </td>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('balance')); ?></span></div>
                                    </td>
                                    <td class="tdBorder">
                                        <div class="py-2"><span
                                                class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('date')); ?></span></div>
                                    </td>
                                </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $loyalty_point_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="bodytr">
                                            <?php echo e($loyalty_point_list->firstItem()+$key); ?>

                                        </td>
                                        <td class="bodytr"><span class="text-capitalize"><?php echo e(str_replace('_', ' ',$item['transaction_type'])); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e($item['credit']); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e($item['debit']); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e($item['balance']); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e($item['created_at']); ?></span></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php if($loyalty_point_list->count()==0): ?>
                                <center class="mt-3 mb-2"><?php echo e(\App\CPU\translate('no_transaction_found')); ?></center>
                            <?php endif; ?>
                            <div class="card-footer border-0">
                                <?php echo e($loyalty_point_list->links()); ?>

                            </div>
                        </div>

                    </div>
                </div>
            </section>
        </div>
    </div>


  <!-- Modal -->
  <div class="modal fade rtl" id="convertToCurrency" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(\App\CPU\translate('convert_to_currency')); ?></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('loyalty-exchange-currency')); ?>" method="POST">
            <?php echo csrf_field(); ?>
        <div class="modal-body">
            <div class="text-start">
                    <?php echo e(\App\CPU\translate('your loyalty point will convert to currency and transfer to your wallet')); ?>

            </div>
            <div class="text-center">
                <span class="text-warning">
                    <?php echo e(\App\CPU\translate('minimum point for convert to currency is :')); ?> <?php echo e(App\CPU\Helpers::get_business_settings('loyalty_point_minimum_point')); ?> <?php echo e(\App\CPU\translate('point')); ?>

                </span>
            </div>
            <div class="text-center">
                <span >
                    <?php echo e(App\CPU\Helpers::get_business_settings('loyalty_point_exchange_rate')); ?> <?php echo e(\App\CPU\translate('point')); ?> = <?php echo e(\App\CPU\Helpers::currency_converter(1)); ?>

                </span>
            </div>

            <div class="form-row">
                <div class="form-group col-12">

                    <input class="form-control" type="number" id="city" name="point" required>
                </div>
            </div>

        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(\App\CPU\translate('close')); ?></button>
          <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('submit')); ?></button>
        </div>
    </form>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/user-loyalty.blade.php ENDPATH**/ ?>