<?php $__env->startSection('title',\App\CPU\translate('My Address')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link rel="stylesheet" media="screen"
          href="<?php echo e(asset('public/assets/front-end')); ?>/vendor/nouislider/distribute/nouislider.min.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/front-end/css/bootstrap-select.min.css')); ?>">

    <style>
        .cz-sidebar-body h3:hover + .divider-role {
            border-bottom: 3px solid <?php echo e($web_config['primary_color']); ?> !important;
        }
        .nav-pills .nav-link.active, .nav-pills .show > .nav-link {
            background-color: <?php echo e($web_config['primary_color']); ?>;
        }

        .iconHad {
            color: <?php echo e($web_config['primary_color']); ?>;
        }
        .namHad {
            padding-<?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>: 13px;
        }
        .donate-now li {
            margin: <?php echo e(Session::get('direction') === "rtl" ? '0 0 0 5px' : '0 5px 0 0'); ?>;
        }
        .donate-now input[type="radio"]:checked + label,
        .Checked + label {
            background: <?php echo e($web_config['primary_color']); ?>;
        }
        .filter-option{
            display: block;
            width: 100%;
            height: calc(1.5em + 1.25rem + 2px);
            padding: 0.625rem 1rem;
            font-size: .9375rem;
            font-weight: 400;
            line-height: 1.5;
            color: #4b566b;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #dae1e7;
            border-radius: 0.3125rem;
            box-shadow: 0 0 0 0 transparent;
            transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .btn-light + .dropdown-menu{
            transform: none !important;
            top: 41px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container pb-5 mb-2 mb-md-4 rtl __account-address" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
    <h2 class="text-center py-3 m-0 headerTitle"><?php echo e(\App\CPU\translate('UPDATE_ADDRESSES')); ?></h2>
    <div class="row">
        <!-- Sidebar-->
    <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="col-lg-9 col-md-9">

            <div class="card">
                <div class="card-body">
                    <div class="col-12">
                        <form action="<?php echo e(route('address-update')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="row pb-1">
                                <div class="col-md-6">
                                    <!-- Nav pills -->
                                    <input type="hidden" name="id" value="<?php echo e($shippingAddress->id); ?>">
                                    <ul class="donate-now">
                                        <li class="address_type_li">
                                            <input type="radio" class="address_type" id="a25" name="addressAs" value="permanent"  <?php echo e($shippingAddress->address_type == 'permanent' ? 'checked' : ''); ?> />
                                            <label for="a25" class="component"><?php echo e(\App\CPU\translate('permanent')); ?></label>
                                        </li>
                                        <li class="address_type_li">
                                            <input type="radio" class="address_type" id="a50" name="addressAs" value="home" <?php echo e($shippingAddress->address_type == 'home' ? 'checked' : ''); ?> />
                                            <label for="a50" class="component"><?php echo e(\App\CPU\translate('Home')); ?></label>
                                        </li>
                                        <li class="address_type_li">
                                            <input type="radio" class="address_type" id="a75" name="addressAs" value="office" <?php echo e($shippingAddress->address_type == 'office' ? 'checked' : ''); ?>/>
                                            <label for="a75" class="component"><?php echo e(\App\CPU\translate('Office')); ?></label>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <!-- Nav pills -->
                                    <input type="hidden" id="is_billing" value="<?php echo e($shippingAddress->is_billing); ?>">
                                    <ul class="donate-now">
                                        <li class="address_type_bl">
                                            <input type="radio" class="bill_type" id="b25" name="is_billing" value="0"  <?php echo e($shippingAddress->is_billing == '0' ? 'checked' : ''); ?> />
                                            <label for="b25" class="component"><?php echo e(\App\CPU\translate('shipping')); ?></label>
                                        </li>
                                        <li class="address_type_bl">
                                            <input type="radio" class="bill_type" id="b50" name="is_billing" value="1" <?php echo e($shippingAddress->is_billing == '1' ? 'checked' : ''); ?> />
                                            <label for="b50" class="component"><?php echo e(\App\CPU\translate('billing')); ?></label>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                            <!-- Tab panes -->
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="person_name"><?php echo e(\App\CPU\translate('contact_person_name')); ?></label>
                                    <input class="form-control" type="text" id="person_name"
                                        name="name"
                                        value="<?php echo e($shippingAddress->contact_person_name); ?>"
                                        required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="own_phone"><?php echo e(\App\CPU\translate('Phone')); ?></label>
                                    <input class="form-control" type="text" id="own_phone" name="phone" value="<?php echo e($shippingAddress->phone); ?>" required="required">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="city"><?php echo e(\App\CPU\translate('City')); ?></label>

                                    <input class="form-control" type="text" id="city" name="city" value="<?php echo e($shippingAddress->city); ?>" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="zip_code"><?php echo e(\App\CPU\translate('zip_code')); ?></label>
                                    <?php if($zip_restrict_status): ?>
                                        <select name="zip" class="form-control selectpicker" data-live-search="true" id="" required>
                                            <?php $__currentLoopData = $delivery_zipcodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($zip->zipcode); ?>" <?php echo e($zip->zipcode == $shippingAddress->zip? 'selected' : ''); ?>><?php echo e($zip->zipcode); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php else: ?>
                                        <input class="form-control" type="text" id="zip_code" name="zip" value="<?php echo e($shippingAddress->zip); ?>" required>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="city"><?php echo e(\App\CPU\translate('Country')); ?></label>
                                    <select name="country" class="form-control selectpicker" data-live-search="true" id="" required>
                                        <?php if($country_restrict_status): ?>
                                            <?php $__currentLoopData = $delivery_countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country['name']); ?>" <?php echo e($country['name'] == $shippingAddress->country? 'selected' : ''); ?>><?php echo e($country['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php $__currentLoopData = COUNTRIES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country['name']); ?>" <?php echo e($shippingAddress->country == $country['name']? 'selected' : ''); ?>><?php echo e($country['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label for="own_address"><?php echo e(\App\CPU\translate('address')); ?></label>
                                    <textarea class="form-control" id="address"
                                        type="text"  name="address" required><?php echo e($shippingAddress->address); ?></textarea>
                                </div>
                                <div class="form-group col-md-12">
                                    <input id="pac-input" class="controls rounded __inline-46" title="<?php echo e(\App\CPU\translate('search_your_location_here')); ?>" type="text" placeholder="<?php echo e(\App\CPU\translate('search_here')); ?>"/>
                                    <div class="__h-200px" id="location_map_canvas"></div>
                                </div>
                            </div>
                            <?php ($shipping_latitude=$shippingAddress->latitude); ?>
                            <?php ($shipping_longitude=$shippingAddress->longitude); ?>
                            <input type="hidden" id="latitude"
                                name="latitude" class="form-control d-inline"
                                placeholder="Ex : -94.22213" value="<?php echo e($shipping_latitude??0); ?>" required readonly>
                            <input type="hidden"
                                name="longitude" class="form-control"
                                placeholder="Ex : 103.344322" id="longitude" value="<?php echo e($shipping_longitude??0); ?>" required readonly>
                            <div class="modal-footer">
                                <a href="<?php echo e(route('account-address')); ?>" class="closeB btn btn-secondary"><?php echo e(\App\CPU\translate('close')); ?></a>
                                <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('update')); ?>  </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

    </section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(\App\CPU\Helpers::get_business_settings('map_api_key')); ?>&libraries=places&v=3.49"></script>
<script src="<?php echo e(asset('public/assets/front-end/js/bootstrap-select.min.js')); ?>"></script>
<script>

    function initAutocomplete() {
        var myLatLng = { lat: <?php echo e($shipping_latitude??'-33.8688'); ?>, lng: <?php echo e($shipping_longitude??'151.2195'); ?> };

        const map = new google.maps.Map(document.getElementById("location_map_canvas"), {
            center: { lat: <?php echo e($shipping_latitude??'-33.8688'); ?>, lng: <?php echo e($shipping_longitude??'151.2195'); ?> },
            zoom: 13,
            mapTypeId: "roadmap",
        });

        var marker = new google.maps.Marker({
            position: myLatLng,
            map: map,
        });

        marker.setMap( map );
        var geocoder = geocoder = new google.maps.Geocoder();
        google.maps.event.addListener(map, 'click', function (mapsMouseEvent) {
            var coordinates = JSON.stringify(mapsMouseEvent.latLng.toJSON(), null, 2);
            var coordinates = JSON.parse(coordinates);
            var latlng = new google.maps.LatLng( coordinates['lat'], coordinates['lng'] ) ;
            marker.setPosition( latlng );
            map.panTo( latlng );

            document.getElementById('latitude').value = coordinates['lat'];
            document.getElementById('longitude').value = coordinates['lng'];

            geocoder.geocode({ 'latLng': latlng }, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    if (results[1]) {
                        document.getElementById('address').value = results[1].formatted_address;
                        console.log(results[1].formatted_address);
                    }
                }
            });
        });

        // Create the search box and link it to the UI element.
        const input = document.getElementById("pac-input");
        const searchBox = new google.maps.places.SearchBox(input);
        map.controls[google.maps.ControlPosition.TOP_CENTER].push(input);
        // Bias the SearchBox results towards current map's viewport.
        map.addListener("bounds_changed", () => {
            searchBox.setBounds(map.getBounds());
        });
        let markers = [];
        // Listen for the event fired when the user selects a prediction and retrieve
        // more details for that place.
        searchBox.addListener("places_changed", () => {
            const places = searchBox.getPlaces();

            if (places.length == 0) {
            return;
            }
            // Clear out the old markers.
            markers.forEach((marker) => {
            marker.setMap(null);
            });
            markers = [];
            // For each place, get the icon, name and location.
            const bounds = new google.maps.LatLngBounds();
            places.forEach((place) => {
                if (!place.geometry || !place.geometry.location) {
                    console.log("Returned place contains no geometry");
                    return;
                }
                var mrkr = new google.maps.Marker({
                    map,
                    title: place.name,
                    position: place.geometry.location,
                });

                google.maps.event.addListener(mrkr, "click", function (event) {
                    document.getElementById('latitude').value = this.position.lat();
                    document.getElementById('longitude').value = this.position.lng();

                });

                markers.push(mrkr);

                if (place.geometry.viewport) {
                    // Only geocodes have viewport.
                    bounds.union(place.geometry.viewport);
                } else {
                    bounds.extend(place.geometry.location);
                }
            });
            map.fitBounds(bounds);
        });
    };
    $(document).on('ready', function () {
        initAutocomplete();

    });

    $(document).on("keydown", "input", function(e) {
      if (e.which==13) e.preventDefault();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/account-address-edit.blade.php ENDPATH**/ ?>