<?php $__env->startSection('title', \App\CPU\translate('Earning_Statement')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/add-new-seller.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('earning_statement')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        <?php echo $__env->make('admin-views.delivery-man.pages-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="card mb-3">
            <div class="card-body">

                <div class="row justify-content-between align-items-center g-2 mb-3">
                    <div class="col-sm-6">
                        <h4 class="d-flex align-items-center text-capitalize gap-10 mb-0">
                            <?php echo e(\App\CPU\translate('earning_statement')); ?>

                        </h4>
                    </div>
                </div>

                <div class="row g-2">
                    <div class="col-sm-6 col-lg-4">
                        <!-- Total Earning Card -->
                        <div class="business-analytics">
                            <h5 class="business-analytics__subtitle"><?php echo e(\App\CPU\translate('total_earning')); ?></h5>
                            <h2 class="business-analytics__title"><?php echo e($total_earn ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($total_earn)) : \App\CPU\BackEndHelper::set_symbol(0)); ?></h2>
                            <img src="<?php echo e(asset('public/assets/back-end/img/aw.png')); ?>" width="40" class="business-analytics__img" alt="">
                        </div>
                        <!-- End Total Earning Card -->
                    </div>
                    <div class="col-sm-6 col-lg-4">
                        <!-- Withdrawable balance Card -->
                        <div class="business-analytics">
                            <h5 class="business-analytics__subtitle"><?php echo e(\App\CPU\translate('withdrawable_balance')); ?></h5>
                            <h2 class="business-analytics__title"><?php echo e($withdrawable_balance <= 0 ? \App\CPU\BackEndHelper::set_symbol(0) : \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($withdrawable_balance))); ?></h2>
                            <img src="<?php echo e(asset('public/assets/back-end/img/pw.png')); ?>" width="40" class="business-analytics__img" alt="">
                        </div>
                        <!-- End Withdrawable balance Card -->
                    </div>
                    <div class="col-sm-6 col-lg-4">
                        <!-- Business Analytics Card -->
                        <div class="business-analytics">
                            <h5 class="business-analytics__subtitle"><?php echo e(\App\CPU\translate('withdrawn')); ?></h5>
                            <h2 class="business-analytics__title"><?php echo e($delivery_man->wallet? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($delivery_man->wallet->total_withdraw)) : \App\CPU\BackEndHelper::set_symbol(0)); ?></h2>
                            <img src="<?php echo e(asset('public/assets/back-end/img/withdraw.png')); ?>" width="40" class="business-analytics__img" alt="">
                        </div>
                        <!-- End Business Analytics Card -->
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <div class="px-3 py-4">
                    <div class="row align-items-center">
                        <div class="col-md-4 col-lg-6 mb-2 mb-md-0">
                            <h4 class="d-flex align-items-center text-capitalize gap-10 mb-0">
                                <?php echo e(\App\CPU\translate('earning_statement')); ?>

                                <span class="badge badge-soft-dark radius-50 fz-12 ml-1"><?php echo e($orders->total()); ?></span>
                            </h4>
                        </div>
                        <div class="col-md-8 col-lg-6">
                            <div class="d-flex align-items-center justify-content-md-end flex-wrap flex-sm-nowrap gap-2">
                                <!-- Search -->
                                <form action="" method="GET">
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Search_by_order_no')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>">
                                        <button type="submit" class="btn btn--primary">
                                            <?php echo e(\App\CPU\translate('Search')); ?>

                                        </button>
                                    </div>
                                </form>
                                <!-- End Search -->
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row g-2">
                    <div class="col-sm-12 mb-3">
                        <!-- Card -->
                        <div class="card">

                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table class="table table-hover table-borderless table-thead-bordered table-align-middle card-table text-left">
                                    <thead class="thead-light thead-50 text-capitalize table-nowrap">
                                    <tr>
                                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('order_no')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('earning')); ?></th>
                                        <th class="text-center"><?php echo e(\App\CPU\translate('status')); ?></th>
                                    </tr>
                                    </thead>

                                    <tbody id="set-rows">
                                    <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($orders->firstItem()+$key); ?></td>
                                        <td>
                                            <div class="media align-items-center gap-10 flex-wrap">
                                                <a class="title-color" title="<?php echo e(\App\CPU\translate('order_details')); ?>"
                                                   href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>">
                                                    <?php echo e($order->id); ?>

                                                </a>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-column gap-1">
                                                <div class="media-body"><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order->deliveryman_charge))); ?></div>

                                            </div>
                                        </td>
                                        <td class="text-center text-capitalize">
                                            <?php if($order['order_status']=='pending'): ?>
                                                <span class="badge badge-soft-info fz-12">
                                                    <?php echo e($order['order_status']); ?>

                                            </span>

                                            <?php elseif($order['order_status']=='processing' || $order['order_status']=='out_for_delivery'): ?>
                                                <span class="badge badge-soft-warning fz-12">
                                                <?php echo e(str_replace('_',' ',$order['order_status'] == 'processing' ? 'packaging':$order['order_status'])); ?>

                                            </span>
                                            <?php elseif($order['order_status']=='confirmed'): ?>
                                                <span class="badge badge-soft-success fz-12">
                                                <?php echo e($order['order_status']); ?>

                                            </span>
                                            <?php elseif($order['order_status']=='failed'): ?>
                                                <span class="badge badge-danger fz-12">
                                                <?php echo e($order['order_status'] == 'failed' ? 'Failed To Deliver' : ''); ?>

                                            </span>
                                            <?php elseif($order['order_status']=='delivered'): ?>
                                                <span class="badge badge-soft-success fz-12">
                                                <?php echo e($order['order_status']); ?>

                                            </span>
                                            <?php else: ?>
                                                <span class="badge badge-soft-danger fz-12">
                                                <?php echo e($order['order_status']); ?>

                                            </span>
                                            <?php endif; ?>
                                        </td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4">
                                                <div class="text-center p-4">
                                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end/svg/illustrations/sorry.svg')); ?>" alt="Image Description">
                                                    <p class="mb-0"><?php echo e(\App\CPU\translate('no_earning_history_found')); ?></p>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    </tbody>
                                </table>
                            </div>

                            <div class="table-responsive mt-4">
                                <div class="px-4 d-flex justify-content-lg-end">
                                    <!-- Pagination -->
                                    <?php echo e($orders->links()); ?>

                                </div>
                            </div>
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
        </div>

    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/delivery-man/earning-statement/earning.blade.php ENDPATH**/ ?>