<?php $__env->startSection('title', \App\CPU\translate('General Setting')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Heading -->
    <div class="content container-fluid">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(\App\CPU\translate('Dashboard')); ?></a></li>
            <li class="breadcrumb-item" aria-current="page"><?php echo e(\App\CPU\translate('General settings')); ?></li>
        </ol>
    </nav>

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-2">
        <h4 class="mb-0 text-black-50"><?php echo e(\App\CPU\translate('General Business Settings')); ?></h4>
    </div>

    <div class="row __mt-20">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row justify-content-between pl-4 pr-4">
                        <div>
                            <h5><?php echo e(\App\CPU\translate('Language Table')); ?></h5>
                        </div>
                    </div>
                </div>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="table_id" class="display table table-hover">
                                <thead>
                                <tr>
                                    <th scope="col">#<?php echo e(\App\CPU\translate('SL')); ?></th>
                                    <th scope="col"><?php echo e(\App\CPU\translate('ID')); ?></th>
                                    <th scope="col"><?php echo e(\App\CPU\translate('Name')); ?></th>
                                    <th scope="col"><?php echo e(\App\CPU\translate('Code')); ?></th>
                                    <th scope="col"><?php echo e(\App\CPU\translate('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php ($language=App\Model\BusinessSetting::where('type','language')->first()); ?>
                                <?php $__currentLoopData = json_decode($language['value'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td><?php echo e($data['id']); ?></td>
                                        <td><?php echo e($data['name']); ?></td>
                                        <td><?php echo e($data['code']); ?></td>
                                        <td class="__w-100px">
                                            <label class="switch">
                                                <input type="checkbox" onclick="updateStatus('<?php echo e(route('admin.business-settings.update-language')); ?>','<?php echo e($data['id']); ?>')"
                                                       class="status" <?php echo e($data['status']==1?'checked':''); ?>>
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });

        function updateStatus(route,id) {
            $.get({
                url: route,
                data: {
                    id: id,
                },
                success: function (data) {
                   /* console.log(data)*/
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/business-settings/general-settings.blade.php ENDPATH**/ ?>