<?php $__env->startSection('title', \App\CPU\translate('Employee List')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/employee.png')); ?>" width="20" alt="">
                <?php echo e(\App\CPU\translate('employee_list')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header flex-wrap gap-10">
                        <h5 class="mb-0 d-flex gap-2 align-items-center">
                            <?php echo e(\App\CPU\translate('employee_table')); ?>

                            <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($em->total()); ?></span>
                        </h5>
                        <div>
                            <!-- Search -->
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <div class="input-group input-group-merge input-group-custom">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input type="search" name="search" class="form-control"
                                           placeholder="<?php echo e(\App\CPU\translate('search_by_name_or_email_or_phone')); ?>"
                                           value="<?php echo e($search); ?>" required>
                                    <button type="submit"
                                            class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                </div>
                            </form>
                            <!-- End Search -->
                        </div>
                        <div class="d-flex justify-content-end">
                            <a href="<?php echo e(route('admin.employee.add-new')); ?>" class="btn btn--primary">
                                <i class="tio-add"></i>
                                <span class="text"><?php echo e(\App\CPU\translate('Add')); ?> <?php echo e(\App\CPU\translate('New')); ?></span>
                            </a>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="datatable"
                               style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                               class="table table-hover table-borderless table-thead-bordered table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize table-nowrap">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Email')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Phone')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Role')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Status')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $em; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($e->role): ?>
                                    <tr>
                                        <th scope="row"><?php echo e($k+1); ?></th>
                                        <td class="text-capitalize"><?php echo e($e['name']); ?></td>
                                        <td>
                                            <?php echo e($e['email']); ?>

                                        </td>
                                        <td><?php echo e($e['phone']); ?></td>
                                        <td><?php echo e($e->role['name']); ?></td>
                                        <td>
                                            <label class="switcher">
                                                <input type="checkbox" class="switcher_input" id="<?php echo e($e['id']); ?>"
                                                       class="toggle-switch-input" <?php echo e($e->status?'checked':''); ?>>
                                                <span class="switcher_control"></span>
                                            </label>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                <a href="<?php echo e(route('admin.employee.update',[$e['id']])); ?>"
                                                   class="btn btn-outline--primary btn-sm square-btn"
                                                   title="<?php echo e(\App\CPU\translate('Edit')); ?>">
                                                    <i class="tio-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($em->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).on('change', '.switcher_input', function () {
            let id = $(this).attr("id");

            let status = 0;
            if (jQuery(this).prop("checked") === true) {
                status = 1;
            }

            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure')); ?>?',
                text: '<?php echo e(\App\CPU\translate('want_to_change_status')); ?>',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                cancelButtonText: 'No',
                confirmButtonText: 'Yes',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(url('/')); ?>/admin/employee/status/",
                        method: 'POST',
                        data: {
                            id: id,
                            status: status
                        },
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                        }
                    });
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/employee/list.blade.php ENDPATH**/ ?>