
<?php $__env->startSection('title', \App\CPU\translate('home_service_request')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/back-end/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="mb-3 d-flex justify-content-between">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/message.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('maintain_home_service_banner')); ?>

            </h2>
        </div>
        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <form class="product-form" action="<?php echo e(route('admin.home-service.updateBanner')); ?>"
                            method="POST"style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;"
                            enctype="multipart/form-data" id="product_form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-8 form-group">
                                    <div class="mb-2">
                                        <label
                                            class="title-color"><?php echo e(\App\CPU\translate('Upload Home Service Banner Image')); ?></label>
                                        <span class="text-info">* ( <?php echo e(\App\CPU\translate('ratio')); ?> 1:1 )</span>
                                    </div>
                                    <div id="imgShowCase" class="row g-2 mb-4">
                                        <?php if($homeServiceBanner['image1'] != null): ?>
                                            <img class="upload-img-view" id="viewer" onclick="imgaeIndexSpecifier(1)"
                                                onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                                src="<?php echo e(asset('storage/app/public/HomeServiceBanner')); ?>/<?php echo e($homeServiceBanner['image1']); ?>"
                                                alt="Home Servie Banner Image" data-toggle="modal"
                                                data-target="#maintainImg" />
                                        <?php endif; ?>

                                        <?php if($homeServiceBanner['image2'] != null): ?>
                                            <img class="upload-img-view" id="viewer" onclick="imgaeIndexSpecifier(2)"
                                                onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                                src="<?php echo e(asset('storage/app/public/HomeServiceBanner')); ?>/<?php echo e($homeServiceBanner['image2']); ?>"
                                                alt="Home Servie Banner Image" data-toggle="modal"
                                                data-target="#maintainImg" />
                                        <?php endif; ?>

                                        <?php if($homeServiceBanner['image3'] != null): ?>
                                            <img class="upload-img-view" id="viewer" onclick="imgaeIndexSpecifier(3)"
                                                onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                                src="<?php echo e(asset('storage/app/public/HomeServiceBanner')); ?>/<?php echo e($homeServiceBanner['image3']); ?>"
                                                alt="Home Servie Banner Image" data-toggle="modal"
                                                data-target="#maintainImg" />
                                        <?php endif; ?>

                                        <?php if($homeServiceBanner['image4'] != null): ?>
                                            <img class="upload-img-view" id="viewer" onclick="imgaeIndexSpecifier(4)"
                                                onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                                src="<?php echo e(asset('storage/app/public/HomeServiceBanner')); ?>/<?php echo e($homeServiceBanner['image4']); ?>"
                                                alt="Home Servie Banner Image" data-toggle="modal"
                                                data-target="#maintainImg" />
                                        <?php endif; ?>

                                        <?php if($homeServiceBanner['image5'] != null): ?>
                                            <img class="upload-img-view" id="viewer" onclick="imgaeIndexSpecifier(5)"
                                                onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                                src="<?php echo e(asset('storage/app/public/HomeServiceBanner')); ?>/<?php echo e($homeServiceBanner['image5']); ?>"
                                                alt="Home Servie Banner Image" data-toggle="modal"
                                                data-target="#maintainImg" />
                                        <?php endif; ?>

                                    </div>
                                    <div class="p-2">
                                        <!-- <div class="row" id="coba"></div> -->
                                        <button class="btn btn--primary" type=button data-toggle="modal"
                                            data-target="#addImg">Add Banner</button>
                                        <!-- <input type="file" accept="image/png, image/gif, image/jpeg" name="file[]" id="filesSelector"> -->
                                    </div>
                                </div>
                            </div>
                            <div class="pt-3">
                                <?php ($language = \App\Model\BusinessSetting::where('type', 'pnc_language')->first()); ?>
                                <?php ($language = $language->value ?? null); ?>
                                <?php ($default_lang = 'en'); ?>

                                <?php ($default_lang = json_decode($language)[0]); ?>
                                <ul class="nav nav-tabs w-fit-content mb-4">
                                    <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a class="nav-link text-capitalize lang_link <?php echo e($lang == $default_lang ? 'active' : ''); ?>"
                                                href="#"
                                                id="<?php echo e($lang); ?>-link"><?php echo e(\App\CPU\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')'); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            <div class="card-body">
                                <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    // dd($homeServiceBanner);
                                    if (count($homeServiceBanner['translations'])) {
                                        $translate = [];
                                        foreach ($homeServiceBanner['translations'] as $t) {
                                            if ($t->locale == $lang && $t->key == 'description') {
                                                $translate[$lang]['description'] = $t->value;
                                            }
                                        }
                                    }
                                    ?>
                                    <div class="<?php echo e($lang != $default_lang ? 'd-none' : ''); ?> lang_form"
                                        id="<?php echo e($lang); ?>-form">
                                        <div class="form-group pt-4 col-12">
                                            <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                                            <label class="title-color"
                                                for="description"><?php echo e(\App\CPU\translate('content')); ?>

                                                (<?php echo e(strtoupper($lang)); ?>)
                                            </label>
                                            </br>
                                            <textarea name="description[]" class="textarea editor-textarea"><?php echo e($lang == $default_lang ? $homeServiceBanner['description'] : $translate[$lang]['description'] ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <button type="submit"class="btn btn--primary mt-3"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- maintain image modal -->
    <div class="modal fade" id="maintainImg" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form class="product-form" action="<?php echo e(route('admin.home-service.updateBannerImage')); ?>" method="POST"
                    style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;"enctype="multipart/form-data"
                    id="product_form">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Maintain Banner</h5>
                        <a type="button" title="Close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <input type="hidden" name="imageIndex" id="imageIndex">
                            <!-- <button class="btn btn-success mx-5">
                                                                                                                            <i class="tio tio-edit" title="edit"></i>
                                                                                                                        </button>
                                                                                                                        <button class="btn btn-danger mx-5">
                                                                                                                            <i class="tio tio-delete" title="delete"></i>
                                                                                                                        </button> -->
                            <input type="file" name="file[]" id="bannerUpdateImageInput" class="w-100"
                                accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">

                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <button type="submit" id="delBannerImage" onclick="updateValidation(0)" name="action"
                            value="delete" class="btn btn-secondary">Delete</button>
                        <button type="submit" id="upBannerImage" onclick="updateValidation(1)" name="action"
                            value="update" class="btn btn-primary">Update</button>
                        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Delete</button>
                                                                                                                    <button type="button" class="btn btn-primary">Save changes</button> -->
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Add image Modal -->

    <div class="modal fade" id="addImg" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form class="product-form" action="<?php echo e(route('admin.home-service.updateBanner')); ?>" method="POST"
                    style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;"enctype="multipart/form-data"
                    id="product_form">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Banner</h5>
                        <a type="button" title="Close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <input type="file" accept="image/png, image/gif, image/jpeg" name="file[]"
                                id="filesSelector">
                        </div>
                        <input type="hidden" name="description" value="<?php echo e($homeServiceBanner['description']); ?>">
                        <input type="hidden" name="content_arabic" value="<?php echo e($homeServiceBanner['content_arabic']); ?>">
                        <input type="hidden" name="content_khurdish"
                            value="<?php echo e($homeServiceBanner['content_khurdish']); ?>">
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <button value="Cancel" class="btn btn-secondary" data-dismiss="modal"
                            aria-label="Close">Cancel</button>
                        <button type="submit" value="Add" class="btn btn-primary">Add</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/tags-input.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end/js/spartan-multi-image-picker.js')); ?>"></script>
    <script>
        $("#filesSelector").change(function(event) {
            debugger
            if ($('#imgShowCase img').length > 5) {
                alert("You only can upload 5 images delete any to Upload");
                $("#filesSelector").val("");
            } else {
                data = new FormData();
                data.append('file', $(this)[0].files[0]);

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    type: 'POST',
                    url: "<?php echo e(route('admin.home-service.upload-banner')); ?>",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        console.log("success");
                        console.log(data);
                    },
                    error: function(data) {
                        console.log("error");
                        console.log(data);
                    }
                });

            }

        });

        function imgaeIndexSpecifier(index) {
            debugger
            document.getElementById("imageIndex").value = index;
        }
        // debugger
        // $("#imgShowCase").html("");

        // $.each(selectedFiles, function(key, value){
        //     let imgPath = "<?php echo e(asset('/')); ?>"+value;

        //     var imagePreview = $('<img>')
        //     .attr('src', URL.createObjectURL(value))
        //     .attr('name', "image" + imageCount)
        //     .attr('onclick', "remove(this)")
        //     .attr('height', "180px")
        //     .addClass('image-thumbnail')
        //     .addClass('col-4');
        //     $("#imgShowCase").append(imagePreview);

        // });


        $(document).ready(function() {
            $('.upload-img-view').click(function() {
                var index = $(this).data('index');
                // Populate the modal content and show the modal based on the retrieved index
                // You can use `index` to identify the clicked image and update modal content accordingly
            });
        });

        function updateValidation(bool) {

            const requiredInput = document.getElementById('bannerUpdateImageInput');

            if (bool == 1) {
                requiredInput.setAttribute('required', 'required');
            } else {
                requiredInput.removeAttribute('required');
            }
        }
        $(".lang_link").click(function(e) {
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#" + lang + "-form").removeClass('d-none');
            if (lang == '<?php echo e($default_lang); ?>') {
                $(".rest-part").removeClass('d-none');
            } else {
                $(".rest-part").addClass('d-none');
            }
        })
    </script>
    
    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '<?php echo e(Session::get('direction')); ?>',
        });
    </script>

    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/home-service/maintain-home-service.blade.php ENDPATH**/ ?>