<?php $__env->startSection('title', \App\CPU\translate('Customer Details')); ?>

<?php $__env->startPush('css_or_js'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="d-print-none pb-2">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">

                    <!-- Page Title -->
                    <div class="mb-3">
                        <h2 class="h1 mb-0 text-capitalize d-flex gap-2">
                            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/customer.png')); ?>" alt="">
                            <?php echo e(\App\CPU\translate('customer_details')); ?>

                        </h2>
                    </div>
                    <!-- End Page Title -->
                    <div class="d-sm-flex align-items-sm-center">
                        <h3 class="page-header-title"><?php echo e(\App\CPU\translate('Customer ID')); ?> #<?php echo e($customer['id']); ?></h3>
                        <span class="<?php echo e(Session::get('direction') === 'rtl' ? 'mr-2 mr-sm-3' : 'ml-2 ml-sm-3'); ?>">
                            <i class="tio-date-range">
                            </i> <?php echo e(\App\CPU\translate('Joined At')); ?> :
                            <?php echo e(date('d M Y H:i:s', strtotime($customer['created_at']))); ?>

                        </span>
                    </div>

                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                        <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home"
                            role="tab" aria-controls="nav-home"
                            aria-selected="true"><?php echo e(\App\CPU\translate('Order')); ?></a>
                        <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile"
                            role="tab" aria-controls="nav-profile"
                            aria-selected="false"><?php echo e(\App\CPU\translate('Pets')); ?></a>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                <div class="row" id="printableArea">
                    <div class="col-lg-8 mb-3 mb-lg-0">
                        <div class="card">
                            <div class="p-3 d-flex justify-content-between">
                                
                                <div>
                                    <div>
                                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                                            <!-- Search -->
                                            <div class="row">
                                                <div class="col-5">
                                                    <input id="datatableSearch_" type="search" name="search"
                                                        class="form-control"
                                                        placeholder="<?php echo e(\App\CPU\translate('Search orders')); ?>"
                                                        aria-label="Search orders" value="<?php echo e($search); ?>">
                                                </div>
                                                <div class="col-5">
                                                    <select name="filterByDebt" class="form-control">
                                                        <option value=""><?php echo e(\App\CPU\translate('All')); ?></option>
                                                        <option
                                                            value="unpaid"<?php echo e($request->input('filterByDebt') == 'unpaid' ? 'selected' : ''); ?>>
                                                            <?php echo e(\App\CPU\translate('outstanding_invoices')); ?></option>
                                                        <option value="paid"
                                                            <?php echo e($request->input('filterByDebt') == 'paid' ? 'selected' : ''); ?>>
                                                            <?php echo e(\App\CPU\translate('cleared_invoices')); ?></option>
                                                    </select>
                                                </div>
                                                <div class="col-2">
                                                    <button type="submit"
                                                        class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                                </div>
                                            </div>
                                            <!-- End Search -->
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                    <thead class="thead-light thead-50 text-capitalize">
                                        <tr>
                                            <th><?php echo e(\App\CPU\translate('sl')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Order ID')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Total')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Order')); ?> <?php echo e(\App\CPU\translate('Status')); ?></th>
                                            <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($orders->firstItem() + $key); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.orders.details', ['id' => $order['id']])); ?>"
                                                        class="title-color hover-c1"><?php echo e($order['id']); ?></a>
                                                </td>
                                                <td> <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order['order_amount']))); ?>

                                                </td>
                                                <td>
                                                    <?php if($order->payment_status == 'paid'): ?>
                                                        <span class="badge text-success fz-12 px-0">
                                                            <?php echo e(\App\CPU\translate('paid')); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="badge text-danger fz-12 px-0">
                                                            <?php echo e(\App\CPU\translate('unpaid')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <div class="d-flex justify-content-center gap-10">
                                                        <a class="btn btn-outline--primary btn-sm edit square-btn"
                                                            title="<?php echo e(\App\CPU\translate('View')); ?>"
                                                            href="<?php echo e(route('admin.orders.details', ['id' => $order['id']])); ?>"><i
                                                                class="tio-invisible"></i> </a>
                                                        <a class="btn-generate-invoice btn btn-outline-info btn-sm square-btn"
                                                            title="<?php echo e(\App\CPU\translate('Invoice')); ?>" target="_blank"
                                                            href="<?php echo e(route('admin.orders.generate-invoice', [$order['id']])); ?>"><i
                                                                class="tio-download"></i> </a>
                                                        <?php if($order->payment_status == 'paid'): ?>
                                                        <button disabled class="btn btn-secondary btn-outline-secondary btn-sm square-btn"
                                                            id="<?php echo e($order['id']); ?>"
                                                            title="<?php echo e(\App\CPU\translate('Paid')); ?>"><i
                                                                class="tio-checkmark-circle"></i> </button>
                                                        <?php else: ?>
                                                        <a class="btn btn-outline-info btn-sm square-btn markPaid"
                                                            id="<?php echo e($order['id']); ?>"
                                                            title="<?php echo e(\App\CPU\translate('Mark_as_Paid')); ?>"><i
                                                                class="tio-checkmark-circle"></i> </a>
                                                        <?php endif; ?>

                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <?php if(count($orders) == 0): ?>
                                    <div class="text-center p-4">
                                        <img class="mb-3 w-160"
                                            src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                            alt="Image Description">
                                        <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                                    </div>
                                <?php endif; ?>
                                <!-- Footer -->
                                <div class="card-footer">
                                    <!-- Pagination -->
                                    <?php echo $orders->links(); ?>

                                    <!-- End Pagination -->
                                </div>
                                <!-- End Footer -->
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <!-- Card -->
                        <div class="card">
                            <?php if($customer): ?>
                                <div class="card-body">
                                    <h4 class="mb-4 d-flex align-items-center gap-2">
                                        <img src="<?php echo e(asset('/public/assets/back-end/img/seller-information.png')); ?>"
                                            alt="">
                                        <?php echo e(\App\CPU\translate('Customer')); ?>

                                    </h4>

                                    <div class="media">
                                        <div class="mr-3">
                                            <img class="avatar rounded-circle avatar-70"
                                                onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                src="<?php echo e(asset('storage/app/public/profile/' . $customer->image ?? '')); ?>"
                                                alt="Image">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <span
                                                class="title-color hover-c1"><strong><?php echo e($customer['f_name'] . ' ' . $customer['l_name']); ?></strong></span>
                                            <span class="title-color">
                                                <strong><?php echo e(\App\Model\Order::where('customer_id', $customer['id'])->count()); ?>

                                                </strong><?php echo e(\App\CPU\translate('orders')); ?>

                                            </span>
                                            <span class="title-color">
                                                <strong><?php echo e(\App\Model\PetApproval::where('customerid', $customer['id'])->count()); ?>

                                                </strong><?php echo e(\App\CPU\translate('pets')); ?>

                                            </span>
                                            <span class="title-color"><strong><?php echo e($customer['phone']); ?></strong></span>
                                            <span class="title-color"><?php echo e($customer['email']); ?></span>
                                        </div>
                                        <div class="media-body text-right">
                                            
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- End Body -->
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                <div class="row" id="printableArea">
                    <div class="col-lg-8 mb-3 mb-lg-0">
                        <div class="card">
                            <div class="p-3">
                                <div class="row justify-content-end">
                                    <div class="col-auto">
                                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                                            <!-- Search -->
                                            <!-- <div class="input-group input-group-merge input-group-custom">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text">
                                                                <i class="tio-search"></i>
                                                            </div>
                                                        </div>
                                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                                            placeholder="<?php echo e(\App\CPU\translate('Search orders')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>"
                                                            required>
                                                        <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                                    </div> -->
                                            <!-- End Search -->
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                    <thead class="thead-light thead-50 text-capitalize">
                                        <tr>
                                            <th><?php echo e(\App\CPU\translate('sl')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Pet ID')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Name')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Type')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Gender')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Age')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Listing Type')); ?></th>
                                        </tr>

                                    </thead>

                                    <tbody>
                                        <?php
                                            $serialNumber = 1;
                                        ?>
                                        <?php $__currentLoopData = $pet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($serialNumber); ?></td>
                                                <td><?php echo e($item['id']); ?></td>
                                                <td><?php echo e($item['pet_name']); ?></td>
                                                <td><?php echo e($item['type']); ?></td>
                                                <td><?php echo e($item['gender']); ?></td>
                                                <td><?php echo e($item['age']); ?></td>
                                                <td><?php echo e($item['listing_type']); ?></td>
                                            </tr>
                                            <?php
                                                $serialNumber++;
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <?php if(count($pet) == 0): ?>
                                    <div class="text-center p-4">
                                        <img class="mb-3 w-160"
                                            src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                            alt="Image Description">
                                        <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                                    </div>
                                <?php endif; ?>
                                <!-- Footer -->
                                <div class="card-footer">
                                    <!-- Pagination -->
                                    <?php echo $pet->links(); ?>

                                    <!-- End Pagination -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <!-- Card -->
                        <div class="card">
                            <?php if($customer): ?>
                                <div class="card-body">
                                    <h4 class="mb-4 d-flex align-items-center gap-2">
                                        <img src="<?php echo e(asset('/public/assets/back-end/img/seller-information.png')); ?>"
                                            alt="">
                                        <?php echo e(\App\CPU\translate('Customer')); ?>

                                    </h4>

                                    <div class="media">
                                        <div class="mr-3">
                                            <img class="avatar rounded-circle avatar-70"
                                                onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                src="<?php echo e(asset('storage/app/public/profile/' . $customer->image ?? '')); ?>"
                                                alt="Image">
                                        </div>
                                        <div class="media-body d-flex flex-column gap-1">
                                            <span
                                                class="title-color hover-c1"><strong><?php echo e($customer['f_name'] . ' ' . $customer['l_name']); ?></strong></span>
                                            <span class="title-color">
                                                <strong><?php echo e(\App\Model\Order::where('customer_id', $customer['id'])->count()); ?>

                                                </strong><?php echo e(\App\CPU\translate('orders')); ?>

                                            </span>
                                            <span class="title-color">
                                                <strong><?php echo e(\App\Model\PetApproval::where('customerid', $customer['id'])->count()); ?>

                                                </strong><?php echo e(\App\CPU\translate('pets')); ?>

                                            </span>
                                            <span class="title-color"><strong><?php echo e($customer['phone']); ?></strong></span>
                                            <span class="title-color"><?php echo e($customer['email']); ?></span>
                                        </div>
                                        <div class="media-body text-right">
                                            
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <!-- End Body -->
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
        </div>





        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).on('click', '.markPaid', function() {
            var id = $(this).attr("id");
            Swal.fire({
                title: "<?php echo e(\App\CPU\translate('Are_you_sure_to_mark_paid')); ?>?",
                text: "<?php echo e(\App\CPU\translate('You_will_not_be_able_to_revert_this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('mark_it')); ?>!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(url('admin/customer/order-status-update')); ?>",
                        method: 'POST',
                        data: {
                            id: id
                        },
                        success: function(response) {
                            document.querySelector('.btn-generate-invoice').click();
                            toastr.success('<?php echo e(\App\CPU\translate('Order_marked_as_a_paid ')); ?>');
                            console.log(response);
                            $('#data-' + id).hide();
                            window.location.reload();
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                            toastr.error('<?php echo e(\App\CPU\translate('An_error_occurred ')); ?>');
                        }
                    });
                }
            });
        });

        function generateInvoice(id) {
            return new Promise(function(resolve, reject) {
                try {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(url('admin/orders/generate-invoice/')); ?>/" + id,
                        method: 'GET',
                        success: function(invoiceResponse) {
                            resolve(invoiceResponse);
                        },
                        error: function(invoiceXhr, invoiceStatus, invoiceError) {
                            reject(invoiceXhr);
                        }
                    });
                } catch (error) {
                    console.error(error)
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/customer/customer-view.blade.php ENDPATH**/ ?>