<?php $__env->startSection('title', \App\CPU\translate('Add Shipping')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/shipping_method.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('shipping_method')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row">
            <div class="col-md-12 ">
                <div class="card">
                    <div class="card-header text-capitalize">
                        <h5 class="mb-0"><?php echo e(\App\CPU\translate('choose_shipping_method')); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 text-capitalize" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                                <select class="form-control text-capitalize" name="shippingCategory" onchange="seller_shipping_type(this.value);">
                                    <option value="0" selected disabled>---<?php echo e(\App\CPU\translate('select')); ?>---</option>
                                    <option value="order_wise" <?php echo e($shippingType=='order_wise'?'selected':''); ?> ><?php echo e(\App\CPU\translate('order_wise')); ?> </option>
                                    <option  value="category_wise" <?php echo e($shippingType=='category_wise'?'selected':''); ?> ><?php echo e(\App\CPU\translate('category_wise')); ?></option>
                                    <option  value="product_wise" <?php echo e($shippingType=='product_wise'?'selected':''); ?>><?php echo e(\App\CPU\translate('product_wise')); ?></option>
                                </select>
                            </div>
                            <div class="col-12 mt-2" id="product_wise_note" style="display: none">
                                <p class="m-2" class="text-danger"><?php echo e(\App\CPU\translate('note')); ?>: <?php echo e(\App\CPU\translate("Please_make_sure_all_the product's_delivery_charges_are_up_to_date.")); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content Row -->
        <div id="order_wise_shipping">
            <div class="card mt-2">
                <div class="card-header">
                    <h5 class="mb-0 text-capitalize"><?php echo e(\App\CPU\translate('add_order_wise_shipping')); ?> </h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('seller.business-settings.shipping-method.add')); ?>" method="post"
                            style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="title" class="title-color"><?php echo e(\App\CPU\translate('title')); ?></label>
                                    <input type="text" name="title" class="form-control" placeholder="Ex: Name of Shipping Category">
                                </div>

                                <div class="col-md-3">
                                    <label for="duration" class="title-color"><?php echo e(\App\CPU\translate('duration')); ?></label>
                                    <input type="text" name="duration" class="form-control"
                                            placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : 4-6 <?php echo e(\App\CPU\translate('days')); ?>">
                                </div>

                                <div class="col-md-3">
                                    <label for="cost" class="title-color"><?php echo e(\App\CPU\translate('cost')); ?></label>
                                    <input type="number" min="0" max="1000000" step="0.01" name="cost" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : 10 $">
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end" style="padding-<?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>: 0">
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Submit')); ?></button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card mt-2">
                <div class="card-header">
                    <h5 class="mb-0 text-capitalize">
                        <?php echo e(\App\CPU\translate('order_wise_shipping_method')); ?>

                        <span class="badge badge-soft-dark radius-50 fz-12 ml-1"><?php echo e($shipping_methods->total()); ?></span>
                    </h5>
                </div>
                <div class="table-responsive">
                    <table id="datatable" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                        class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('title')); ?></th>
                                <th><?php echo e(\App\CPU\translate('duration')); ?></th>
                                <th><?php echo e(\App\CPU\translate('cost')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('status')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $shipping_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th><?php echo e($shipping_methods->firstItem()+$k); ?></th>
                                <td><?php echo e($method['title']); ?></td>
                                <td>
                                    <?php echo e($method['duration']); ?>

                                </td>
                                <td>
                                    <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($method['cost']))); ?>

                                </td>

                                <td>
                                    <label class="switcher mx-auto">
                                        <input type="checkbox" class="status switcher_input"
                                                id="<?php echo e($method['id']); ?>" <?php echo e($method->status == 1?'checked':''); ?>>
                                        <span class="switcher_control"></span>
                                    </label>
                                </td>
                                <td>
                                    <div class="d-flex gap-2 justify-content-center">
                                        <a  class="btn btn-outline--primary btn-sm square-btn"
                                            title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                            href="<?php echo e(route('seller.business-settings.shipping-method.edit',[$method['id']])); ?>">
                                            <i class="tio-edit"></i>
                                        </a>
                                        <a  class="btn btn-outline-danger btn-sm delete"
                                            title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                            id="<?php echo e($method['id']); ?>">
                                            <i class="tio-delete"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="table-responsive mt-4">
                    <div class="px-4 d-flex justify-content-lg-end">
                        <!-- Pagination -->
                        <?php echo $shipping_methods->links(); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-2" id="update_category_shipping_cost">
            <div class="card-header text-capitalize">
                <h5 class="mb-0"><?php echo e(\App\CPU\translate('update_category_shipping_cost')); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table" cellspacing="0"
                    style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                    <thead class="thead-light thead-50 text-capitalize">
                        <tr>
                            <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                            <th><?php echo e(\App\CPU\translate('category_name')); ?></th>
                            <th><?php echo e(\App\CPU\translate('cost_per_product')); ?></th>
                            <th class="text-center"><?php echo e(\App\CPU\translate('multiply_with_QTY')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <form action="<?php echo e(route('seller.business-settings.category-shipping-cost.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php $__currentLoopData = $all_category_shipping_cost; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e($key+1); ?>

                                    </td>
                                    <td>
                                        <?php echo e($item->category!=null?$item->category->name:\App\CPU\translate('not_found')); ?>

                                    </td>
                                    <td>
                                        <input type="hidden" class="form-control w-auto" name="ids[]" value="<?php echo e($item->id); ?>">
                                        <input type="number" class="form-control w-auto" min="0" step="0.01" name="cost[]" value="<?php echo e(\App\CPU\BackEndHelper::usd_to_currency($item->cost)); ?>">
                                    </td>
                                    <td>
                                        <label class="switcher mx-auto">
                                            <input type="checkbox" name="multiplyQTY[]" class="switcher_input"
                                                id="" value="<?php echo e($item->id); ?>" <?php echo e($item->multiply_qty == 1?'checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td colspan="4">
                                    <div class="d-flex justify-content-end">
                                        <button type="submit" class="btn btn--primary "><?php echo e(\App\CPU\translate('Update')); ?></button>
                                    </div>
                                </td>
                            </tr>
                        </form>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
            let shipping_type = '<?php echo e($shippingType); ?>';

            if(shipping_type==='category_wise')
            {
                $('#product_wise_note').hide();
                $('#order_wise_shipping').hide();
                $('#update_category_shipping_cost').show();

            }else if(shipping_type==='order_wise'){
                $('#product_wise_note').hide();
                $('#update_category_shipping_cost').hide();
                $('#order_wise_shipping').show();
            }else{

                $('#update_category_shipping_cost').hide();
                $('#order_wise_shipping').hide();
                $('#product_wise_note').show();
            }
        });
        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('seller.business-settings.shipping-method.status-update')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function () {
                    toastr.success('<?php echo e(\App\CPU\translate('order wise shipping method Status updated successfully')); ?>');
                }
            });
        });
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure delete this ?')); ?>',
                text: "<?php echo e(\App\CPU\translate('You wont be able to revert this!')); ?>",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete it')); ?>'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('seller.business-settings.shipping-method.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('Shipping Method deleted successfully')); ?>');
                            location.reload();
                        }
                    });
                }
            })
        });
    </script>
    <script>
        function seller_shipping_type(val)
        {
            console.log("val");
            if(val==='category_wise')
            {
                $('#product_wise_note').hide();
                $('#order_wise_shipping').hide();
                $('#update_category_shipping_cost').show();
            }else if(val==='order_wise'){
                $('#product_wise_note').hide();
                $('#update_category_shipping_cost').hide();
                $('#order_wise_shipping').show();
            }else{
                $('#update_category_shipping_cost').hide();
                $('#order_wise_shipping').hide();
                $('#product_wise_note').show();
            }

            $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('seller.business-settings.shipping-type.store')); ?>",
                    method: 'POST',
                    data: {
                        shippingType: val
                    },
                    success: function (data) {
                        toastr.success('<?php echo e(\App\CPU\translate('shipping_method_updated_successfully!!')); ?>');
                    }
                });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/shipping-method/add-new.blade.php ENDPATH**/ ?>