<?php $__env->startSection('title', \App\CPU\translate('Withdraw Request')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/withdraw-icon.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('withdraw')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="p-3">
                        <div class="row gy-1 align-items-center justify-content-between">
                            <div class="col-auto">
                                <h5>
                                <?php echo e(\App\CPU\translate('Withdraw Request Table')); ?>

                                    <span class="badge badge-soft-dark radius-50 fz-12 ml-1"><?php echo e($withdraw_req->total()); ?></span>
                                </h5>
                            </div>
                            <div class="d-flex col-auto gap-3">
                                <select name="withdraw_status_filter" onchange="status_filter(this.value)" class="custom-select min-w-120">
                                    <option value="all" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'all'?'selected':''); ?>><?php echo e(\App\CPU\translate('All')); ?></option>
                                    <option value="approved" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'approved'?'selected':''); ?>><?php echo e(\App\CPU\translate('Approved')); ?></option>
                                    <option value="denied" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'denied'?'selected':''); ?>><?php echo e(\App\CPU\translate('Denied')); ?></option>
                                    <option value="pending" <?php echo e(session()->has('withdraw_status_filter') && session('withdraw_status_filter') == 'pending'?'selected':''); ?>><?php echo e(\App\CPU\translate('Pending')); ?></option>
                                </select>
                                <div>
                                    <button type="button" class="btn btn-outline--primary text-nowrap btn-block"
                                            data-toggle="dropdown">
                                        <i class="tio-download-to"></i>
                                        <?php echo e(\App\CPU\translate('Export')); ?>

                                        <i class="tio-chevron-down"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li>
                                            <a class="dropdown-item" href="<?php echo e(route('admin.sellers.withdraw-list-export-excel')); ?>">
                                                <?php echo e(\App\CPU\translate('Excel')); ?>

                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="datatable"
                                style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('amount')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('request_time')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('status')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $withdraw_req; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$wr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td scope="row"><?php echo e($withdraw_req->firstItem()+$k); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($wr['amount']))); ?></td>

                                    <td>
                                        <?php if(isset($wr->seller)): ?>
                                            <a href="<?php echo e(route('admin.sellers.view',$wr->seller_id)); ?>" class="title-color hover-c1"><?php echo e($wr->seller->f_name . ' ' . $wr->seller->l_name); ?></a>
                                        <?php else: ?>
                                        <a href="#"><?php echo e(\App\CPU\translate('not_found')); ?></a>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($wr->created_at); ?></td>
                                    <td class="text-center">
                                        <?php if($wr->approved==0): ?>
                                            <label class="badge badge-soft-primary"><?php echo e(\App\CPU\translate('Pending')); ?></label>
                                        <?php elseif($wr->approved==1): ?>
                                            <label class="badge badge-soft-success"><?php echo e(\App\CPU\translate('Approved')); ?></label>
                                        <?php else: ?>
                                            <label class="badge badge-soft-danger"><?php echo e(\App\CPU\translate('Denied')); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex justify-content-center">
                                            <?php if(isset($wr->seller)): ?>
                                            <a href="<?php echo e(route('admin.sellers.withdraw_view',[$wr['id'],$wr->seller['id']])); ?>"
                                                class="btn btn-outline-info btn-sm square-btn"
                                                title="<?php echo e(\App\CPU\translate('View')); ?>">
                                                <i class="tio-invisible"></i>
                                                </a>
                                            <?php else: ?>
                                            <a href="#">
                                                <?php echo e(\App\CPU\translate('action_disabled')); ?>

                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php if(count($withdraw_req)==0): ?>
                            <div class="text-center p-4">
                                <img class="mb-3 w-160"
                                        src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                        alt="Image Description">
                                <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                            </div>
                    <?php endif; ?>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-center justify-content-md-end">
                            <!-- Pagination -->
                            <?php echo e($withdraw_req->links()); ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script_2'); ?>
  <script>
      function status_filter(type) {
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.post({
              url: '<?php echo e(route('admin.withdraw.status-filter')); ?>',
              data: {
                  withdraw_status_filter: type
              },
              beforeSend: function () {
                  $('#loading').show()
              },
              success: function (data) {
                 location.reload();
              },
              complete: function () {
                  $('#loading').hide()
              }
          });
      }
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/seller/withdraw.blade.php ENDPATH**/ ?>