<?php $__env->startSection('title', \App\CPU\translate('Edit Shipping')); ?>
<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Title -->
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/shipping_method.png')); ?>" alt="">
            <?php echo e(\App\CPU\translate('shipping_method_update')); ?>

        </h2>
    </div>
    <!-- End Page Title -->

    <!-- Content Row -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header text-capitalize">
                    <h5 class="mb-0"><?php echo e(\App\CPU\translate('shipping_method_update')); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('seller.business-settings.shipping-method.update',[$method['id']])); ?>" method="post"
                          style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>
                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label for="title" class="title-color"><?php echo e(\App\CPU\translate('title')); ?></label>
                                    <input type="text" name="title" value="<?php echo e($method['title']); ?>" class="form-control" placeholder="">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label for="duration" class="title-color"><?php echo e(\App\CPU\translate('duration')); ?></label>
                                    <input type="text" name="duration" value="<?php echo e($method['duration']); ?>" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : 4-6 <?php echo e(\App\CPU\translate('days')); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row ">
                                <div class="col-md-12">
                                    <label for="cost" class="title-color"><?php echo e(\App\CPU\translate('cost')); ?></label>
                                    <input type="text" min="0" max="1000000" name="cost" value="<?php echo e(\App\CPU\BackEndHelper::usd_to_currency($method['cost'])); ?>" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : 10 $">
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/shipping-method/edit.blade.php ENDPATH**/ ?>