<?php $__env->startSection('title', \App\CPU\translate('Order List')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Heading -->
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
            <h2 class="h1 mb-0">
                <img src="<?php echo e(asset('/public/assets/back-end/img/all-orders.png')); ?>" class="mb-1 mr-1" alt="">
                <span class="page-header-title">
                    <?php if($status =='processing'): ?>
                        <?php echo e(\App\CPU\translate('packaging')); ?>

                    <?php elseif($status =='failed'): ?>
                        <?php echo e(\App\CPU\translate('Failed_to_Deliver')); ?>

                    <?php elseif($status == 'all'): ?>
                        <?php echo e(\App\CPU\translate('all')); ?>

                    <?php else: ?>
                        <?php echo e(\App\CPU\translate(str_replace('_',' ',$status))); ?>

                    <?php endif; ?>
                </span>
                <?php echo e(\App\CPU\translate('Orders')); ?>

            </h2>
            <span class="badge badge-soft-dark radius-50 fz-14"><?php echo e($orders->total()); ?></span>
        </div>

        <div class="card">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(url()->current()); ?>" id="form-data" method="GET">
                        <div class="row gy-3 gx-2">
                            <div class="col-12 pb-0">
                                <h4><?php echo e(\App\CPU\translate('select_date_range')); ?></h4>
                            </div>

                            <?php if(request('delivery_man_id')): ?>
                                <input type="hidden" name="delivery_man_id" value="<?php echo e(request('delivery_man_id')); ?>">
                            <?php endif; ?>

                            <div class="col-sm-6 col-md-3">
                                <select name="filter" class="form-control">
                                    <option value="all" <?php echo e($filter == 'all' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('All')); ?></option>
                                    <?php if($seller_pos == 1 && $seller->pos_status == 1 && ($status == 'all' || $status == 'delivered') && !request()->has('delivery_man_id')): ?>
                                    <option value="POS" <?php echo e($filter == 'POS' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('POS')); ?></option>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <div class="form-floating">
                                    <input type="date" name="from" value="<?php echo e($from); ?>" id="from_date"
                                        class="form-control">
                                    <label><?php echo e(\App\CPU\translate('Start Date')); ?></label>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <div class="form-floating">
                                    <input type="date" value="<?php echo e($to); ?>" name="to" id="to_date"
                                        class="form-control">
                                    <label><?php echo e(\App\CPU\translate('End Date')); ?></label>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <button type="submit" class="btn btn--primary btn-block">
                                    <?php echo e(\App\CPU\translate('show')); ?> <?php echo e(\App\CPU\translate('data')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card-body">
                <?php if($status == 'all' && $filter != 'POS'): ?>
                <div class="row g-2 mb-20">
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_pending" href="<?php echo e(route('seller.orders.list', ['pending', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/pending.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('pending')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($pending); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_confirmed" href="<?php echo e(route('seller.orders.list', ['confirmed', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/confirmed.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('confirmed')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($confirmed); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_packaging" href="<?php echo e(route('seller.orders.list', ['processing', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/packaging.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('Packaging')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($processing); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_out-for-delivery" href="<?php echo e(route('seller.orders.list', ['out_for_delivery', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/out-of-delivery.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('out_for_delivery')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($out_for_delivery); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_delivered" href="<?php echo e(route('seller.orders.list', ['delivered', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/delivered.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('delivered')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($delivered); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_canceled" href="<?php echo e(route('seller.orders.list', ['canceled', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/canceled.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('canceled')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($canceled); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_returned" href="<?php echo e(route('seller.orders.list', ['returned', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/returned.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('returned')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($returned); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                    <div class="col-sm-6 col-lg-3">
                        <!-- Order Stats -->
                        <a class="order-stats order-stats_failed" href="<?php echo e(route('seller.orders.list', ['failed', 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                            <div class="order-stats__content">
                                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/failed-to-deliver.png')); ?>" alt="">
                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('failed_to_deliver')); ?></h6>
                            </div>
                            <span class="order-stats__title">
                                <?php echo e($failed); ?>

                            </span>
                        </a>
                        <!-- End Order Stats -->
                    </div>
                </div>
                <?php endif; ?>

                <!-- Data Table Top -->
                <div class="px-3 py-4 light-bg">
                    <div class="row g-2 flex-grow-1">
                        <div class="col-sm-8 col-md-6 col-lg-4">
                            <form action="<?php echo e(url()->current()); ?>" method="GET">
                                <!-- Search -->
                                <div class="input-group input-group-merge input-group-custom">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input id="datatableSearch_" type="search" name="search" class="form-control"
                                        placeholder="<?php echo e(\App\CPU\translate('search_orders')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>" required>
                                    <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                </div>
                                <!-- End Search -->
                            </form>
                        </div>
                        <div class="col-sm-4 col-md-6 col-lg-8 d-flex justify-content-sm-end">
                            <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                <i class="tio-download-to"></i>
                                <?php echo e(\App\CPU\translate('export')); ?>

                                <i class="tio-chevron-down"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('seller.orders.order-bulk-export', ['delivery_man_id' => request('delivery_man_id'), 'status' => $status, 'from' => $from, 'to' => $to, 'filter' => $filter, 'search' => $search])); ?>">
                                        <img width="14" src="<?php echo e(asset('/public/assets/back-end/img/excel.png')); ?>" alt="">
                                        <?php echo e(\App\CPU\translate('Excel')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <!-- End Row -->
                </div>
                <!-- End Data Table Top -->

                <div class="table-responsive">
                    <table id="datatable" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                            class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('Order_ID')); ?></th>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('Order_Date')); ?></th>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('customer_info')); ?></th>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('Total_amount')); ?></th>
                                <th class="text-capitalize"><?php echo e(\App\CPU\translate('Order_Status')); ?> </th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($orders->firstItem()+$k); ?>

                                </td>
                                <td>
                                    <a  class="title-color hover-c1" href="<?php echo e(route('seller.orders.details',$order['id'])); ?>"><?php echo e($order['id']); ?></a>
                                </td>
                                <td>
                                    <div><?php echo e(date('d M Y',strtotime($order['created_at']))); ?></div>
                                    <div><?php echo e(date('H:i A',strtotime($order['created_at']))); ?></div>
                                </td>
                                <td>
                                    <?php if($order->customer_id == 0): ?>
                                        <strong class="title-name">Walking customer</strong>
                                    <?php else: ?>
                                        <div><?php echo e($order->customer ? $order->customer['f_name'].' '.$order->customer['l_name'] : 'Customer Data not found'); ?></div>
                                        <a class="d-block title-color" href="tel:<?php echo e($order->customer ? $order->customer->phone : ''); ?>"><?php echo e($order->customer ? $order->customer->phone : ''); ?></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div>
                                        <?php ($discount = 0); ?>
                                        <?php if($order->coupon_discount_bearer == 'inhouse' && !in_array($order['coupon_code'], [0, NULL])): ?>
                                            <?php ($discount = $order->discount_amount); ?>
                                        <?php endif; ?>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order->order_amount+$discount))); ?>

                                    </div>

                                    <?php if($order->payment_status=='paid'): ?>
                                        <span class="badge badge-soft-success"><?php echo e(\App\CPU\translate('paid')); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-soft-danger"><?php echo e(\App\CPU\translate('unpaid')); ?></span>
                                    <?php endif; ?>
                                    </td>
                                    <td class="text-capitalize ">
                                        <?php if($order->order_status=='pending'): ?>
                                            <label
                                                class="badge badge-soft-primary"><?php echo e($order['order_status']); ?></label>
                                        <?php elseif($order->order_status=='processing' || $order->order_status=='out_for_delivery'): ?>
                                            <label
                                                class="badge badge-soft-warning"><?php echo e(str_replace('_',' ',$order['order_status'] == 'processing' ? 'packaging' : $order['order_status'])); ?></label>
                                        <?php elseif($order->order_status=='delivered' || $order->order_status=='confirmed'): ?>
                                            <label
                                                class="badge badge-soft-success"><?php echo e($order['order_status']); ?></label>
                                        <?php elseif($order->order_status=='returned'): ?>
                                            <label
                                                class="badge badge-soft-danger"><?php echo e($order['order_status']); ?></label>
                                        <?php elseif($order['order_status']=='failed'): ?>
                                            <span class="badge badge-danger fz-12">
                                                <?php echo e($order['order_status'] == 'failed' ? 'Failed To Deliver' : ''); ?>

                                            </span>
                                        <?php else: ?>
                                            <label
                                                class="badge badge-soft-danger"><?php echo e($order['order_status']); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex justify-content-center gap-2">
                                            <a  class="btn btn-outline--primary btn-sm square-btn"
                                                title="<?php echo e(\App\CPU\translate('view')); ?>"
                                                href="<?php echo e(route('seller.orders.details',[$order['id']])); ?>">
                                                <i class="tio-invisible"></i>

                                            </a>
                                            <a  class="btn btn-outline-info btn-sm square-btn" target="_blank"
                                                title="<?php echo e(\App\CPU\translate('invoice')); ?>"
                                                href="<?php echo e(route('seller.orders.generate-invoice',[$order['id']])); ?>">
                                                <i class="tio-download"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="table-responsive mt-4">
                    <div class="d-flex justify-content-lg-end">
                        <!-- Pagination -->
                        <?php echo e($orders->links()); ?>

                    </div>
                </div>
                <!-- End Pagination -->

                <?php if(count($orders)==0): ?>
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });

        $('#from_date,#to_date').change(function () {
            let fr = $('#from_date').val();
            let to = $('#to_date').val();
            if(fr != ''){
                $('#to_date').attr('required','required');
            }
            if(to != ''){
                $('#from_date').attr('required','required');
            }
            if (fr != '' && to != '') {
                if (fr > to) {
                    $('#from_date').val('');
                    $('#to_date').val('');
                    toastr.error('<?php echo e(\App\CPU\translate('Invalid date range')); ?>!', Error, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            }

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/order/list.blade.php ENDPATH**/ ?>