<?php $__env->startSection('title','Track Order'); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']->value); ?>"/>
    <meta property="og:title" content="<?php echo e($web_config['name']->value); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <meta property="twitter:card" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']->value); ?>"/>
    <meta property="twitter:title" content="<?php echo e($web_config['name']->value); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <link rel="stylesheet" media="screen"
          href="<?php echo e(asset('public/assets/front-end')); ?>/vendor/nouislider/distribute/nouislider.min.css"/>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Order Details Modal-->
    <?php
    $order = \App\Model\OrderDetail::where('order_id', $orderDetails->id)->get();
    ?>
    <div class="modal fade  rtl" id="order-details">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(\App\CPU\translate('Order No')); ?> - <?php echo e($orderDetails['id']); ?></h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body pb-0">
                    <?php ( $totalTax = 0); ?>

                    <?php ($sub_total=0); ?>
                    <?php ($total_tax=0); ?>
                    <?php ($total_shipping_cost=0); ?>
                    <?php ($total_discount_on_product=0); ?>
                    <?php ($extra_discount=0); ?>
                    <?php ($coupon_discount=0); ?>
                    <?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php ($productDetails = App\Model\Product::where('id', $product->product_id)->first()); ?>

                        <div class="d-sm-flex justify-content-between mb-4 pb-3 pb-sm-2 border-bottom">
                            <div class="media d-block d-sm-flex text-center text-sm-left">
                                <a class="d-inline-block mx-auto mr-sm-4 w-10rem"
                                   href="<?php echo e(route('product',$productDetails->slug)); ?>">
                                    <img
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($productDetails['thumbnail']); ?>">
                                </a>
                                <div class="media-body pt-2">
                                    <h4 class="product-title font-size-base mb-2"><a
                                            href="<?php echo e(route('product',$productDetails->slug)); ?>"><?php echo e($productDetails['name']); ?></a>
                                    </h4>
                                    <?php if($product['variation']): ?>
                                        <?php $__currentLoopData = json_decode($product['variation'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-muted"><span
                                                    class="mr-2"><?php echo e($key1); ?> :</span><?php echo e($variation); ?></div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    <div
                                        class="font-size-lg text-accent pt-2"><?php echo e(\App\CPU\Helpers::currency_converter($product['price'])); ?></div>
                                </div>
                            </div>
                            <div class="pt-2 pl-sm-3 mx-auto mx-sm-0 text-center">
                                <div class="text-muted mb-2"><?php echo e(\App\CPU\translate('Quantity')); ?> : <?php echo e($product['qty']); ?></div>
                            </div>
                            <div class="pt-2 pl-sm-2 mx-auto mx-sm-0 text-center">
                                <div class="text-muted mb-2"><?php echo e(\App\CPU\translate('Tax')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($product['tax'])); ?>

                                </div>
                            </div>
                            <div class="pt-2 pl-sm-3 mx-auto mx-sm-0 text-center">
                                <div class="text-muted mb-2"><?php echo e(\App\CPU\translate('Subtotal')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($product['price']*$product['qty'])); ?></div>
                            </div>
                        </div>
                        <?php ($sub_total+=$product['price']*$product['qty']); ?>
                        <?php ($total_tax+=$product['tax']); ?>
                        <?php ($total_discount_on_product+=$product['discount']); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php ($total_shipping_cost=$orderDetails['shipping_cost']); ?>

                    <?php
                            if ($orderDetails['extra_discount_type'] == 'percent') {
                                $extra_discount = ($sub_total / 100) * $orderDetails['extra_discount'];
                            } else {
                                $extra_discount = $orderDetails['extra_discount'];
                            }
                            if(isset($orderDetails['discount_amount'])){
                                $coupon_discount =$orderDetails['discount_amount'];
                            }
                        ?>
                </div>
                <!-- Footer-->
                <div class="modal-footer flex-wrap justify-content-between bg-secondary font-size-md">

                        <div class="px-2 py-1">
                            <span
                                class="text-muted"><?php echo e(\App\CPU\translate('Subtotal')); ?>:&nbsp;</span><?php echo e(\App\CPU\Helpers::currency_converter($sub_total)); ?>

                            <span></span>
                        </div>
                        <div class="px-2 py-1">
                            <span
                                class="text-muted"><?php echo e(\App\CPU\translate('Shipping')); ?>:&nbsp;</span><?php echo e(\App\CPU\Helpers::currency_converter($total_shipping_cost)); ?>

                            <span></span>
                        </div>
                        <div class="px-2 py-1">
                            <span class="text-muted"><?php echo e(\App\CPU\translate('Tax')); ?>:&nbsp;</span> <?php echo e(\App\CPU\Helpers::currency_converter($total_tax)); ?>

                            <span></span>
                        </div>

                        <div class="px-2 py-1">
                            <span
                                class="text-muted"><?php echo e(\App\CPU\translate('Discount')); ?>:&nbsp;</span>
                            - <?php echo e(\App\CPU\Helpers::currency_converter($total_discount_on_product)); ?>

                            <span></span>
                        </div>
                </div>
                <div class="modal-footer flex-wrap justify-content-between bg-secondary font-size-md">
                    <div class="px-2 py-1">
                        <span
                            class="text-muted"><?php echo e(\App\CPU\translate('Coupon Discount')); ?>:&nbsp;</span>
                        - <?php echo e(\App\CPU\Helpers::currency_converter($coupon_discount)); ?>

                        <span></span>
                    </div>
                    <?php if($orderDetails['order_type'] == 'POS'): ?>
                    <div class="px-2 py-1">
                        <span
                            class="text-muted"><?php echo e(\App\CPU\translate('Extra Discount')); ?>:&nbsp;</span>
                        - <?php echo e(\App\CPU\Helpers::currency_converter($extra_discount)); ?>

                        <span></span>
                    </div>
                    <?php endif; ?>
                    <div class="px-2 py-1">
                        <span class="text-muted"><?php echo e(\App\CPU\translate('Total')); ?>:&nbsp; </span>
                        <span class="font-size-lg">
                             <?php echo e(\App\CPU\Helpers::currency_converter($sub_total+$total_tax+$total_shipping_cost-($orderDetails->discount)-$total_discount_on_product - $coupon_discount - $extra_discount)); ?>

                        </span>
                    </div>
            </div>
            </div>
        </div>
    </div>
    <!-- Page Title (Dark)-->
    <div class="container rtl">

        <h2 class="headerTitle text-center my-3"><?php echo e(\App\CPU\translate('My Order')); ?></h2>

        <div class="btn--primary">
            <div class="container d-lg-flex justify-content-between py-2 py-lg-3">

                <div class="order-lg-1 pr-lg-4 text-center text-lg-left">
                    <h4 class="text-light mb-0"><?php echo e(\App\CPU\translate('Order ID')); ?> : <span
                            class="h4 font-weight-normal text-light"><?php echo e($orderDetails['id']); ?></span></h4>
                </div>
            </div>
        </div>

    </div>
    <!-- Page Content-->
    <div class="container mb-md-3  rtl">
        <!-- Details-->
        <div class="row __bg-e2f0ff w-100 m-0">
            <div class="col-sm-4">
                <div class="pt-2 pb-2 text-center rounded-lg">
                    <span class="font-weight-medium text-dark mr-2"><?php echo e(\App\CPU\translate('Order Status')); ?>:</span><br>
                    <span class="text-uppercase ">
                        <?php if($orderDetails['order_status'] =='processing'): ?>
                            <?php echo e(\App\CPU\translate('packaging')); ?>

                        <?php elseif($orderDetails['order_status'] =='failed'): ?>
                            <?php echo e(\App\CPU\translate('failed_to_deliver')); ?>

                        <?php else: ?>
                            <?php echo e(\App\CPU\translate($orderDetails['order_status'])); ?>

                        <?php endif; ?>
                    </span>
                    
                </div>
            </div>
            <div class="col-sm-4">
                <div class="pt-2 pb-2 text-center rounded-lg">
                    <span class="font-weight-medium text-dark mr-2"><?php echo e(\App\CPU\translate('Payment Status')); ?>:</span> <br>
                    <span class="text-uppercase"><?php echo e(\App\CPU\translate($orderDetails['payment_status'])); ?></span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="pt-2 pb-2 text-center rounded-lg">
                    <span class="font-weight-medium text-dark mr-2"> <?php echo e(\App\CPU\translate('Estimated Delivary Date')); ?>: </span> <br>
                    <span class="text-uppercase font-semibold" style="color: <?php echo e($web_config['primary_color']); ?>"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$orderDetails['updated_at'])->format('Y-m-d')); ?></span>
                </div>
            </div>
        </div>
        <!-- Progress-->
        <div class="card border-0 box-shadow-lg mt-5">
            <div class="card-body pb-2">
                <ul class="nav nav-tabs media-tabs nav-justified">
                    <?php if($orderDetails['order_status']!='returned' && $orderDetails['order_status']!='failed'): ?>

                        <li class="nav-item">
                            <div class="nav-link">
                                <div class="align-items-center">
                                    <div class="media-tab-media mx-auto my-0 text-white track-order-success">
                                        <i class="czi-check"></i>
                                    </div>
                                    <div class="media-body text-center">
                                        <div class="media-tab-subtitle text-muted font-size-xs mb-1"><?php echo e(\App\CPU\translate('First step')); ?></div>
                                        <h6 class="media-tab-title text-nowrap mb-0"><?php echo e(\App\CPU\translate('Order placed')); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li class="nav-item ">
                            <div class="nav-link ">
                                <div class="align-items-center">
                                    <div class="media-tab-media my-0 mx-auto"
                                         style=" <?php if(($orderDetails['order_status']=='processing') || ($orderDetails['order_status']=='processed') || ($orderDetails['order_status']=='out_for_delivery') || ($orderDetails['order_status']=='delivered')): ?> background: #4bcc02; color: white; <?php endif; ?> ">
                                        <?php if(($orderDetails['order_status']=='processing') || ($orderDetails['order_status']=='processed') || ($orderDetails['order_status']=='out_for_delivery') || ($orderDetails['order_status']=='delivered')): ?>
                                            <i class="czi-check"></i>
                                        <?php else: ?>
                                            <i class="tio-clear"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="media-body text-center">
                                        <div class="media-tab-subtitle text-muted font-size-xs mb-1"><?php echo e(\App\CPU\translate('Second step')); ?></div>
                                        <h6 class="media-tab-title text-nowrap mb-0"><?php echo e(\App\CPU\translate('Packaging order')); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li class="nav-item">
                            <div class="nav-link  ">
                                <div class="align-items-center">
                                    <div class="media-tab-media my-0 mx-auto"
                                         style=" <?php if(($orderDetails['order_status']=='processed') || ($orderDetails['order_status']=='out_for_delivery') || ($orderDetails['order_status']=='delivered')): ?> background: #4bcc02; color: white; <?php endif; ?> ">
                                        <?php if(($orderDetails['order_status']=='processed') || ($orderDetails['order_status']=='out_for_delivery') || ($orderDetails['order_status']=='delivered')): ?>
                                            <i class="czi-check"></i>
                                        <?php else: ?>
                                            <i class="tio-clear"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="media-body text-center">
                                        <div class="media-tab-subtitle text-muted font-size-xs mb-1"><?php echo e(\App\CPU\translate('Third step')); ?></div>
                                        <h6 class="media-tab-title text-nowrap mb-0"><?php echo e(\App\CPU\translate('Preparing Shipment')); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li class="nav-item">
                            <div class="nav-link ">
                                <div class="align-items-center">
                                    <div class="media-tab-media my-0 mx-auto"
                                         style="<?php if(($orderDetails['order_status']=='delivered')): ?> background: #4bcc02; color: white; <?php endif; ?>">
                                        <?php if(($orderDetails['order_status']=='delivered')): ?>
                                            <i class="czi-check"></i>
                                        <?php else: ?>
                                            <i class="tio-clear"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="media-body text-center">
                                        <div class="media-tab-subtitle text-muted font-size-xs mb-1"><?php echo e(\App\CPU\translate('Fourth step')); ?></div>
                                        <h6 class="media-tab-title text-nowrap mb-0"><?php echo e(\App\CPU\translate('Order Shipped')); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </li>
                    <?php elseif($orderDetails['order_status']=='returned'): ?>
                        <li class="nav-item">
                            <div class="nav-link text-center">
                                <h1 class="text-warning"><?php echo e(\App\CPU\translate('Product Successfully Returned')); ?></h1>
                            </div>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <div class="nav-link text-center">
                                <h1 class="text-danger"><?php echo e(\App\CPU\translate("Sorry we can`t complete your order")); ?></h1>
                            </div>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
        </div>
        <!-- Footer-->
        <div class="d-sm-flex flex-wrap justify-content-between align-items-center text-center pt-3">
            <div class="custom-control custom-checkbox mt-1 mr-3">
            </div>
            <a class="btn btn--primary btn-sm mt-2 mb-2" href="#order-details" data-toggle="modal"><?php echo e(\App\CPU\translate('View Order Details')); ?></a>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/front-end')); ?>/vendor/nouislider/distribute/nouislider.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/order/tracking.blade.php ENDPATH**/ ?>