<?php $__env->startSection('title',\App\CPU\translate($data['data_from']).' '.\App\CPU\translate('products')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']); ?>"/>
    <meta property="og:title" content="Products of <?php echo e($web_config['name']); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <meta property="twitter:card" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']); ?>"/>
    <meta property="twitter:title" content="Products of <?php echo e($web_config['name']); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <style>
        .for-count-value {

        <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 0.6875 rem;;
        }

        .for-count-value {

        <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 0.6875 rem;
        }

        .for-brand-hover:hover {
            color: <?php echo e($web_config['primary_color']); ?>;
        }

        .for-hover-lable:hover {
            color: <?php echo e($web_config['primary_color']); ?>       !important;
        }

        .page-item.active .page-link {
            background-color: <?php echo e($web_config['primary_color']); ?>      !important;
        }

        .for-shoting {
            padding- <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 9px;
        }

        .sidepanel {
        <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>: 0;
        }
        .sidepanel .closebtn {
        <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 25 px;
        }
        @media (max-width: 360px) {
            .for-shoting-mobile {
                margin- <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 0% !important;
            }

            .for-mobile {

                margin- <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>: 10% !important;
            }

        }

        @media (max-width: 500px) {
            .for-mobile {

                margin- <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>: 27%;
            }
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<?php ($decimal_point_settings = \App\CPU\Helpers::get_business_settings('decimal_point_settings')); ?>
    <!-- Page Title-->
    <div class="d-flex w-100 justify-content-center align-items-center mb-3 __min-h-70px __inline-35" style="background:<?php echo e($web_config['primary_color']); ?>10;">

        <div class="text-capitalize container text-center">
            <span class="__text-18px font-semibold"><?php echo e(\App\CPU\translate(str_replace('_',' ',$data['data_from']))); ?> <?php echo e(\App\CPU\translate('products')); ?> <?php echo e(isset($data['brand_name']) ? '('.$data['brand_name'].')' : ''); ?></span>
        </div>

    </div>
    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-4 rtl __inline-35"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <!-- Sidebar-->
            <aside
                class="col-lg-3 hidden-xs col-md-3 col-sm-4 SearchParameters __search-sidebar <?php echo e(Session::get('direction') === "rtl" ? 'pl-2' : 'pr-2'); ?>"
                id="SearchParameters">
                <!--Price Sidebar-->
                <div class="cz-sidebar box-shadow-lg __inline-35" id="shop-sidebar">
                    <div class="cz-sidebar-header box-shadow-sm">
                        <button class="close <?php echo e(Session::get('direction') === "rtl" ? 'mr-auto' : 'ml-auto'); ?>"
                                type="button" data-dismiss="sidebar" aria-label="Close"><span
                                class="d-inline-block font-size-xs font-weight-normal align-middle"><span class="d-inline-block align-middle"
                                aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="pb-0" >
                        <!-- Filter by price-->
                        <div class="text-center">
                            <div class="__cate-side-title border-bottom">
                                <span class="widget-title font-semibold"><?php echo e(\App\CPU\translate('filter')); ?> </span>
                            </div>
                            <div
                                class="__p-25-10 w-100 pt-4">
                                <label class="w-100 opacity-75 text-nowrap for-shoting d-block mb-0" for="sorting" style="padding-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>: 0">
                                    <select class="form-control custom-select" id="searchByFilterValue">
                                        <option selected disabled><?php echo e(\App\CPU\translate('Choose')); ?></option>
                                        <option
                                            value="<?php echo e(route('products',['id'=> $data['id'],'data_from'=>'best-selling','page'=>1])); ?>" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='best-selling'?'selected':'':''); ?>><?php echo e(\App\CPU\translate('best_selling_product')); ?></option>
                                        <option
                                            value="<?php echo e(route('products',['id'=> $data['id'],'data_from'=>'top-rated','page'=>1])); ?>" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='top-rated'?'selected':'':''); ?>><?php echo e(\App\CPU\translate('top_rated')); ?></option>
                                        <option
                                            value="<?php echo e(route('products',['id'=> $data['id'],'data_from'=>'most-favorite','page'=>1])); ?>" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='most-favorite'?'selected':'':''); ?>><?php echo e(\App\CPU\translate('most_favorite')); ?></option>
                                        <option
                                            value="<?php echo e(route('products',['id'=> $data['id'],'data_from'=>'featured_deal','page'=>1])); ?>" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='featured_deal'?'selected':'':''); ?>><?php echo e(\App\CPU\translate('featured_deal')); ?></option>
                                    </select>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3" >
                        <!-- Filter by price-->
                        <div class="text-center">
                            <div class="__cate-side-title border-top border-bottom">
                                <span class="widget-title font-semibold"><?php echo e(\App\CPU\translate('Price')); ?> </span>
                            </div>

                            <div class="d-flex justify-content-between align-items-center __cate-side-price">
                                <div class="__w-35p">
                                    <input class="bg-white cz-filter-search form-control form-control-sm appended-form-control"
                                           type="number" value="0" min="0" max="1000000" id="min_price" placeholder="Min">

                                </div>
                                <div class="__w-10p">
                                    <p class="m-0"><?php echo e(\App\CPU\translate('to')); ?></p>
                                </div>
                                <div class="__w-35p">
                                    <input value="100" min="100" max="1000000"
                                           class="bg-white cz-filter-search form-control form-control-sm appended-form-control"
                                           type="number" id="max_price"  placeholder="Max">

                                </div>

                                <div class="d-flex justify-content-center align-items-center __number-filter-btn">

                                    <a class=""
                                        onclick="searchByPrice()">
                                        <i class="__inline-37 czi-arrow-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>"></i>
                                    </a>

                                </div>
                            </div>

                        </div>
                    </div>
                    <div>
                        <div class="text-center">
                            <div class="__cate-side-title border-top border-bottom">
                                <span class="widget-title font-semibold"><?php echo e(\App\CPU\translate('brands')); ?></span>
                            </div>
                            <div class="__cate-side-price pb-0">
                                <div class="input-group-overlay input-group-sm">
                                    <input style="<?php echo e(Session::get('direction') === "rtl" ? 'padding-right: 32px;' : ''); ?>" placeholder="<?php echo e(\App\CPU\translate('search_by_brands')); ?>"
                                        class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control"
                                        type="text" id="search-brand">
                                    <div class="input-group-append-overlay">
                                        <span class="input-group-text">
                                            <i class="czi-search"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <ul id="lista1" class="__brands-cate-wrap"
                                data-simplebar data-simplebar-auto-hide="false">
                                <?php $__currentLoopData = \App\CPU\BrandManager::get_active_brands(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="brand mt-2 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>" id="brand">
                                        <li class="flex-between __inline-39"
                                            onclick="location.href='<?php echo e(route('products',['id'=> $brand['id'],'data_from'=>'brand','page'=>1])); ?>'">
                                            <div >
                                                <?php echo e($brand['name']); ?>

                                            </div>
                                            <?php if($brand['brand_products_count'] > 0 ): ?>
                                                <div class="__brands-cate-badge">
                                                    <span class="">
                                                    <?php echo e($brand['brand_products_count']); ?>

                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="mt-3 __cate-side-arrordion">
                        <!-- Categories-->
                        <div>
                            <div  class="text-center __cate-side-title border-top border-bottom">
                                <span class="widget-title font-semibold"><?php echo e(\App\CPU\translate('categories')); ?></span>
                            </div>
                            <?php ($categories=\App\CPU\CategoryManager::parents()); ?>
                            <div class="accordion mt-n1 __cate-side-price" id="shop-categories">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div >
                                        <div class="card-header p-1 flex-between">
                                            <div>
                                                <label class="for-hover-lable cursor-pointer" onclick="location.href='<?php echo e(route('products',['id'=> $category['id'],'data_from'=>'category','page'=>1])); ?>'">
                                                    <?php echo e($category['name']); ?>

                                                </label>
                                            </div>
                                            <div class="px-2 cursor-pointer" onclick="$('#collapse-<?php echo e($category['id']); ?>').slideToggle(300); if($(this).find('.pull-right').hasClass('active')){
                                                $(this).find('.pull-right').removeClass('active');
                                                $(this).find('.pull-right').text('+')
                                            }else {$(this).find('.pull-right').addClass('active');
                                                $(this).find('.pull-right').text('-')}

                                                ">
                                                <strong class="pull-right for-brand-hover">
                                                    <?php echo e($category->childes->count()>0?'+':''); ?>

                                                </strong>
                                            </div>
                                        </div>
                                        <div class="card-body p-0 <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                             id="collapse-<?php echo e($category['id']); ?>"
                                             style="display: none">
                                            <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class=" for-hover-lable card-header p-1 flex-between">
                                                    <div>
                                                        <label class="cursor-pointer" onclick="location.href='<?php echo e(route('products',['id'=> $child['id'],'data_from'=>'category','page'=>1])); ?>'">
                                                            <?php echo e($child['name']); ?>

                                                        </label>
                                                    </div>
                                                    <div class="px-2 cursor-pointer" onclick="$('#collapse-<?php echo e($child['id']); ?>').slideToggle(300); if($(this).find('.pull-right').hasClass('active')){
                                                $(this).find('.pull-right').removeClass('active');
                                                $(this).find('.pull-right').text('+')
                                            }else {$(this).find('.pull-right').addClass('active');
                                                $(this).find('.pull-right').text('-')}">
                                                        <strong class="pull-right">
                                                            <?php echo e($child->childes->count()>0? '+' : ''); ?>

                                                        </strong>
                                                    </div>
                                                </div>
                                                <div
                                                    class="card-body p-0 <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                                    id="collapse-<?php echo e($child['id']); ?>"
                                                    style="display: none">
                                                    <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="card-header p-1">
                                                            <label class="for-hover-lable d-block cursor-pointer text-left"
                                                                   onclick="location.href='<?php echo e(route('products',['id'=> $ch['id'],'data_from'=>'category','page'=>1])); ?>'"><?php echo e($ch['name']); ?></label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>

            </aside>

            <!-- Content  -->
            <section class="col-lg-9">
                <div class="d-flex flex-wrap align-items-center justify-content-between __inline-43 __gap-6px p-2">
                    <div class="filter-show-btn btn btn--primary py-1 px-2">
                        <i class="tio-filter"></i>
                    </div>
                    <h1 class="max-sm-order-1">
                        <label id="price-filter-count"> <?php echo e($products->total()); ?> <?php echo e(\App\CPU\translate('items found')); ?> </label>
                    </h1>
                    <div class="d-flex align-items-center ml-auto">

                        <div class="w-100">
                            <form id="search-form" action="<?php echo e(route('products')); ?>" method="GET">
                                <input hidden name="data_from" value="<?php echo e($data['data_from']); ?>">
                                <div class=" <?php echo e(Session::get('direction') === "rtl" ? 'float-left' : 'float-right'); ?>">
                                    <label class="for-shoting" for="sorting">
                                        <span><?php echo e(\App\CPU\translate('sort_by')); ?></span>
                                    </label>
                                    <select class="__inline-44"
                                                onchange="filter(this.value)">
                                        <option value="latest"><?php echo e(\App\CPU\translate('Latest')); ?></option>
                                        <option
                                            value="low-high"><?php echo e(\App\CPU\translate('Low_to_High')); ?> <?php echo e(\App\CPU\translate('Price')); ?> </option>
                                        <option
                                            value="high-low"><?php echo e(\App\CPU\translate('High_to_Low')); ?> <?php echo e(\App\CPU\translate('Price')); ?></option>
                                        <option
                                            value="a-z"><?php echo e(\App\CPU\translate('A_to_Z')); ?> <?php echo e(\App\CPU\translate('Order')); ?></option>
                                        <option
                                            value="z-a"><?php echo e(\App\CPU\translate('Z_to_A')); ?> <?php echo e(\App\CPU\translate('Order')); ?></option>
                                    </select>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php if(count($products) > 0): ?>
                    <div class="row mt-3" id="ajax-products">
                        <?php echo $__env->make('web-views.products._ajax-products',['products'=>$products,'decimal_point_settings'=>$decimal_point_settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center pt-5">
                        <h2><?php echo e(\App\CPU\translate('No Product Found')); ?></h2>
                    </div>
                <?php endif; ?>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        function openNav() {
            document.getElementById("mySidepanel").style.width = "70%";
            document.getElementById("mySidepanel").style.height = "100vh";
        }

        function closeNav() {
            document.getElementById("mySidepanel").style.width = "0";
        }

        function filter(value) {
            $.get({
                url: '<?php echo e(url('/')); ?>/products',
                data: {
                    id: '<?php echo e($data['id']); ?>',
                    name: '<?php echo e($data['name']); ?>',
                    data_from: '<?php echo e($data['data_from']); ?>',
                    min_price: '<?php echo e($data['min_price']); ?>',
                    max_price: '<?php echo e($data['max_price']); ?>',
                    sort_by: value
                },
                dataType: 'json',
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (response) {
                    $('#ajax-products').html(response.view);
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }

        function searchByPrice() {
            let min = $('#min_price').val();
            let max = $('#max_price').val();
            $.get({
                url: '<?php echo e(url('/')); ?>/products',
                data: {
                    id: '<?php echo e($data['id']); ?>',
                    name: '<?php echo e($data['name']); ?>',
                    data_from: '<?php echo e($data['data_from']); ?>',
                    sort_by: '<?php echo e($data['sort_by']); ?>',
                    min_price: min,
                    max_price: max,
                },
                dataType: 'json',
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (response) {
                    $('#ajax-products').html(response.view);
                    $('#paginator-ajax').html(response.paginator);
                    console.log(response.total_product);
                    $('#price-filter-count').text(response.total_product + ' <?php echo e(\App\CPU\translate('items found')); ?>')
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }

        $('#searchByFilterValue, #searchByFilterValue-m').change(function () {
            var url = $(this).val();
            if (url) {
                window.location = url;
            }
            return false;
        });

        $("#search-brand").on("keyup", function () {
            var value = this.value.toLowerCase().trim();
            $("#lista1 div>li").show().filter(function () {
                return $(this).text().toLowerCase().trim().indexOf(value) == -1;
            }).hide();
        });
    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/products/view.blade.php ENDPATH**/ ?>