<?php $__env->startSection('title', \App\CPU\translate('Employee Edit')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/css/select2.min.css" rel="stylesheet"/>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Title -->
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img src="<?php echo e(asset('/public/assets/back-end/img/add-new-employee.png')); ?>" alt="">
            <?php echo e(\App\CPU\translate('Employee_Update')); ?>

        </h2>
    </div>
    <!-- End Page Title -->

    <!-- Content Row -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><?php echo e(\App\CPU\translate('Employee')); ?> <?php echo e(\App\CPU\translate('Update')); ?> <?php echo e(\App\CPU\translate('form')); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.employee.update',[$e['id']])); ?>" method="post" enctype="multipart/form-data"
                          style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6 form-group">
                                    <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Name')); ?></label>
                                    <input type="text" name="name" value="<?php echo e($e['name']); ?>" class="form-control" id="name"
                                           placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : Jhon Doe">
                                </div>
                                <div class="col-md-6 form-group">
                                    <label for="phone" class="title-color"><?php echo e(\App\CPU\translate('Phone')); ?></label>
                                    <input type="number" value="<?php echo e($e['phone']); ?>" required name="phone" class="form-control" id="phone"
                                           placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : +88017********">
                                </div>
                                <div class="col-md-6 form-group">
                                    <label for="email" class="title-color"><?php echo e(\App\CPU\translate('Email')); ?></label>
                                    <input type="email" value="<?php echo e($e['email']); ?>" name="email" class="form-control" id="email"
                                           placeholder="<?php echo e(\App\CPU\translate('Ex')); ?> : ex@gmail.com" required>
                                </div>
                                <div class="col-md-6 form-group">
                                    <label class="title-color"><?php echo e(\App\CPU\translate('Role')); ?></label>
                                    <select class="form-control" name="role_id">
                                            <option value="0" selected disabled>---<?php echo e(\App\CPU\translate('select')); ?>---</option>
                                            <?php $__currentLoopData = $rls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($r->id); ?>" <?php echo e($r['id']==$e['admin_role_id']?'selected':''); ?>><?php echo e($r->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6 form-group">
                                    <label for="password" class="title-color"><?php echo e(\App\CPU\translate('Password')); ?></label><small> ( <?php echo e(\App\CPU\translate('input if you want to change')); ?> )</small>
                                    <input type="text" name="password" class="form-control" id="password"
                                           placeholder="<?php echo e(\App\CPU\translate('Password')); ?>">
                                </div>
                                <div class="col-md-6 form-group">
                                    <div class="form-group">
                                        <label for="customFileUpload" class="title-color"><?php echo e(\App\CPU\translate('employee_image')); ?></label>
                                        <span class="text-danger">( <?php echo e(\App\CPU\translate('ratio')); ?> 1:1 )</span>
                                        <div class="custom-file text-left">
                                            <input type="file" name="image" id="customFileUpload" class="custom-file-input"
                                                accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                            <label class="custom-file-label" for="customFileUpload"><?php echo e(\App\CPU\translate('choose')); ?> <?php echo e(\App\CPU\translate('file')); ?></label>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <img class="upload-img-view" id="viewer"
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(asset('storage/app/public/admin')); ?>/<?php echo e($e['image']); ?>" alt="Employee thumbnail"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn--primary px-4"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!--modal-->
    <?php echo $__env->make('shared-partials.image-process._image-crop-modal',['modal_id'=>'employee-image-modal'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--modal-->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/select2.min.js"></script>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileUpload").change(function () {
            readURL(this);
        });


        $(".js-example-theme-single").select2({
            theme: "classic"
        });

        $(".js-example-responsive").select2({
            width: 'resolve'
        });
    </script>

    <?php echo $__env->make('shared-partials.image-process._script',[
   'id'=>'employee-image-modal',
   'height'=>200,
   'width'=>200,
   'multi_image'=>false,
   'route'=>route('image-upload')
   ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/employee/edit.blade.php ENDPATH**/ ?>