<?php $__env->startSection('title', \App\CPU\translate('Language')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/back-end/css/custom.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid __inline-3">
        <!-- Page Heading -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(\App\CPU\translate('Dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item" aria-current="page"><?php echo e(\App\CPU\translate('language_setting')); ?> <?php echo e(\App\CPU\translate('for_app')); ?></li>
            </ol>
        </nav>

        <div class="row" style="margin-top: 20px">
            <div class="col-md-12">
                <div class="alert alert-warning sticky-top" id="alert_box" style="display:none;">
                    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
                    <strong><?php echo e(\App\CPU\translate('Warning')); ?>!</strong> <?php echo e(\App\CPU\translate('Follow the documentation to setup from app end')); ?>, <a
                        href="https://documentation.6amtech.com/sixvalley-ecommerce/docs/1.0/app-setup#section3"
                        target="_blank"><?php echo e(\App\CPU\translate('click')); ?>

                        <?php echo e(\App\CPU\translate('here')); ?></a>.
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(\App\CPU\translate('Select Country code')); ?>

                            <?php echo e(\App\CPU\translate('for')); ?> <?php echo e(\App\CPU\translate('product')); ?> <?php echo e(\App\CPU\translate('and')); ?> <?php echo e(\App\CPU\translate('category')); ?> <?php echo e(\App\CPU\translate('language')); ?></h4>
                        <label class="badge badge-danger">* <?php echo e(\App\CPU\translate('For mobile app only')); ?></label>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.business-settings.web-config.update-language')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <?php ($language=\App\Model\BusinessSetting::where('type','pnc_language')->first()); ?>
                            <?php ($language = json_decode($language->value,true) ?? []); ?>

                            <div class="form-group">
                                <select name="language[]" id="language" onchange="$('#alert_box').show();"
                                        data-maximum-selection-length="3" class="form-control js-select2-custom country-var-select"
                                        required multiple=true>
                                    <?php $__currentLoopData = \Illuminate\Support\Facades\File::files(base_path('public/assets/front-end/img/flags')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(pathinfo($path)['filename']); ?>"
                                                <?php echo e(in_array(pathinfo($path)['filename'],$language)?'selected':''); ?>

                                                title="<?php echo e(asset('public/assets/front-end/img/flags/'.pathinfo($path)['filename'].'.png')); ?>">
                                            <?php echo e(strtoupper(pathinfo($path)['filename'])); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <button type="submit"
                                    class="btn btn--primary float-right ml-3"><?php echo e(\App\CPU\translate('Save')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            // color select select2
            $('.country-var-select').select2({
                templateResult: codeSelect,
                templateSelection: codeSelect,
                escapeMarkup: function (m) {
                    return m;
                }
            });

            function codeSelect(state) {
                var code = state.title;
                if (!code) return state.text;
                return "<img class='image-preview' src='"+code+"'>" + state.text;
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/business-settings/language/index-app.blade.php ENDPATH**/ ?>