<?php $__env->startSection('title', \App\CPU\translate('Product Report')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex gap-2 align-items-center">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/seller_sale.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('product_report')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        <?php echo $__env->make('admin-views.report.product-report-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inlile Menu -->

        <div class="row">
            <div class="col-12">
                <div class="card mb-2">
                    <div class="card-body">
                        <form action="" id="form-data" method="GET">
                            <h4 class="mb-3"><?php echo e(\App\CPU\translate('Filter_Data')); ?></h4>
                            <div class="row g-2 align-items-center text-left">
                                <div class="col-sm-6 col-md-4 col-lg-3">
                                    <select
                                        class="js-select2-custom form-control text-ellipsis"
                                        name="seller_id">
                                        <option value="all" <?php echo e($seller_id == 'all' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('All')); ?></option>
                                        <option value="in_house" <?php echo e($seller_id == 'in_house' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('In-House')); ?></option>
                                        <?php $__currentLoopData = \App\Model\Seller::where(['status'=>'approved'])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($seller['id']); ?>" <?php echo e($seller_id == $seller['id'] ? 'selected' : ''); ?>>
                                                <?php echo e($seller['f_name']); ?> <?php echo e($seller['l_name']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-sm-6 col-md-4 col-lg-3">
                                    <div class="">
                                        <select
                                            class="form-control"
                                            name="sort">
                                            <option value="ASC" <?php echo e($sort == 'ASC' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('wishlist_sort_by_(low_to_high)')); ?></option>
                                            <option value="DESC" <?php echo e($sort == 'DESC' ? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('wishlist_sort_by_(high_to_low)')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 col-lg-3 text-right text-md-left">
                                    <button type="submit" class="btn btn--primary px-4 px-md-5">
                                        <?php echo e(\App\CPU\translate('filter')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header border-0">
                        <div class="d-flex flex-wrap w-100 gap-3 align-items-center">
                            <h4 class="mb-0 mr-auto">
                                <?php echo e(\App\CPU\translate('Total_Products')); ?>

                                <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($products->total()); ?></span>
                            </h4>
                            <form action="" method="GET">
                                <!-- Search -->
                                <div class="input-group input-group-merge input-group-custom">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input type="hidden" value="<?php echo e($seller_id); ?>" name="seller_id">
                                    <input type="hidden" value="<?php echo e($sort); ?>" name="sort">
                                    <input id="datatableSearch_" type="search" name="search" class="form-control"
                                           placeholder="<?php echo e(\App\CPU\translate('Search Product Name')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>">
                                    <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                </div>
                                <!-- End Search -->
                            </form>
                            <div>
                                <button type="button" class="btn btn-outline--primary text-nowrap btn-block" data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    <?php echo e(\App\CPU\translate('Export')); ?>

                                    <i class="tio-chevron-down"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li><a class="dropdown-item" href="<?php echo e(route('admin.stock.wishlist-product-export', ['seller_id'=>$seller_id, 'sort'=>$sort, 'search'=>$search])); ?>"><?php echo e(\App\CPU\translate('excel')); ?></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="table-responsive" id="products-table">
                        <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100 <?php echo e(Session::get('direction') === "rtl" ? 'text-right' : 'text-left'); ?>">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th>
                                    <?php echo e(\App\CPU\translate('Product Name')); ?>

                                </th>
                                <th>
                                    <?php echo e(\App\CPU\translate('Date')); ?>

                                </th>
                                <th class="text-center">
                                    <?php echo e(\App\CPU\translate('Total in Wishlist')); ?>

                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($products->firstItem()+$key); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.product.view',[$data['id']])); ?>">
                                            <span class="media-body title-color hover-c1">
                                                <?php echo e(\Illuminate\Support\Str::limit($data['name'], 20)); ?>

                                            </span>
                                        </a>
                                    </td>
                                    <td><?php echo e(date('d M Y', $data['created_at'] ? strtotime($data['created_at']) : null)); ?></td>
                                    <td class="text-center"><?php echo e($data->wish_list_count); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if(count($products)==0): ?>
                                <tr>
                                    <td colspan="5">
                                        <div class="text-center p-4">
                                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                                 alt="Image Description">
                                            <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- End Table -->

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-center justify-content-md-end">
                            <!-- Pagination -->
                            <?php echo $products->links(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Stats -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            $('.js-select2-custom').select2();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/report/product-in-wishlist.blade.php ENDPATH**/ ?>