<?php $__env->startSection('title', \App\CPU\translate('Order Details')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
            <h2 class="h1 mb-0">
                <img src="<?php echo e(asset('/public/assets/back-end/img/all-orders.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Order_Details')); ?>

            </h2>
        </div>

        <!-- End Page Header -->

        <div class="row gx-2 gy-3" id="printableArea">
            <div class="col-lg-8 col-xl-9">
                <!-- Card -->
                <div class="card h-100">
                    <!-- Body -->
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-10 justify-content-between mb-4">
                            <div class="d-flex flex-column gap-10">
                                <h4 class="text-capitalize"><?php echo e(\App\CPU\translate('Order_ID')); ?> #<?php echo e($order['id']); ?></h4>
                                <div class="">
                                    <i class="tio-date-range"></i>
                                    <?php echo e(date('d M Y H:i:s', strtotime($order['created_at']))); ?>

                                </div>
                            </div>
                            <div class="text-sm-right">
                                <div class="d-flex flex-wrap gap-10 justify-content-sm-end">
                                    <a class="btn btn--primary px-4" target="_blank"
                                        href="<?php echo e(route('admin.orders.generate-invoice', [$order['id']])); ?>">
                                        <i class="tio-print mr-1"></i> <?php echo e(\App\CPU\translate('Print')); ?>

                                        <?php echo e(\App\CPU\translate('invoice')); ?>

                                    </a>
                                </div>
                                <div class="d-flex flex-column gap-2 mt-3">
                                    <!-- Order status -->
                                    <div class="order-status d-flex justify-content-sm-end gap-10 text-capitalize">
                                        <span class="title-color"><?php echo e(\App\CPU\translate('status')); ?>: </span>
                                        <?php if($order['order_status'] == 'pending'): ?>
                                            <span
                                                class="badge badge-soft-info font-weight-bold radius-50 d-flex align-items-center py-1 px-2">
                                                <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['order_status']))); ?>

                                            </span>
                                        <?php elseif($order['order_status'] == 'failed'): ?>
                                            <span
                                                class="badge badge-soft-danger font-weight-bold radius-50 d-flex align-items-center py-1 px-2">
                                                <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['order_status']))); ?>

                                            </span>
                                        <?php elseif($order['order_status'] == 'processing' || $order['order_status'] == 'out_for_delivery'): ?>
                                            <span
                                                class="badge badge-soft-warning font-weight-bold radius-50 d-flex align-items-center py-1 px-2">
                                                <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['order_status']))); ?>

                                            </span>
                                        <?php elseif($order['order_status'] == 'delivered' || $order['order_status'] == 'confirmed'): ?>
                                            <span
                                                class="badge badge-soft-success font-weight-bold radius-50 d-flex align-items-center py-1 px-2">
                                                <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['order_status']))); ?>

                                            </span>
                                        <?php else: ?>
                                            <span
                                                class="badge badge-soft-danger font-weight-bold radius-50 d-flex align-items-center py-1 px-2">
                                                <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['order_status']))); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <!-- Payment Method -->
                                    <div class="payment-method d-flex justify-content-sm-end gap-10 text-capitalize">
                                        <span class="title-color"><?php echo e(\App\CPU\translate('Payment')); ?>

                                            <?php echo e(\App\CPU\translate('Method')); ?> :</span>
                                        <strong>
                                            <?php echo e(\App\CPU\translate(str_replace('_', ' ', $order['payment_method']))); ?></strong>
                                    </div>

                                    <!-- reference-code -->
                                    <div class="reference-code d-flex justify-content-sm-end gap-10 text-capitalize">
                                        <span class="title-color"><?php echo e(\App\CPU\translate('Reference')); ?>

                                            <?php echo e(\App\CPU\translate('Code')); ?> :</span>
                                        <strong><?php echo e(str_replace('_', ' ', $order['transaction_ref'])); ?></strong>
                                    </div>

                                    <!-- Payment Status -->
                                    <div class="payment-status d-flex justify-content-sm-end gap-10">
                                        <span class="title-color"><?php echo e(\App\CPU\translate('Payment_Status')); ?>:</span>
                                        <?php if($order['payment_status'] == 'paid'): ?>
                                            <span class="text-success font-weight-bold">
                                                <?php echo e(\App\CPU\translate('Paid')); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-danger font-weight-bold">
                                                <?php echo e(\App\CPU\translate('Unpaid')); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>

                                    <?php if(\App\CPU\Helpers::get_business_settings('order_verification')): ?>
                                        <span class="ml-2 ml-sm-3">
                                            <b>
                                                <?php echo e(\App\CPU\translate('order_verification_code')); ?> :
                                                <?php echo e($order['verification_code']); ?>

                                            </b>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive datatable-custom">
                            <table
                                class="table fz-12 table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Item_Details')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Variations')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Tax')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Discount')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Price')); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php ($subtotal = 0); ?>
                                    <?php ($total = 0); ?>
                                    <?php ($shipping = 0); ?>
                                    <?php ($discount = 0); ?>
                                    <?php ($tax = 0); ?>
                                    <?php ($extra_discount = 0); ?>
                                    <?php ($product_price = 0); ?>
                                    <?php ($total_product_price = 0); ?>
                                    <?php ($coupon_discount = 0); ?>
                                    <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($detail->product_all_status): ?>
                                            <tr>
                                                <td>1</td>
                                                <td>
                                                    <div class="media align-items-center gap-10">
                                                        <img src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($detail->product_all_status['thumbnail']); ?>"
                                                            onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img2.jpg')); ?>'"
                                                            class="avatar avatar-60 rounded" alt="">
                                                        <?php if($detail->product_all_status->product_type == 'digital'): ?>
                                                            <button type="button" class="btn btn-sm btn--primary mt-1"
                                                                title="File Upload" data-toggle="modal"
                                                                data-target="#fileUploadModal-<?php echo e($detail->id); ?>"
                                                                onclick="modalFocus('fileUploadModal-<?php echo e($detail->id); ?>')">
                                                                <i class="tio-file-outlined"></i> File
                                                            </button>
                                                        <?php endif; ?>
                                                        <div>
                                                            <a href="#" class="title-color hover-c1">
                                                                <h6><?php echo e(substr($detail->product_all_status['name'], 0, 30)); ?><?php echo e(strlen($detail->product_all_status['name']) > 10 ? '...' : ''); ?>

                                                                </h6>
                                                            </a>
                                                            <div><strong><?php echo e(\App\CPU\translate('Price')); ?> :</strong>
                                                                <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($detail['price']))); ?>

                                                            </div>
                                                            <div><strong><?php echo e(\App\CPU\translate('Qty')); ?> :</strong>
                                                                <?php echo e($detail['qty']); ?></div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo e($detail['variant']); ?></td>
                                                <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($detail['tax']))); ?>

                                                </td>
                                                <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($detail['discount']))); ?>

                                                </td>

                                                <?php ($subtotal = $detail['price'] * $detail->qty + $detail['tax'] - $detail['discount']); ?>
                                                <?php ($product_price = $detail['price'] * $detail['qty']); ?>
                                                <?php ($total_product_price += $product_price); ?>
                                                <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($subtotal))); ?>

                                                </td>
                                                <?php if($detail->product_all_status->product_type == 'digital'): ?>
                                                    <div class="modal fade" id="fileUploadModal-<?php echo e($detail->id); ?>"
                                                        tabindex="-1" aria-labelledby="exampleModalLabel"
                                                        aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <form
                                                                    action="<?php echo e(route('admin.pos.digital-file-upload-after-sell')); ?>"
                                                                    method="post" enctype="multipart/form-data">
                                                                    <?php echo csrf_field(); ?>
                                                                    <div class="modal-body">
                                                                        <?php if($detail->product_all_status->digital_product_type == 'ready_after_sell' && $detail->digital_file_after_sell): ?>
                                                                            <div class="mb-4">
                                                                                <?php echo e(\App\CPU\translate('uploaded_file')); ?> :
                                                                                <a href="<?php echo e(asset('storage/app/public/product/digital-product/' . $detail->digital_file_after_sell)); ?>"
                                                                                    class="btn btn-success btn-sm"
                                                                                    title="Download" download><i
                                                                                        class="tio-download"></i>
                                                                                    Download</a>
                                                                            </div>
                                                                        <?php elseif(
                                                                            $detail->product_all_status->digital_product_type == 'ready_product' &&
                                                                                $detail->product_all_status->digital_file_ready): ?>
                                                                            <div class="mb-4">
                                                                                <?php echo e(\App\CPU\translate('uploaded_file')); ?> :
                                                                                <a href="<?php echo e(asset('storage/app/public/product/digital-product/' . $detail->product_all_status->digital_file_ready)); ?>"
                                                                                    class="btn btn-success btn-sm"
                                                                                    title="Download" download><i
                                                                                        class="tio-download"></i>
                                                                                    Download</a>
                                                                            </div>
                                                                        <?php endif; ?>

                                                                        <?php if($detail->product_all_status->digital_product_type == 'ready_after_sell'): ?>
                                                                            <input type="file"
                                                                                name="digital_file_after_sell"
                                                                                class="form-control">
                                                                            <div class="mt-1 text-info">
                                                                                <?php echo e(\App\CPU\translate('File type: jpg, jpeg, png, gif, zip, pdf')); ?>

                                                                            </div>
                                                                            <input type="hidden"
                                                                                value="<?php echo e($detail->id); ?>"
                                                                                name="order_id">
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-dismiss="modal"><?php echo e(\App\CPU\translate('Close')); ?></button>
                                                                        <?php if($detail->product_all_status->digital_product_type == 'ready_after_sell'): ?>
                                                                            <button type="submit"
                                                                                class="btn btn--primary"><?php echo e(\App\CPU\translate('Upload')); ?></button>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </tr>
                                            <?php ($discount += $detail['discount']); ?>
                                            <?php ($tax += $detail['tax']); ?>
                                            <?php ($total += $subtotal); ?>
                                        <?php endif; ?>
                                        <?php ($sellerId = $detail->seller_id); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <?php ($shipping = $order['shipping_cost']); ?>
                        <hr>
                        <?php
                        if ($order['extra_discount_type'] == 'percent') {
                            $extra_discount = ($total_product_price / 100) * $order['extra_discount'];
                        } else {
                            $extra_discount = $order['extra_discount'];
                        }
                        if (isset($order['discount_amount'])) {
                            $coupon_discount = $order['discount_amount'];
                        }
                        $value_amount = $order['value_amount'];
                        $value_title = $order['value_title'];
                        $delivery_charges = $order['delivery_charges'];
                        ?>
                        <div class="row justify-content-md-end mb-3">
                            <div class="col-md-9 col-lg-8">
                                <dl class="row text-sm-right">

                                    <dt class="col-sm-5"><?php echo e(\App\CPU\translate('extra_discount')); ?></dt>
                                    <dd class="col-sm-6 title-color">
                                        <strong>-
                                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($extra_discount))); ?></strong>
                                    </dd>

                                    <dt class="col-sm-5"><?php echo e(\App\CPU\translate('coupon_discount')); ?></dt>
                                    <dd class="col-sm-6 title-color">
                                        <strong>-
                                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($coupon_discount))); ?></strong>
                                    </dd>
                                    <?php if($value_title != null): ?>
                                        <dt class="col-5"><?php echo e(\App\CPU\translate($value_title)); ?></dt>
                                        <dd class="col-6 title-color">
                                            <strong><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($value_amount))); ?></strong>
                                        </dd>
                                    <?php endif; ?>
                                    <dt class="col-5"><?php echo e(\App\CPU\translate('delivery_charges')); ?></dt>
                                    <dd class="col-6 title-color">
                                        <strong>
                                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($delivery_charges))); ?></strong>
                                    </dd>
                                    <dt class="col-sm-5"><?php echo e(\App\CPU\translate('Total')); ?></dt>
                                    <dd class="col-sm-6 title-color">
                                        <strong><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($total + $shipping - $extra_discount - $coupon_discount + $value_amount + $delivery_charges))); ?></strong>
                                    </dd>
                                </dl>
                                <!-- End Row -->
                            </div>
                        </div>
                        <!-- End Row -->
                    </div>
                    <!-- End Body -->
                </div>
                <!-- End Card -->
            </div>

            <div class="col-lg-4 col-xl-3">
                <!-- Card -->
                <div class="card">

                    <!-- Body -->
                    <?php if($order->customer): ?>
                        <div class="card-body">
                            <h4 class="mb-4 d-flex align-items-center gap-2">
                                <img src="<?php echo e(asset('/public/assets/back-end/img/seller-information.png')); ?>"
                                    alt="">
                                <?php echo e(\App\CPU\translate('Customer_information')); ?>

                            </h4>

                            <div class="media flex-wrap gap-3">
                                <div class="">
                                    <img class="avatar rounded-circle avatar-70"
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(asset('storage/app/public/profile/' . $order->customer->image)); ?>"
                                        alt="Image">
                                </div>
                                <div class="media-body d-flex flex-column gap-1">
                                    <span
                                        class="title-color hover-c1"><strong><?php echo e($order->customer['f_name'] . ' ' . $order->customer['l_name']); ?></strong></span>
                                    <span class="title-color">
                                        <strong><?php echo e(\App\Model\Order::where('order_type', 'POS')->where('customer_id', $order['customer_id'])->count()); ?>

                                        </strong><?php echo e(\App\CPU\translate('orders')); ?>

                                    </span>
                                    <span
                                        class="title-color break-all"><strong><?php echo e($order->customer['phone']); ?></strong></span>
                                    <span class="title-color break-all"><?php echo e($order->customer['email']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card-body">
                            <div class="media align-items-center">
                                <span><?php echo e(\App\CPU\translate('no_customer_found')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <!-- End Body -->
                </div>
                <!-- End Card -->
            </div>
        </div>
        <!-- End Row -->
    </div>
    <!--Show locations on map Modal -->
    <div class="modal fade" id="locationModal" tabindex="-1" role="dialog" aria-labelledby="locationModalLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="locationModalLabel"><?php echo e(\App\CPU\translate('location')); ?>

                        <?php echo e(\App\CPU\translate('data')); ?></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 modal_body_map">
                            <div class="location-map" id="location-map">
                                <div class="__h-400px w-100" id="location_map_canvas"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).on('change', '.payment_status', function() {
            var id = $(this).attr("data-id");
            var value = $(this).val();
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure Change this')); ?>?',
                text: "<?php echo e(\App\CPU\translate('You will not be able to revert this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#377dff',
                cancelButtonColor: 'secondary',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes, Change it')); ?>!'
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.orders.payment-status')); ?>",
                        method: 'POST',
                        data: {
                            "id": id,
                            "payment_status": value
                        },
                        success: function(data) {
                            toastr.success(
                                '<?php echo e(\App\CPU\translate('Status Change successfully')); ?>');
                            location.reload();
                        }
                    });
                }
            })
        });

        function order_status(status) {
            <?php if($order['order_status'] == 'delivered'): ?>
                Swal.fire({
                    title: '<?php echo e(\App\CPU\translate('Order is already delivered, and transaction amount has been disbursed, changing status can be the reason of miscalculation')); ?>!',
                    text: "<?php echo e(\App\CPU\translate('Think before you proceed')); ?>.",
                    showCancelButton: true,
                    confirmButtonColor: '#377dff',
                    cancelButtonColor: 'secondary',
                    confirmButtonText: '<?php echo e(\App\CPU\translate('Yes, Change it')); ?>!'
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "<?php echo e(route('admin.orders.status')); ?>",
                            method: 'POST',
                            data: {
                                "id": '<?php echo e($order['id']); ?>',
                                "order_status": status
                            },
                            success: function(data) {
                                if (data.success == 0) {
                                    toastr.success(
                                        '<?php echo e(\App\CPU\translate('Order is already delivered, You can not change it')); ?> !!'
                                    );
                                    location.reload();
                                } else {
                                    toastr.success(
                                        '<?php echo e(\App\CPU\translate('Status Change successfully')); ?>!');
                                    location.reload();
                                }

                            }
                        });
                    }
                })
            <?php else: ?>
                Swal.fire({
                    title: '<?php echo e(\App\CPU\translate('Are you sure Change this')); ?>?',
                    text: "<?php echo e(\App\CPU\translate('You will not be able to revert this')); ?>!",
                    showCancelButton: true,
                    confirmButtonColor: '#377dff',
                    cancelButtonColor: 'secondary',
                    confirmButtonText: '<?php echo e(\App\CPU\translate('Yes, Change it')); ?>!'
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "<?php echo e(route('admin.orders.status')); ?>",
                            method: 'POST',
                            data: {
                                "id": '<?php echo e($order['id']); ?>',
                                "order_status": status
                            },
                            success: function(data) {
                                if (data.success == 0) {
                                    toastr.success(
                                        '<?php echo e(\App\CPU\translate('Order is already delivered, You can not change it')); ?> !!'
                                    );
                                    location.reload();
                                } else {
                                    toastr.success(
                                        '<?php echo e(\App\CPU\translate('Status Change successfully')); ?>!');
                                    location.reload();
                                }

                            }
                        });
                    }
                })
            <?php endif; ?>
        }
    </script>

    <script>
        function addDeliveryMan(id) {
            $.ajax({
                type: "GET",
                url: '<?php echo e(url('/')); ?>/admin/orders/add-delivery-man/<?php echo e($order['id']); ?>/' + id,
                data: {
                    'order_id': '<?php echo e($order['id']); ?>',
                    'delivery_man_id': id
                },
                success: function(data) {
                    if (data.status == true) {
                        toastr.success('Delivery man successfully assigned/changed', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    } else {
                        toastr.error('Deliveryman man can not assign/change in that status', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                },
                error: function() {
                    toastr.error('Add valid data', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        }

        function last_location_view() {
            toastr.warning('Only available when order is out for delivery!', {
                CloseButton: true,
                ProgressBar: true
            });
        }

        $(function() {
            $('[data-toggle="tooltip"]').tooltip()
        })

        function waiting_for_location() {
            toastr.warning('<?php echo e(\App\CPU\translate('waiting_for_location')); ?>', {
                CloseButton: true,
                ProgressBar: true
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/pos/order/order-details.blade.php ENDPATH**/ ?>