
<?php $__env->startSection('title', \App\CPU\translate('home_service_request')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/back-end/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="mb-3 d-flex justify-content-between">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/message.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('maintain_home_service_button')); ?>

            </h2>
        </div>
        <div class="row mt-20">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="pt-3">
                            <?php ($language = \App\Model\BusinessSetting::where('type', 'pnc_language')->first()); ?>
                            <?php ($language = $language->value ?? null); ?>
                            <?php ($default_lang = 'en'); ?>

                            <?php ($default_lang = json_decode($language)[0]); ?>
                            <ul class="nav nav-tabs w-fit-content mb-4">
                                <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link text-capitalize lang_link <?php echo e($lang == $default_lang ? 'active' : ''); ?>"
                                            href="#"
                                            id="<?php echo e($lang); ?>-link"><?php echo e(\App\CPU\Helpers::get_language_name($lang) . '(' . strtoupper($lang) . ')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <form class="product-form" action="<?php echo e(route('admin.home-service.updateButton')); ?>"
                            method="POST"style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;"
                            enctype="multipart/form-data" id="product_form">
                            <?php echo csrf_field(); ?>
                            <?php if($button['button_image'] != null): ?>
                                <img class="upload-img-view" id="viewer"
                                    onerror='this.src="<?php echo e(asset('public/assets/front-end/img/placeholder.png')); ?>"'
                                    src="<?php echo e(asset('storage/app/public/HomeServiceAddition')); ?>/<?php echo e($button['button_image']); ?>""
                                    alt="Home Servie Button Image" />
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-md-8 form-group">
                                    <div class="mb-2">
                                        <label class="title-color"><?php echo e(\App\CPU\translate('Upload Button Image')); ?></label>
                                        <span class="text-info">* ( <?php echo e(\App\CPU\translate('ratio')); ?> 1:1 )</span>
                                    </div>
                                    <div class="p-2 border border-dashed coba-area">
                                        <input type="file" accept="image/png, image/gif, image/jpeg" name="file[]">
                                    </div>
                                </div>
                            </div>
                            <div class="card-body row">
                                <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    // dd($homeServiceBanner);
                                    if (count($button['translations'])) {
                                        $translate = [];
                                        foreach ($button['translations'] as $t) {
                                            if ($t->locale == $lang && $t->key == 'text') {
                                                $translate[$lang]['text'] = $t->value;
                                            }
                                        }
                                    }
                                    ?>
                                    <div class="<?php echo e($lang != $default_lang ? 'd-none' : ''); ?> lang_form form-group pt-4 col-4"
                                        id="<?php echo e($lang); ?>-form">
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                                        <div class="">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('text')); ?>

                                                (<?php echo e(strtoupper($lang)); ?>)
                                            </label>
                                            </br>
                                            <input type="text"
                                                value="<?php echo e($lang == $default_lang ? $button['text'] : $translate[$lang]['text'] ?? ''); ?>"
                                                class="form-control" name="text[]">
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-group pt-4 col-4">
                                    <label class="title-color" for="description"><?php echo e(\App\CPU\translate('text_color')); ?>

                                    </label>
                                    </br>
                                    <input type="color" value="<?php echo e($button['text_color']); ?>"
                                        class="form-control form-control_color" name="text_color">
                                </div>
                            </div>
                            <button type="submit"class="btn btn--primary mt-3"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/tags-input.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end/js/spartan-multi-image-picker.js')); ?>"></script>
    <script>
        // debugger
        // $("#imgShowCase").html("");

        // $.each(selectedFiles, function(key, value){
        //     let imgPath = "<?php echo e(asset('/')); ?>"+value;

        //     var imagePreview = $('<img>')
        //     .attr('src', URL.createObjectURL(value))
        //     .attr('name', "image" + imageCount)
        //     .attr('onclick', "remove(this)")
        //     .attr('height', "180px")
        //     .addClass('image-thumbnail')
        //     .addClass('col-4');
        //     $("#imgShowCase").append(imagePreview);

        // });


        $(document).ready(function() {
            $('.upload-img-view').click(function() {
                var index = $(this).data('index');
                // Populate the modal content and show the modal based on the retrieved index
                // You can use `index` to identify the clicked image and update modal content accordingly
            });
        });

        function updateValidation(bool) {

            const requiredInput = document.getElementById('bannerUpdateImageInput');

            if (bool == 1) {
                requiredInput.setAttribute('required', 'required');
            } else {
                requiredInput.removeAttribute('required');
            }
        }
        $(".lang_link").click(function(e) {
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            console.log(lang);
            $("#" + lang + "-form").removeClass('d-none');
            if (lang == '<?php echo e($default_lang); ?>') {
                $(".rest-part").removeClass('d-none');
            } else {
                $(".rest-part").addClass('d-none');
            }
        })
    </script>
    
    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '<?php echo e(Session::get('direction')); ?>',
        });
    </script>

    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/home-service/maintain-home-service-button.blade.php ENDPATH**/ ?>