<?php $__env->startSection('title',$seller->shop ? $seller->shop->name : \App\CPU\translate("shop name not found")); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/coupon_setup.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('seller_details')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Page Heading -->
        <div class="flex-between d-sm-flex row align-items-center justify-content-between mb-2 mx-1">
            <div>
                <a href="<?php echo e(route('admin.sellers.seller-list')); ?>" class="btn btn--primary mt-3 mb-3"><?php echo e(\App\CPU\translate('Back_to_seller_list')); ?></a>
            </div>
            <div>
                <?php if($seller->status=="pending"): ?>
                    <div class="mt-4 pr-2">
                        <div class="flex-start">
                            <div class="mx-1"><h4><i class="tio-shop-outlined"></i></h4></div>
                            <div><h4><?php echo e(\App\CPU\translate('Seller request for open a shop')); ?>.</h4></div>
                        </div>
                        <div class="text-center">
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="approved">
                                <button type="submit" class="btn btn--primary btn-sm"><?php echo e(\App\CPU\translate('Approve')); ?></button>
                            </form>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="rejected">
                                <button type="submit" class="btn btn-danger btn-sm"><?php echo e(\App\CPU\translate('reject')); ?></button>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Page Header -->
        <div class="page-header">
            <div class="flex-between mx-1 row">
                <div>
                    <h1 class="page-header-title"><?php echo e($seller->shop ? $seller->shop->name : "Shop Name : Update Please"); ?></h1>
                </div>

            </div>
            <!-- Nav Scroller -->
            <div class="js-nav-scroller hs-nav-scroller-horizontal">
                <!-- Nav -->
                <ul class="nav nav-tabs flex-wrap page-header-tabs">
                    <li class="nav-item">
                        <a class="nav-link " href="<?php echo e(route('admin.sellers.view',$seller->id)); ?>"><?php echo e(\App\CPU\translate('Shop')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link "
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'order'])); ?>"><?php echo e(\App\CPU\translate('Order')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'product'])); ?>"><?php echo e(\App\CPU\translate('Product')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'setting'])); ?>"><?php echo e(\App\CPU\translate('Setting')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'transaction'])); ?>"><?php echo e(\App\CPU\translate('Transaction')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'review'])); ?>"><?php echo e(\App\CPU\translate('Review')); ?></a>
                    </li>

                </ul>
                <!-- End Nav -->
            </div>
            <!-- End Nav Scroller -->
        </div>
        <!-- End Page Header -->

        <div class="row">
            <div class="col-md-6 mt-3">
                <form action="<?php echo e(url()->current()); ?>"
                      style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                      method="GET">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"> <?php echo e(\App\CPU\translate('Sales Commission')); ?> : </h5>
                            <label class="switcher">
                                <input type="checkbox" name="commission_status"
                                       class="switcher_input"
                                       value="1" <?php echo e($seller['sales_commission_percentage']!=null?'checked':''); ?>>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                        <div class="card-body">
                            <small class="badge badge-soft-info text-wrap mb-3">
                                <?php echo e(\App\CPU\translate('If sales commission is disabled here, the system default commission will be applied')); ?>.
                            </small>
                            <div class="form-group">
                                <label><?php echo e(\App\CPU\translate('Commission')); ?> ( % )</label>
                                <input type="number" value="<?php echo e($seller['sales_commission_percentage']); ?>"
                                       class="form-control" name="commission">
                            </div>
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 mt-3">
                <form action="<?php echo e(url()->current()); ?>"
                      style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                      method="GET">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"> <?php echo e(\App\CPU\translate('GST Number')); ?> : </h5>
                            <label class="switcher">
                                <input type="checkbox" name="gst_status"
                                       class="switcher_input"
                                       value="1" <?php echo e($seller['gst']!=null?'checked':''); ?>>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                        <div class="card-body">
                            <small class="badge text-wrap badge-soft-info mb-3">
                                <?php echo e(\App\CPU\translate('If GST number is disabled here, it will not show in invoice')); ?>.
                            </small>
                            <div class="form-group">
                                <label> <?php echo e(\App\CPU\translate('Number')); ?>  </label>
                                <input type="text" value="<?php echo e($seller['gst']); ?>"
                                       class="form-control" name="gst">
                            </div>
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Update')); ?> </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-6 mt-2">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><?php echo e(\App\CPU\translate('Seller POS')); ?></h5>
                    </div>

                    <div class="card-body">
                        <form action="<?php echo e(url()->current()); ?>"
                              method="GET">
                            <?php echo csrf_field(); ?>
                            <label class="title-color d-flex"><?php echo e(\App\CPU\translate('Seller POS permission on/off')); ?></label>
                            <div class="d-flex align-items-center gap-2 mb-1">
                                <input class="" name="seller_pos" type="radio" value="1"
                                       id="seller_pos1" <?php echo e($seller['pos_status']==1?'checked':''); ?>>
                                <label class="mb-0" for="seller_pos1">
                                    <?php echo e(\App\CPU\translate('Turn on')); ?>

                                </label>
                            </div>
                            <div class="d-flex align-items-center gap-2">
                                <input class="" name="seller_pos" type="radio" value="0"
                                       id="seller_pos2" <?php echo e($seller['pos_status']==0?'checked':''); ?>>
                                <label class="mb-0" for="seller_pos2">
                                    <?php echo e(\App\CPU\translate('Turn off')); ?>

                                </label>
                            </div>
                            <div class="d-flex justify-content-end pt-3">
                                <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/seller/view/setting.blade.php ENDPATH**/ ?>