<?php $__env->startSection('title',\App\CPU\translate('My Wallet History')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link rel="stylesheet" media="screen"
          href="<?php echo e(asset('public/assets/front-end')); ?>/vendor/nouislider/distribute/nouislider.min.css"/>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Page Title-->
    <div class="page-title-overlap bg-dark pt-4 rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="container d-lg-flex justify-content-between py-2 py-lg-3">
            <div class="order-lg-2 mb-3 mb-lg-0 pt-lg-2">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-light flex-lg-nowrap justify-content-center justify-content-lg-start">
                        <li class="breadcrumb-item"><a class="text-nowrap" href="<?php echo e(route('home')); ?>"><i class="czi-home"></i><?php echo e(\App\CPU\translate('Home')); ?></a></li>
                        <li class="breadcrumb-item text-nowrap"><a href="#"><?php echo e(\App\CPU\translate('Account')); ?></a>
                        </li>
                        <li class="breadcrumb-item text-nowrap active" aria-current="page"><?php echo e(\App\CPU\translate('Wallet history')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="order-lg-1 text-center text-lg-<?php echo e(Session::get('direction') === "rtl" ? 'right pl-lg-4' : 'left pr-lg-4'); ?>">
                <h1 class="h3 text-light mb-0"><?php echo e(\App\CPU\translate('My orders')); ?></h1>
            </div>
        </div>
    </div>
    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-3 rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <!-- Sidebar-->
            <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- Content  -->
            <section class="col-lg-8">
                <!-- Toolbar-->
                <div class="d-flex justify-content-between align-items-center pt-lg-2 pb-4 pb-lg-5 mb-lg-3">
                    <div class="form-inline">
                        <label class="text-light opacity-75 text-nowrap <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?> d-none d-lg-block" for="order-sort"><?php echo e(\App\CPU\translate('Sort orders')); ?>:</label>
                        <select class="form-control custom-select" id="order-sort">
                            <option><?php echo e(\App\CPU\translate('All')); ?></option>
                            <option><?php echo e(\App\CPU\translate('Delivered')); ?></option>
                            <option><?php echo e(\App\CPU\translate('In Progress')); ?></option>
                            <option><?php echo e(\App\CPU\translate('Delayed')); ?></option>
                            <option><?php echo e(\App\CPU\translate('Canceled')); ?></option>
                        </select>
                    </div><a class="btn btn--primary btn-sm d-none d-lg-inline-block" href="<?php echo e(route('customer.auth.logout')); ?>"><i class="czi-sign-out <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?>"></i><?php echo e(\App\CPU\translate('Sign out')); ?></a>
                </div>
                <!-- Orders list-->
                <div class="table-responsive font-size-md">
                        <table class="table table-hover mb-0">
                            <thead>
                            <tr>
                                <th><?php echo e(\App\CPU\translate('Trans ID')); ?>#</th>
                                <th><?php echo e(\App\CPU\translate('Transaction Method')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Transaction_type')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Transaction Amount')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $wallerHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallerHistories): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="py-3"><a class="nav-link-style font-weight-medium font-size-sm" href="#order-details" data-toggle="modal"><?php echo e($wallerHistories['transaction_id']); ?></a></td>
                                <td class="py-3"><?php echo e($wallerHistories['transaction_type']); ?></td>
                                <td class="py-3"><span class="badge badge-info m-0"><?php echo e($wallerHistories['transaction_method']); ?></span></td>
                                <td class="py-3"><?php echo e($wallerHistories['transaction_amount']); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                </div>
                <hr class="pb-4">
                <!-- Pagination-->
                <nav class="d-flex justify-content-between pt-2" aria-label="Page navigation">
                    <ul class="pagination">
                        <li class="page-item"><a class="page-link" href="#"><i class="czi-arrow-<?php echo e(Session::get('direction') === "rtl" ? 'right ml-2' : 'left mr-2'); ?>"></i><?php echo e(\App\CPU\translate('Prev')); ?></a></li>
                    </ul>
                    <ul class="pagination">
                        <li class="page-item d-sm-none"><span class="page-link page-link-static">1 / 5</span></li>
                        <li class="page-item active d-none d-sm-block" aria-current="page"><span class="page-link">1<span class="sr-only">(<?php echo e(\App\CPU\translate('current')); ?>)</span></span></li>
                        <li class="page-item d-none d-sm-block"><a class="page-link" href="#">2</a></li>
                        <li class="page-item d-none d-sm-block"><a class="page-link" href="#">3</a></li>
                        <li class="page-item d-none d-sm-block"><a class="page-link" href="#">4</a></li>
                        <li class="page-item d-none d-sm-block"><a class="page-link" href="#">5</a></li>
                    </ul>
                    <ul class="pagination">
                        <li class="page-item"><a class="page-link" href="#" aria-label="Next"><?php echo e(\App\CPU\translate('Next')); ?><i class="czi-arrow-<?php echo e(Session::get('direction') === "rtl" ? 'left mr-2' : 'right ml-2'); ?>"></i></a></li>
                    </ul>
                </nav>
            </section>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/front-end')); ?>/vendor/nouislider/distribute/nouislider.min.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/account-wallet.blade.php ENDPATH**/ ?>