<?php $__env->startSection('title',\App\CPU\translate('Product List')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-4">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/products.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Products')); ?>

                <span class="badge badge-soft-dark radius-50 fz-14 ml-1"><?php echo e($products->total()); ?></span>
            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="px-3 py-4">
                        <div class="row align-items-center">
                            <div class="col-lg-4">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <!-- Search -->
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                            placeholder="<?php echo e(\App\CPU\translate('Search by Product Name')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>" required>
                                        <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                    </div>
                                    <!-- End Search -->
                                </form>
                            </div>
                            <div class="col-lg-8 mt-3 mt-lg-0 d-flex flex-wrap gap-3 justify-content-lg-end">
                                <div>
                                    <button type="button" class="btn btn-outline--primary" data-toggle="dropdown">
                                        <i class="tio-download-to"></i>
                                        <?php echo e(\App\CPU\translate('export')); ?>

                                        <i class="tio-chevron-down"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="<?php echo e(route('seller.product.bulk-export')); ?>"><?php echo e(\App\CPU\translate('excel')); ?></a></li>
                                        <div class="dropdown-divider"></div>
                                    </ul>
                                </div>
                                <a href="<?php echo e(route('seller.product.stock-limit-list',['in_house', ''])); ?>" class="btn btn-info">
                                    <i class="tio-add-circle"></i>
                                    <span class="text"><?php echo e(\App\CPU\translate('Limited_Stocks')); ?></span>
                                </a>
                                <a href="<?php echo e(route('seller.product.add-new')); ?>" class="btn btn--primary">
                                    <i class="tio-add"></i>
                                    <span class="text"><?php echo e(\App\CPU\translate('Add new product')); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="datatable" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Product Name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Product Type')); ?></th>
                                <th><?php echo e(\App\CPU\translate('purchase_price')); ?></th>
                                <th><?php echo e(\App\CPU\translate('selling_price')); ?></th>
                                <th><?php echo e(\App\CPU\translate('verify_status')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Active')); ?> <?php echo e(\App\CPU\translate('status')); ?></th>
                                <th class="text-center __w-5px"><?php echo e(\App\CPU\translate('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e($products->firstitem()+ $k); ?></th>
                                    <td>
                                        <a href="<?php echo e(route('seller.product.view',[$p['id']])); ?>" class="media align-items-center gap-2 w-max-content">
                                            <img src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($p['thumbnail']); ?>"
                                                 onerror="this.src='<?php echo e(asset('/public/assets/back-end/img/brand-logo.png')); ?>'"class="avatar border" alt="">
                                            <span class="media-body title-color hover-c1">
                                                <?php echo e(\Illuminate\Support\Str::limit($p['name'],30)); ?>

                                            </span>
                                        </a>
                                    </td>
                                    <td><?php echo e(ucfirst($p['product_type'])); ?></td>
                                    <td>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['purchase_price']))); ?>

                                    </td>
                                    <td>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['unit_price']))); ?>

                                    </td>
                                    <td>
                                        <?php if($p->request_status == 0): ?>
                                            <label class="badge badge-soft-warning"><?php echo e(\App\CPU\translate('New Request')); ?></label>
                                        <?php elseif($p->request_status == 1): ?>
                                            <label class="badge badge-soft-success"><?php echo e(\App\CPU\translate('Approved')); ?></label>
                                        <?php elseif($p->request_status == 2): ?>
                                            <label class="badge badge-soft-danger"><?php echo e(\App\CPU\translate('Denied')); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <label class="switcher">
                                            <input type="checkbox" class="status switcher_input"
                                                    id="<?php echo e($p['id']); ?>" <?php echo e($p->status == 1?'checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-10">
                                            <a class="btn btn-outline-info btn-sm square-btn" title="<?php echo e(\App\CPU\translate('barcode')); ?>"
                                                href="<?php echo e(route('seller.product.barcode', [$p['id']])); ?>">
                                                <i class="tio-barcode"></i>
                                            </a>

                                            <a class="btn btn-outline-info btn-sm square-btn"
                                                title="<?php echo e(\App\CPU\translate('view')); ?>"
                                                href="<?php echo e(route('seller.product.view',[$p['id']])); ?>">
                                                <i class="tio-invisible"></i>
                                            </a>
                                            <a  class="btn btn-outline-primary btn-sm square-btn"
                                                title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                                href="<?php echo e(route('seller.product.edit',[$p['id']])); ?>">
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a  class="btn btn-outline-danger btn-sm square-btn" href="javascript:"
                                                title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                onclick="form_alert('product-<?php echo e($p['id']); ?>','<?php echo e(\App\CPU\translate("Want to delete this item")); ?> ?')">
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                        <form action="<?php echo e(route('seller.product.delete',[$p['id']])); ?>"
                                                method="post" id="product-<?php echo e($p['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($products->links()); ?>

                        </div>
                    </div>

                    <?php if(count($products)==0): ?>
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                            <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });

        $('.status').on('change', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            let t = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('seller.product.status-update')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    if(data.success == true) {
                        toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                    }
                    else if(data.success == false) {
                        t.removeAttr('checked');
                        toastr.error('<?php echo e(\App\CPU\translate('Status updated failed. Product must be approved')); ?>');
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/product/list.blade.php ENDPATH**/ ?>