<?php $__env->startSection('title',\App\CPU\translate('Flash Deal Products')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']->value); ?>"/>
    <meta property="og:title" content="Deals of <?php echo e($web_config['name']->value); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <meta property="twitter:card" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['web_logo']->value); ?>"/>
    <meta property="twitter:title" content="Deals of <?php echo e($web_config['name']->value); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">
    <style>
        .countdown-background{
            background: <?php echo e($web_config['primary_color']); ?>;
        }
        .cz-countdown-days {
            border: .5px solid<?php echo e($web_config['primary_color']); ?>;
        }

        .cz-countdown-hours {
            border: .5px solid<?php echo e($web_config['primary_color']); ?>;
        }

        .cz-countdown-minutes {
            border: .5px solid<?php echo e($web_config['primary_color']); ?>;
        }
        .cz-countdown-seconds {
            border: .5px solid<?php echo e($web_config['primary_color']); ?>;
        }
        .flash_deal_product_details .flash-product-price {
            color: <?php echo e($web_config['primary_color']); ?>;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php ($decimal_point_settings = \App\CPU\Helpers::get_business_settings('decimal_point_settings')); ?>
<div class="__inline-59">
    <div class="for-banner container">

        <img class="d-block for-image"
             onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
             src="<?php echo e(asset('storage/app/public/deal')); ?>/<?php echo e($deal['banner']); ?>"
             alt="Shop Converse">

    </div>
    <div class="container md-4 mt-3 rtl"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row g-3 flex-center align-items-center">
            <?php ($flash_deals=\App\Model\FlashDeal::with(['products.product.reviews'])->where(['status'=>1])->where(['deal_type'=>'flash_deal'])->whereDate('start_date','<=',date('Y-m-d'))->whereDate('end_date','>=',date('Y-m-d'))->first()); ?>
            <div class="col-sm-auto text-center <?php echo e(Session::get('direction') === "rtl" ? 'text-sm-right' : 'text-sm-left'); ?>">
                <span class="flash_deal_title ">
                    <?php echo e(\App\CPU\translate('flash_deal')); ?>

                </span>
            </div>
            <div class="col-sm-auto ">
                <div class="countdown-background __countdown mx-auto">
                    <span class="cz-countdown d-flex justify-content-center align-items-center"
                        data-countdown="<?php echo e(isset($flash_deals)?date('m/d/Y',strtotime($flash_deals['end_date'])):''); ?> 11:59:00 PM">
                        <span class="cz-countdown-days align-items-center">
                            <span class="cz-countdown-value"></span>
                            <span><?php echo e(\App\CPU\translate('day')); ?></span>
                        </span>
                        <span class="cz-countdown-value p-1">:</span>
                        <span class="cz-countdown-hours align-items-center">
                            <span class="cz-countdown-value"></span>
                            <span><?php echo e(\App\CPU\translate('hrs')); ?></span>
                        </span>
                        <span class="cz-countdown-value p-1">:</span>
                        <span class="cz-countdown-minutes align-items-center">
                            <span class="cz-countdown-value"></span>
                            <span><?php echo e(\App\CPU\translate('min')); ?></span>
                        </span>
                        <span class="cz-countdown-value p-1">:</span>
                        <span class="cz-countdown-seconds align-items-center">
                            <span class="cz-countdown-value"></span>
                            <span><?php echo e(\App\CPU\translate('sec')); ?></span>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <!-- Toolbar-->

    <!-- Products grid-->
    <div class="container pb-5 mb-2 mb-md-4 mt-3 rtl"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <section class="col-lg-12">
                <div class="row mt-4">
                    <?php if($discountPrice): ?>
                        <?php $__currentLoopData = $deal->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(isset($dp->product)): ?>
                                <div class="col-xl-2 col-sm-3 col-6 __mb-10px">

                                    <?php echo $__env->make('web-views.partials._single-product',['product'=>$dp->product,'decimal_point_settings'=>$decimal_point_settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/deals.blade.php ENDPATH**/ ?>