<?php $__env->startSection('title', $product->name . ' barcode ' . date('Y/m/d')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/back-end')); ?>/css/barcode.css"/>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row m-2 show-div">
        <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
            <div class="card">
                <div class="card-header">
                    <h3>
                        <?php echo e(\App\CPU\translate('generate_barcode')); ?>

                    </h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive-lg">
                        <table
                            class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('code')); ?></th>
                                <th><?php echo e(\App\CPU\translate('name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('quantity')); ?></th>
                                <th><?php echo e(\App\CPU\translate('action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <th>
                                        <?php if($product->code): ?>
                                            <span>
                                                    <?php echo e($product->code); ?>

                                                </span>

                                        <?php else: ?>

                                            <a href="<?php echo e(route('seller.product.edit',[$product['id']])); ?>">
                                                <?php echo e(\App\CPU\translate('update_your_product_code')); ?>

                                            </a>

                                        <?php endif; ?>
                                    </th>
                                    <th><?php echo e(Str::limit($product->name, 20)); ?></th>
                                    <th>
                                        <input id="limit" type="number" name="limit" min="1" class="form-control"
                                               value="<?php echo e(request('limit')); ?>">
                                        <span
                                            class="text-info mt-1 d-block"><?php echo e(\App\CPU\translate('maximum_quantity_270')); ?></span>
                                    </th>

                                    <th>
                                        <button class="btn btn-info"
                                                type="submit"><?php echo e(\App\CPU\translate('generate_barcode')); ?></button>
                                        <a href="<?php echo e(route('seller.product.barcode', [$product['id']])); ?>"
                                           class="btn btn-danger"><?php echo e(\App\CPU\translate('reset')); ?></a>
                                        <button type="button" id="print_bar" onclick="printDiv('printarea')"
                                                class="btn btn--primary "><?php echo e(\App\CPU\translate('print')); ?></button>
                                    </th>
                                </form>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12 mt-5 p-4">
            <h1 class="style-one-br show-div2">
                <?php echo e(\App\CPU\translate("This page is for A4 size page printer, so it won't be visible in smaller devices")); ?>

                .
            </h1>
        </div>
    </div>

    <div id="printarea" class="show-div">
        <?php $__currentLoopData = $array_chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $array): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="barcodea4">
                <?php for($i = 0; $i < count($array); $i++): ?>
                    <div class="item style24">
                        <span
                            class="barcode_site text-capitalize"><?php echo e(\App\Model\BusinessSetting::where('type', 'company_name')->first()->value); ?></span>
                        <span class="barcode_name text-capitalize"><?php echo e(Str::limit($product->name, 20)); ?></span>
                        <div class="barcode_price text-capitalize">
                            <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($product->unit_price))); ?>

                        </div>

                        <?php if($product->code !== null): ?>
                            <div
                                class="barcode_image d-flex justify-content-center"><?php echo DNS1D::getBarcodeHTML($product->code, 'C128'); ?></div>
                            <div class="barcode_code text-capitalize"><?php echo e(\App\CPU\translate('code')); ?>

                                : <?php echo e($product->code); ?></div>
                        <?php else: ?>
                            <p class="text-danger"><?php echo e(\App\CPU\translate('please_update_product_code')); ?></p>
                        <?php endif; ?>
                    </div>
                <?php endfor; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script_2'); ?>
    <script src=<?php echo e(asset('public/assets/admin/js/global.js')); ?>></script>
    <script>
        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
            location.reload();
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/product/barcode.blade.php ENDPATH**/ ?>