<?php $__env->startSection('title',\App\CPU\translate('Support Ticket')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Title-->
    <div class="container rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <h2 class="m-0 headerTitle text-center py-3"><?php echo e(\App\CPU\translate('Support Ticket Answer')); ?></h2>
    </div>
    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-3 rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <!-- Sidebar-->
        <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content  -->
            <section class="col-lg-8">
                <div class="card __card mb-4">
                    <div class="table-responsive">
                        <table class="table __table mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(\App\CPU\translate('Date Submitted')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Last Updated')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Type')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Priority')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['created_at'])->format('Y-m-d')); ?>

                                    </td>
                                    <td>
                                        <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['updated_at'])->format('Y-m-d')); ?>

                                    </td>
                                    <td>
                                        <?php echo e($ticket['type']); ?>

                                    </td>
                                    <td>
                                        <?php echo e($ticket['priority']); ?>

                                    </td>
                                    <td>
                                        <?php if($ticket['status']=='open'): ?>
                                            <span class="badge btn btn-secondary"><?php echo e($ticket['status']); ?></span>
                                        <?php else: ?>
                                            <span class="badge btn btn-secondary"><?php echo e($ticket['status']); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Comment-->
                <div class="card __card mb-4">
                    <div class="__media-wrapper card-body">
                        <div class="media __incoming-msg">
                            <img class="rounded-circle __img-40" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>;"
                                onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                src="<?php echo e(asset('storage/app/public/profile')); ?>/<?php echo e(auth('customer')->user()->image); ?>"
                                alt="<?php echo e(auth('customer')->user()->f_name); ?>"/>
                            <div class="media-body">
                                <h6 class="font-size-md mb-2"><?php echo e(auth('customer')->user()->f_name); ?></h6>
                                <p class="font-size-md mb-1"><?php echo e($ticket['description']); ?></p>
                                <span class="font-size-ms text-muted">
                                        <i class="czi-time align-middle <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?>"></i>
                                    <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['created_at'])->format('Y-m-d h:i A')); ?>

                                </span>
                            </div>
                        </div>
                        <?php $__currentLoopData = $ticket->conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if($conversation['customer_message'] == null ): ?>
                                <div class="media __outgoing-msg">
                                    <div class="media-body">
                                        <?php ($admin=\App\Model\Admin::where('id',$conversation['admin_id'])->first()); ?>
                                        <h6 class="font-size-md mb-2"><?php echo e($admin['name']); ?></h6>
                                        <p class="font-size-md mb-1"><?php echo e($conversation['admin_message']); ?></p>
                                        <span
                                            class="font-size-ms text-muted"> <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['updated_at'])->format('Y-m-d h:i A')); ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($conversation['admin_message'] == null): ?>
                                <div class="media __incoming-msg">
                                    <img class="rounded-circle" height="40" width="40"
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(asset('storage/app/public/profile')); ?>/<?php echo e(auth('customer')->user()->image); ?>"
                                        alt="<?php echo e(auth('customer')->user()->f_name); ?>"/>
                                    <div class="media-body">
                                        <h6 class="font-size-md mb-2"><?php echo e(auth('customer')->user()->f_name); ?></h6>
                                        <p class="font-size-md mb-1"><?php echo e($conversation['customer_message']); ?></p>
                                        <span class="font-size-ms text-muted">
                                                    <i class="czi-time align-middle <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?>"></i>
                                            <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['created_at'])->format('Y-m-d h:i A')); ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="card-footer border-0">
                        <form class="needs-validation" href="<?php echo e(route('support-ticket.comment',[$ticket['id']])); ?>"
                            method="post" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <textarea class="form-control" name="comment" rows="8"
                                        placeholder="<?php echo e(\App\CPU\translate('Write your message here...')); ?>" required></textarea>
                                <div class="invalid-tooltip"><?php echo e(\App\CPU\translate('Please write the message')); ?>!</div>
                            </div>
                            <div class="d-flex flex-wrap justify-content-end align-items-center gap-8">
                                <div>
                                    <a href="<?php echo e(route('support-ticket.close',[$ticket['id']])); ?>" class="btn btn-secondary text-white"><?php echo e(\App\CPU\translate('close')); ?></a>
                                </div>
                                <button class="btn btn--primary my-2" type="submit"><?php echo e(\App\CPU\translate('Submit message')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/ticket-view.blade.php ENDPATH**/ ?>