<?php $__env->startSection('title', \App\CPU\translate('Product List')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3 d-flex flex-column gap-1">
            <h2 class="h1 text-capitalize d-flex gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/inhouse-product-list.png')); ?>" class="mb-1 mr-1" alt="">
                <?php echo e(\App\CPU\translate('Limited_Stocked_Products_List')); ?>

                <span class="badge badge-soft-dark radius-50 fz-14 ml-1"><?php echo e($pro->total()); ?></span>
            </h2>
            <p class="d-flex"><?php echo e(\App\CPU\translate('the_products_are_shown_in_this_list,_which_quantity_is_below')); ?> <?php echo e($stock_limit); ?></p>
        </div>
        <!-- End Page Title -->

        <div class="row mt-30">
            <div class="col-md-12">
                <div class="card">
                    <div class="px-3 py-4">
                        <div class="row justify-content-between align-items-center gy-2">
                            <div class="col-auto">
                                <!-- Search -->
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group input-group-custom input-group-merge">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                               placeholder="<?php echo e(\App\CPU\translate('Search Product Name')); ?>"
                                               aria-label="Search orders"
                                               value="<?php echo e($search); ?>" required>
                                        <input type="hidden" value="<?php echo e($request_status); ?>" name="status">
                                        <button type="submit"
                                                class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                    </div>
                                </form>
                                <!-- End Search -->
                            </div>

                            <div class="col-12 mt-1 col-md-6 col-lg-3">
                                <select name="qty_ordr_sort" class="form-control"
                                        onchange="location.href='<?php echo e(route('admin.product.stock-limit-list',['in_house', ''])); ?>/?sort_oqrderQty='+this.value">
                                    <option
                                        value="default" <?php echo e($sort_oqrderQty== "default"?'selected':''); ?>><?php echo e(\App\CPU\translate('default_sort')); ?></option>
                                    <option
                                        value="quantity_asc" <?php echo e($sort_oqrderQty== "quantity_asc"?'selected':''); ?>><?php echo e(\App\CPU\translate('quantity_sort_by_(low_to_high)')); ?></option>
                                    <option
                                        value="quantity_desc" <?php echo e($sort_oqrderQty== "quantity_desc"?'selected':''); ?>><?php echo e(\App\CPU\translate('quantity_sort_by_(high_to_low)')); ?></option>
                                    <option
                                        value="order_asc" <?php echo e($sort_oqrderQty== "order_asc"?'selected':''); ?>><?php echo e(\App\CPU\translate('order_sort_by_(low_to_high)')); ?></option>
                                    <option
                                        value="order_desc" <?php echo e($sort_oqrderQty== "order_desc"?'selected':''); ?>><?php echo e(\App\CPU\translate('order_sort_by_(high_to_low)')); ?></option>
                                </select>
                            </div>

                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="datatable"
                                style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Product_Name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('purchase_price')); ?></th>
                                <th><?php echo e(\App\CPU\translate('selling_price')); ?></th>
                                <th><?php echo e(\App\CPU\translate('quantity')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('Active')); ?> <?php echo e(\App\CPU\translate('status')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $pro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th scope="row"><?php echo e($pro->firstItem()+$k); ?></th>
                                    <td>
                                        <a href="<?php echo e(route('admin.product.view',[$p['id']])); ?>" class="media align-items-center gap-2">
                                            <img src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($p['thumbnail']); ?>"
                                                 onerror="this.src='<?php echo e(asset('/public/assets/back-end/img/brand-logo.png')); ?>'"class="avatar border" alt="">
                                            <span class="media-body title-color hover-c1">
                                                <?php echo e(\Illuminate\Support\Str::limit($p['name'],20)); ?>

                                            </span>
                                        </a>
                                    </td>
                                    <td>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['purchase_price']))); ?>

                                    </td>
                                    <td>
                                        <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($p['unit_price']))); ?>

                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center product-quantity">
                                            <?php echo e($p['current_stock']); ?>


                                            <button class="btn py-0 px-2 fz-18" id="<?php echo e($p->id); ?>"
                                                    onclick="update_quantity(<?php echo e($p->id); ?>)" type="button"
                                                    data-toggle="modal" data-target="#update-quantity"
                                                    title="<?php echo e(\App\CPU\translate('update_quantity')); ?>">
                                                <i class="tio-add-circle c1"></i>
                                            </button>
                                        </div>
                                    </td>
                                    <?php if($p->request_status != 2 ): ?>
                                    <td class="text-center">
                                        <label class="switcher mx-auto">
                                            <input type="checkbox" class="switcher_input status"
                                                    id="<?php echo e($p['id']); ?>" <?php echo e($p->status == 1?'checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <?php endif; ?>
                                    <td>
                                        <div class="d-flex justify-content-center gap-2">
                                            <a class="btn btn-outline-info btn-sm square-btn" title="<?php echo e(\App\CPU\translate('barcode')); ?>"
                                                href="<?php echo e(route('admin.product.barcode', [$p['id']])); ?>">
                                                <i class="tio-barcode"></i>
                                            </a>
                                            <a class="btn btn-outline--primary btn-sm square-btn"
                                                title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                                href="<?php echo e(route('admin.product.edit',[$p['id']])); ?>">
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="btn btn-outline-danger btn-sm square-btn" href="javascript:"
                                                title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                onclick="form_alert('product-<?php echo e($p['id']); ?>','Want to delete this item ?')">
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                        <form action="<?php echo e(route('admin.product.delete',[$p['id']])); ?>"
                                                method="post" id="product-<?php echo e($p['id']); ?>">
                                            <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($pro->links()); ?>

                        </div>
                    </div>

                    <?php if(count($pro)==0): ?>
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                 alt="Image Description">
                            <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="update-quantity" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('admin.product.update-quantity')); ?>" method="post" class="row">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="rest-part"></div>
                        <div class="d-flex justify-content-end gap-10 flex-wrap align-items-center">
                            <button type="button" class="btn btn-danger px-4" data-dismiss="modal" aria-label="Close">
                                <?php echo e(\App\CPU\translate('close')); ?>

                            </button>
                            <button class="btn btn--primary" class="btn btn--primary px-4" type="submit"><?php echo e(\App\CPU\translate('submit')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        function update_quantity(val) {
            $.get({
                url: '<?php echo e(url('/')); ?>/admin/product/get-variations?id='+val,
                dataType: 'json',
                success: function (data) {
                    console.log(data)
                    $('.rest-part').empty().html(data.view);
                },
            });
        }

        function update_qty() {
            var total_qty = 0;
            var qty_elements = $('input[name^="qty_"]');
            for (var i = 0; i < qty_elements.length; i++) {
                total_qty += parseInt(qty_elements.eq(i).val());
            }
            if (qty_elements.length > 0) {

                $('input[name="current_stock"]').attr("readonly", true);
                $('input[name="current_stock"]').val(total_qty);
            } else {
                $('input[name="current_stock"]').attr("readonly", false);
            }
        }
    </script>
     <script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });

        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.product.status-update')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function (data) {
                    if(data.success == true) {
                        toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                    }
                    else if(data.success == false) {
                        toastr.error('<?php echo e(\App\CPU\translate('Status updated failed. Product must be approved')); ?>');
                        setTimeout(function(){
                            location.reload();
                        }, 2000);
                    }
                }
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/product/stock-limit-list.blade.php ENDPATH**/ ?>