<?php $__env->startSection('title', \App\CPU\translate('POS')); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content -->
    <!-- ========================= SECTION CONTENT ========================= -->
    <section class="section-content pt-5">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-7 mb-4 mb-lg-0">
                    <div class="card">
                        <h5 class="p-3 m-0 bg-light"><?php echo e(\App\CPU\translate('Product_Section')); ?></h5>
                        <div class="px-3 py-4">
                            <div class="row gy-1">
                                <div class="col-sm-6">
                                    <div class="input-group d-flex justify-content-end">
                                        <select name="category" id="category" class="form-control js-select2-custom w-100"
                                            title="select category" onchange="set_category_filter(this.value)">
                                            <option value=""><?php echo e(\App\CPU\translate('All Categories')); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"
                                                    <?php echo e($category == $item->id ? 'selected' : ''); ?>><?php echo e($item->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <form class="">
                                        <!-- Search -->
                                        <div class="input-group-overlay input-group-merge input-group-custom">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text">
                                                    <i class="tio-search"></i>
                                                </div>
                                            </div>
                                            <input id="search" autocomplete="off" type="text"
                                                value="<?php echo e($keyword ? $keyword : ''); ?>" name="search"
                                                class="form-control search-bar-input"
                                                placeholder="<?php echo e(\App\CPU\translate('Search by Name or Barcode')); ?>"
                                                aria-label="Search here">
                                            <diV
                                                class="card pos-search-card w-4 position-absolute z-index-1 w-100 overflow-auto">
                                                <div id="pos-search-box" class="card-body search-result-box d--none"></div>
                                            </diV>
                                        </div>
                                        <!-- End Search -->
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pt-2" id="items">
                            <div class="pos-item-wrap">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('admin-views.pos._single_product', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="table-responsive mt-4">
                            <div class="px-4 d-flex justify-content-lg-end">
                                <!-- Pagination -->
                                <?php echo $products->withQueryString()->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5 mb-5">
                    <div class="card billing-section-wrap">
                        <h5 class="p-3 m-0 bg-light"><?php echo e(\App\CPU\translate('Billing_Section')); ?></h5>
                        <div class="card-body">
                            <div class="form-group d-flex gap-2">
                                <select onchange="customer_change(this.value);" id='customer' name="customer_id"
                                    data-placeholder="Walk In Customer"
                                    class="js-data-example-ajax form-control form-ellipsis">
                                    <option value="0"><?php echo e(\App\CPU\translate('walking_customer')); ?></option>
                                </select>
                                <button class="btn btn-success rounded text-nowrap" id="add_new_customer" type="button"
                                    data-toggle="modal" data-target="#add-customer" title="Add Customer">
                                    <i class="tio-add"></i>
                                    <?php echo e(\App\CPU\translate('customer')); ?>

                                </button>
                            </div>
                            <div class="form-group">
                                <label class="text-capitalize title-color d-flex align-items-center flex-wrap gap-1">
                                    <?php echo e(\App\CPU\translate('current_customer')); ?> :
                                    <span class="mb-0" id="current_customer"></span>
                                </label>
                            </div>
                            <div class="d-flex gap-2 flex-wrap flex-sm-nowrap mb-3">
                                <select id='cart_id' name="cart_id" class=" form-control js-select2-custom"
                                    onchange="cart_change(this.value);">
                                </select>
                                <a class="btn btn-secondary rounded text-nowrap" onclick="clear_cart()">
                                    <?php echo e(\App\CPU\translate('clear_cart')); ?>

                                </a>
                                <a class="btn btn-info rounded text-nowrap" onclick="new_order()">
                                    <?php echo e(\App\CPU\translate('new_order')); ?>

                                </a>
                            </div>
                            <div id="cart" class="pb-5">
                                <?php echo $__env->make('admin-views.pos._cart', ['cart_id' => $cart_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- container //  -->
    </section>

    <!-- End Content -->
    <div class="modal fade pt-5" id="quick-view" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" id="quick-view-modal">

            </div>
        </div>
    </div>

    <?php ($order = \App\Model\Order::find(session('last_order'))); ?>
    <?php if($order): ?>
        <?php (session(['last_order' => false])); ?>
        <div class="modal fade py-5" id="print-invoice" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(\App\CPU\translate('Print Invoice')); ?></h5>
                        <button id="invoice_close" type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body row">
                        <div class="col-md-12">
                            <center>
                                <input id="print_invoice" type="button" class="btn btn--primary non-printable"
                                    onclick="printDiv('printableArea')"
                                    value="<?php echo e(\App\CPU\translate('proceed')); ?>, <?php echo e(\App\CPU\translate('if_thermal_printer_is_ready')); ?>" />
                                <a href="<?php echo e(url()->previous()); ?>"
                                    class="btn btn-danger non-printable"><?php echo e(\App\CPU\translate('Back')); ?></a>
                            </center>
                            <hr class="non-printable">
                        </div>
                        <div class="row m-auto" id="printableArea">
                            <?php echo $__env->make('admin-views.pos.order.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade" id="add-customer" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(\App\CPU\translate('add_new_customer')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('admin.pos.customer-store')); ?>" method="post" id="product_form">
                        <?php echo csrf_field(); ?>
                        <div class="row pl-2">
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('first_name')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="f_name" class="form-control"
                                        value="<?php echo e(old('f_name')); ?>" placeholder="<?php echo e(\App\CPU\translate('first_name')); ?>"
                                        required>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('last_name')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="l_name" class="form-control"
                                        value="<?php echo e(old('l_name')); ?>" placeholder="<?php echo e(\App\CPU\translate('last_name')); ?>"
                                        required>
                                </div>
                            </div>
                        </div>
                        <div class="row pl-2">
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('email')); ?><span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control"
                                        value="<?php echo e(old('email')); ?>"
                                        placeholder="<?php echo e(\App\CPU\translate('Ex')); ?>: ex@example.com" required>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('phone')); ?><span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="phone" class="form-control"
                                        value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(\App\CPU\translate('phone')); ?>"
                                        required>
                                </div>
                            </div>
                        </div>
                        <div class="row pl-2">
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('country')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="country" class="form-control"
                                        value="<?php echo e(old('country')); ?>" placeholder="<?php echo e(\App\CPU\translate('country')); ?>"
                                        required>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('city')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="city" class="form-control"
                                        value="<?php echo e(old('city')); ?>" placeholder="<?php echo e(\App\CPU\translate('city')); ?>"
                                        required>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('zip_code')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="zip_code" class="form-control"
                                        value="<?php echo e(old('zip_code')); ?>" placeholder="<?php echo e(\App\CPU\translate('zip_code')); ?>"
                                        required>
                                </div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="form-group">
                                    <label class="input-label"><?php echo e(\App\CPU\translate('address')); ?> <span
                                            class="input-label-secondary text-danger">*</span></label>
                                    <input type="text" name="address" class="form-control"
                                        value="<?php echo e(old('address')); ?>" placeholder="<?php echo e(\App\CPU\translate('address')); ?>"
                                        required>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <button type="submit" id="submit_new_customer"
                            class="btn btn--primary"><?php echo e(\App\CPU\translate('submit')); ?></button>
                    </form>
                    <input type="hidden" id="barcodeInput" placeholder="Scan Barcode">
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        function delay(callback, ms) {
            var timer = 0;
            return function() {
                var context = this,
                    args = arguments;
                clearTimeout(timer);
                timer = setTimeout(function() {
                    callback.apply(context, args);
                }, ms || 0);
            };
        }

        $(document).on('ready', function() {
            $.ajax({
                url: '<?php echo e(route('admin.pos.get-cart-ids')); ?>',
                type: 'GET',

                dataType: 'json', // added data type
                beforeSend: function() {
                    $('#loading').removeClass('d-none');
                    //console.log("loding");
                },
                success: function(data) {
                    //console.log(data.cus);
                    var output = '';
                    for (var i = 0; i < data.cart_nam.length; i++) {
                        output +=
                            `<option value="${data.cart_nam[i]}" ${data.current_user==data.cart_nam[i]?'selected':''}>${data.cart_nam[i]}</option>`;
                    }
                    $('#cart_id').html(output);
                    $('#current_customer').text(data.current_customer);
                    $('#cart').empty().html(data.view);

                },
                complete: function() {
                    $('#loading').addClass('d-none');
                },
            });
        });

        function form_submit() {
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure')); ?>?',
                type: 'warning',
                showCancelButton: true,
                showConfirmButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                cancelButtonText: 'No',
                confirmButtonText: 'Yes',
                reverseButtons: true
            }).then(function(result) {
                if (result.value) {
                    $('#order_place').submit();
                }
            });
        }
    </script>
    <script>
        document.addEventListener("keydown", function(event) {
            "use strict";
            if (event.altKey && event.code === "KeyO") {
                $('#submit_order').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyZ") {
                $('#payment_close').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyS") {
                $('#order_complete').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyC") {
                emptyCart();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyA") {
                $('#add_new_customer').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyN") {
                $('#submit_new_customer').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyK") {
                $('#short-cut').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyP") {
                $('#print_invoice').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyQ") {
                $('#search').focus();
                $("#-pos-search-box").css("display", "none");
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyE") {
                $("#pos-search-box").css("display", "none");
                $('#extra_discount').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyD") {
                $("#pos-search-box").css("display", "none");
                $('#coupon_discount').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyB") {
                $('#invoice_close').click();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyX") {
                clear_cart();
                event.preventDefault();
            }
            if (event.altKey && event.code === "KeyR") {
                new_order();
                event.preventDefault();
            }

        });
    </script>
    <!-- JS Plugins Init. -->
    <script>
        jQuery(".search-bar-input").on('keyup', function() {
            //$('#pos-search-box').removeClass('d-none');
            $(".pos-search-card").removeClass('d-none').show();
            let name = $(".search-bar-input").val();
            //console.log(name);
            if (name.length > 0) {
                $('#pos-search-box').removeClass('d-none').show();
                $.get({
                    url: '<?php echo e(route('admin.pos.search-products')); ?>',
                    dataType: 'json',
                    data: {
                        name: name
                    },
                    beforeSend: function() {
                        $('#loading').removeClass('d-none');
                    },
                    success: function(data) {
                        //console.log(data.count);

                        $('.search-result-box').empty().html(data.result);
                        if (data.count == 0) {
                            $(".pos-search-card").hide();
                        }
                        if (data.count == 1) {
                            $('.search-result-box').empty().hide();
                            $('#search').val('');
                            quickView(data.id);
                        }

                    },
                    complete: function() {
                        $('#loading').addClass('d-none');
                        console.log(data)
                    },
                });
            } else {
                $(".pos-search-card").hide();
                $('.search-result-box').empty();

            }
        });
    </script>
    <!-- jQuery("#payLater").hide(); -->
    <script>
        "use strict";

        function customer_change(val) {
            debugger
            if (val != 0) {}
            $.post({
                url: '<?php echo e(route('admin.pos.remove-discount')); ?>',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    //cart_id:cart_id,
                    user_id: val
                },
                beforeSend: function() {
                    $('#loading').removeClass('d-none');
                },
                success: function(data) {
                    // jQuery("#payLater").show();
                    console.log(data);

                    var output = '';
                    for (var i = 0; i < data.cart_nam.length; i++) {
                        output +=
                            `<option value="${data.cart_nam[i]}" ${data.current_user==data.cart_nam[i]?'selected':''}>${data.cart_nam[i]}</option>`;
                    }
                    $('#cart_id').html(output);
                    $('#current_customer').text(data.current_customer);
                    $('#cart').empty().html(data.view);
                },
                complete: function() {
                    $('#loading').addClass('d-none');
                }
            });
        }
    </script>
    <script>
        "use strict";

        function clear_cart() {
            let url = "<?php echo e(route('admin.pos.clear-cart-ids')); ?>";
            document.location.href = url;
            $('#search').val('');
            $('#search').focus();
        }
    </script>
    <script>
        "use strict";

        function new_order() {
            let url = "<?php echo e(route('admin.pos.new-cart-id')); ?>";
            document.location.href = url;
            $('#search').val('');
            $('#search').focus();
        }
    </script>
    <script>
        "use strict";

        function cart_change(val) {
            let cart_id = val;
            let url = "<?php echo e(route('admin.pos.change-cart')); ?>" + '/?cart_id=' + val;
            document.location.href = url;
            $('#search').val('');
            $('#search').focus();
        }
    </script>
    <script>
        "use strict";

        function extra_discount() {
            debugger
            //let  user_id = $('#customer').val();
            let discount = $('#dis_amount').val();
            let type = $('#type_ext_dis').val();
            //let  cart_id = $('#cart_id').val();
            if (discount > 0) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.post({
                    url: '<?php echo e(route('admin.pos.discount')); ?>',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        discount: discount,
                        type: type,
                        //cart_id:cart_id
                    },
                    beforeSend: function() {
                        $('#loading').removeClass('d-none');
                    },
                    success: function(data) {
                        // console.log(data);
                        if (data.extra_discount === 'success') {
                            toastr.success('<?php echo e(\App\CPU\translate('extra_discount_added_successfully')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        } else if (data.extra_discount === 'empty') {
                            toastr.warning('<?php echo e(\App\CPU\translate('your_cart_is_empty')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });

                        } else {
                            toastr.warning(
                                '<?php echo e(\App\CPU\translate('this_discount_is_not_applied_for_this_amount')); ?>', {
                                    CloseButton: true,
                                    ProgressBar: true
                                });
                        }

                        $('.modal-backdrop').addClass('d-none');
                        $('#cart').empty().html(data.view);
                        $('#search').val('');
                        $('#search').focus();
                    },
                    complete: function() {
                        $('.modal-backdrop').addClass('d-none');
                        $(".footer-offset").removeClass("modal-open");
                        $('#loading').addClass('d-none');
                    }
                });
            } else {
                toastr.warning('<?php echo e(\App\CPU\translate('amount_can_not_be_negative_or_zero!')); ?>', {
                    CloseButton: true,
                    ProgressBar: true
                });
            }

            $('#search').focus();
        }

        function value_amount() {
            debugger
            let value_amount = $('#val_amount').val();
            let value_title = $('#value_title').val();
            if (value_amount > 0) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.post({
                    url: '<?php echo e(route('admin.pos.value')); ?>',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        value_amount: value_amount,
                        value_title: value_title,
                        //cart_id:cart_id
                    },
                    beforeSend: function() {
                        $('#loading').removeClass('d-none');
                    },
                    success: function(data) {
                        console.log(data);
                        if (data.value_amount === 'success') {
                            toastr.success('<?php echo e(\App\CPU\translate('value_added_successfully')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        } else if (data.value_amount === 'empty') {
                            toastr.warning('<?php echo e(\App\CPU\translate('your_cart_is_empty')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        } else {
                            toastr.warning(
                                '<?php echo e(\App\CPU\translate('this_value_is_not_applied_for_this_amount')); ?>', {
                                    CloseButton: true,
                                    ProgressBar: true
                                });
                        }
                        $('.modal-backdrop').addClass('d-none');
                        $('#cart').empty().html(data.view);
                        $('#search').val('');
                        $('#search').focus();
                    },
                    complete: function() {
                        $('.modal-backdrop').addClass('d-none');
                        $(".footer-offset").removeClass("modal-open");
                        $('#loading').addClass('d-none');
                    }
                });
            } else {
                toastr.warning('<?php echo e(\App\CPU\translate('amount_can_not_be_negative_or_zero!')); ?>', {
                    CloseButton: true,
                    ProgressBar: true
                });
            }

            $('#search').focus();
        }

        function delivery_amount() {
            debugger
            let del_ammount = $('#del_ammount').val();
            if (del_ammount > 0) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.post({
                    url: '<?php echo e(route('admin.pos.delievery-charges')); ?>',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        del_ammount: del_ammount,
                    },
                    beforeSend: function() {
                        $('#loading').removeClass('d-none');
                    },
                    success: function(data) {
                        console.log(data);
                        if (data.del_ammount === 'success') {
                            toastr.success('<?php echo e(\App\CPU\translate('delivery_charges_added_successfully')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        } else if (data.del_ammount === 'empty') {
                            toastr.warning('<?php echo e(\App\CPU\translate('your_cart_is_empty')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        } else {
                            toastr.warning(
                                '<?php echo e(\App\CPU\translate('this_value_is_not_applied_for_this_amount')); ?>', {
                                    CloseButton: true,
                                    ProgressBar: true
                                });
                        }
                        $('.modal-backdrop').addClass('d-none');
                        $('#cart').empty().html(data.view);
                        $('#search').val('');
                        $('#search').focus();
                    },
                    complete: function() {
                        $('.modal-backdrop').addClass('d-none');
                        $(".footer-offset").removeClass("modal-open");
                        $('#loading').addClass('d-none');
                    }
                });

            } else {
                toastr.warning('<?php echo e(\App\CPU\translate('amount_can_not_be_negative_or_zero!')); ?>', {
                    CloseButton: true,
                    ProgressBar: true
                });
            }

            $('#search').focus();
        }
    </script>
    <script>
        "use strict";

        function coupon_discount() {

            let coupon_code = $('#coupon_code').val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('admin.pos.coupon-discount')); ?>',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    coupon_code: coupon_code,
                },
                beforeSend: function() {
                    $('#loading').removeClass('d-none');
                },
                success: function(data) {
                    console.log(data);
                    if (data.coupon === 'success') {
                        toastr.success('<?php echo e(\App\CPU\translate('coupon_added_successfully')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    } else if (data.coupon === 'amount_low') {
                        toastr.warning(
                            '<?php echo e(\App\CPU\translate('this_discount_is_not_applied_for_this_amount')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                    } else if (data.coupon === 'cart_empty') {
                        toastr.warning('<?php echo e(\App\CPU\translate('your_cart_is_empty')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    } else {
                        toastr.warning('<?php echo e(\App\CPU\translate('coupon_is_invalid')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }

                    $('#cart').empty().html(data.view);
                    $('#search').val('');
                    $('#search').focus();
                },
                complete: function() {
                    $('.modal-backdrop').addClass('d-none');
                    $(".footer-offset").removeClass("modal-open");
                    $('#loading').addClass('d-none');
                }
            });

            $('#search').focus();

        }
    </script>
    <script>
        $(document).on('ready', function() {
            <?php if($order): ?>
                $('#print-invoice').modal('show');
            <?php endif; ?>
        });

        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
            // location.reload();
        }

        function set_category_filter(id) {
            var nurl = new URL('<?php echo url()->full(); ?>');
            nurl.searchParams.set('category_id', id);
            location.href = nurl;
        }


        $('#search-form').on('submit', function(e) {
            e.preventDefault();
            var keyword = $('#datatableSearch').val();
            var nurl = new URL('<?php echo url()->full(); ?>');
            nurl.searchParams.set('keyword', keyword);
            location.href = nurl;
        });

        function store_key(key, value) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                }
            });
            $.post({
                url: '<?php echo e(route('admin.pos.store-keys')); ?>',
                data: {
                    key: key,
                    value: value,
                },
                success: function(data) {
                    toastr.success(key + ' ' + '<?php echo e(\App\CPU\translate('selected')); ?>!', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
            });
        }

        function addon_quantity_input_toggle(e) {
            var cb = $(e.target);
            if (cb.is(":checked")) {
                cb.siblings('.addon-quantity-input').css({
                    'visibility': 'visible'
                });
            } else {
                cb.siblings('.addon-quantity-input').css({
                    'visibility': 'hidden'
                });
            }
        }

        function quickView(product_id) {
            debugger
            $.ajax({
                url: '<?php echo e(route('admin.pos.quick-view')); ?>',
                type: 'GET',
                data: {
                    product_id: product_id
                },
                dataType: 'json',
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    if (data.product.colors == "[]") {
                        $('#quick-view-modal').empty().html(data.view);
                        addToCart();
                    } else {
                        $('#quick-view-modal').empty().html(data.view);
                        $('#quick-view').modal('show');
                    }
                },
                complete: function() {
                    $('#loading').hide();
                },
            });
        }

        function quickViewByCode(barcode) {
            debugger
            $.ajax({
                url: '<?php echo e(route('admin.pos.quick-view-by-code')); ?>',
                type: 'GET',
                data: {
                    barcode: barcode
                },
                dataType: 'json',
                beforeSend: function() {
                    $('#loading').show();
                },
                success: function(data) {
                    console.log(data);
                    if (data.product.colors == "[]") {
                        $('#quick-view-modal').empty().html(data.view);
                        addToCart();
                    } else {
                        $('#quick-view-modal').empty().html(data.view);
                        $('#quick-view').modal('show');
                    }
                },
                complete: function() {
                    $('#loading').hide();
                },
            });
        }
        $('#barcodeInput').on('change', function() {
            var scannedBarcode = $(this).val();
            quickViewByCode(scannedBarcode);
            // Clear the input after scanning
            $(this).val('');
            $('#search').val('');
            $('#search').focus();
        });

        function checkAddToCartValidity() {
            var names = {};
            $('#add-to-cart-form input:radio').each(function() { // find unique names
                names[$(this).attr('name')] = true;
            });
            var count = 0;
            $.each(names, function() { // then count them
                count++;
            });

            if (($('input:radio:checked').length - 1) == count) {
                return true;
            }
            return false;
        }

        function cartQuantityInitialize() {
            $('.btn-number').click(function(e) {
                e.preventDefault();

                var fieldName = $(this).attr('data-field');
                var type = $(this).attr('data-type');
                var input = $("input[name='" + fieldName + "']");
                var currentVal = parseInt(input.val());

                if (!isNaN(currentVal)) {
                    if (type == 'minus') {

                        if (currentVal > input.attr('min')) {
                            input.val(currentVal - 1).change();
                        }
                        if (parseInt(input.val()) == input.attr('min')) {
                            $(this).attr('disabled', true);
                        }

                    } else if (type == 'plus') {

                        if (currentVal < input.attr('max')) {
                            input.val(currentVal + 1).change();
                        }
                        if (parseInt(input.val()) == input.attr('max')) {
                            $(this).attr('disabled', true);
                        }

                    }
                } else {
                    input.val(0);
                }
            });

            $('.input-number').focusin(function() {
                $(this).data('oldValue', $(this).val());
            });

            $('.input-number').change(function() {

                minValue = parseInt($(this).attr('min'));
                maxValue = parseInt($(this).attr('max'));
                valueCurrent = parseInt($(this).val());

                var name = $(this).attr('name');
                if (valueCurrent >= minValue) {
                    $(".btn-number[data-type='minus'][data-field='" + name + "']").removeAttr('disabled')
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Cart',
                        text: 'Sorry, the minimum value was reached'
                    });
                    $(this).val($(this).data('oldValue'));
                }
                if (valueCurrent <= maxValue) {
                    $(".btn-number[data-type='plus'][data-field='" + name + "']").removeAttr('disabled')
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Cart',
                        text: 'Sorry, stock limit exceeded.'
                    });
                    $(this).val($(this).data('oldValue'));
                }
            });
            $(".input-number").keydown(function(e) {
                // Allow: backspace, delete, tab, escape, enter and .
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
                    // Allow: Ctrl+A
                    (e.keyCode == 65 && e.ctrlKey === true) ||
                    // Allow: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            });
            $('#search').val('');
            $('#search').focus();
        }

        function getVariantPrice() {
            if ($('#add-to-cart-form input[name=quantity]').val() > 0 && checkAddToCartValidity()) {
                var isPack = $('#isPack');

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.ajax({
                    type: "POST",
                    url: '<?php echo e(route('admin.pos.variant_price')); ?>',
                    data: $('#add-to-cart-form').serializeArray(),
                    success: function(data) {
                        // var dataPack = data.pack;
                        // var result = Object.keys(dataPack).map((key) => [key, obj[dataPack]]);
                        // console.log(dataPack)

                        $('#add-to-cart-form #chosen_price_div').removeClass('d-none');
                        $('#add-to-cart-form #chosen_price_div #chosen_price').html(data.price);
                        var packSelect = $('#pack-select');
                        var packLable = $('#packLable');
                        // var packDiv = $('#packDiv');
                        // // packSelect.empty(); // Clear existing o
                        // if (data.pack == "No Pack Found" || data.pack.isActive == 0 ) {
                        //     packDiv.removeClass("d-flex");
                        //     packDiv.addClass("d-none");
                        //     isPack.prop('disabled', true);
                        //     isPack.val(false);
                        // } else {
                        //     isPack.prop('disabled', false);
                        //     packLable.text(data.pack.pack_name);
                        //     packDiv.removeClass("d-none");
                        //     packDiv.addClass("d-flex");
                        //     // if (data.pack && Array.isArray(data.pack)) {
                        //     //     $.each(data.pack, function(index, pack) {
                        //     //         // Append a new option for each pack
                        //     //         packSelect.append('<option value="' + pack.id + '">' + pack.pack_name +
                        //     //             '</option>');
                        //     //     });
                        //     // }
                        // }

                        $('#set-discount-amount').html(data.discount);
                    }
                });
            }
        }

        function addToCart(form_id = 'add-to-cart-form') {
            if (checkAddToCartValidity()) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                    }
                });
                $.post({
                    // url: '<?php echo e(route('admin.pos.add-to-cart')); ?>',
                    url: '<?php echo e(route('admin.pos.add-to-cart')); ?>',
                    data: $('#' + form_id).serializeArray(),
                    beforeSend: function() {
                        $('#loading').show();
                    },
                    success: function(data) {
                        console.log(data);
                        if (data.data == 1) {
                            let currentQtyInput = $('#currentQty'+data.cart_id);
                            let increasedValue = parseInt(currentQtyInput.val()) + 1;
                            currentQtyInput.val(increasedValue);
                            currentQtyInput.trigger('keyup');
                            return false
                        } else if (data.data == 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Cart',
                                text: '<?php echo e(\App\CPU\translate('Sorry, product is out of stock.')); ?>'
                            });
                            return false;
                        }
                        $('.call-when-done').click();

                        toastr.success('<?php echo e(\App\CPU\translate('Item has been added in your cart!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        $('#cart').empty().html(data.view);
                        //updateCart();
                        $('.search-result-box').empty().hide();
                        $('#search').val('');
                    },
                    complete: function() {
                        $('#loading').hide();
                    }
                });
            } else {
                Swal.fire({
                    type: 'info',
                    title: 'Cart',
                    text: '<?php echo e(\App\CPU\translate('Please choose all the options')); ?>'
                });
            }

            $('#search').focus();
        }

        function removeFromCart(key) {
            //console.log(key);
            $.post('<?php echo e(route('admin.pos.remove-from-cart')); ?>', {
                _token: '<?php echo e(csrf_token()); ?>',
                key: key
            }, function(data) {

                $('#cart').empty().html(data.view);
                if (data.errors) {
                    for (var i = 0; i < data.errors.length; i++) {
                        toastr.error(data.errors[i].message, {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                } else {
                    //updateCart();

                    toastr.info('<?php echo e(\App\CPU\translate('Item has been removed from cart')); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }


            });
            $('#search').val('');
            $('#search').focus();
        }

        function emptyCart() {
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are_you_sure?')); ?>',
                text: '<?php echo e(\App\CPU\translate('You_want_to_remove_all_items_from_cart!!')); ?>',
                type: 'warning',
                showCancelButton: true,
                cancelButtonColor: 'default',
                confirmButtonColor: '#161853',
                cancelButtonText: '<?php echo e(\App\CPU\translate('No')); ?>',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.post('<?php echo e(route('admin.pos.emptyCart')); ?>', {
                        _token: '<?php echo e(csrf_token()); ?>'
                    }, function(data) {
                        $('#cart').empty().html(data.view);
                        toastr.info('<?php echo e(\App\CPU\translate('Item has been removed from cart')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    });
                }
            })
            $('#search').val('');
            $('#search').focus();
        }

        function updateCart() {
            $.post('<?php echo e(route('admin.pos.cart_items')); ?>', {
                _token: '<?php echo e(csrf_token()); ?>'
            }, function(data) {
                $('#cart').empty().html(data);
            });
            $('#search').val('');
            $('#search').focus();
        }

        $(function() {
            $(document).on('click', 'input[type=number]', function() {
                this.select();
            });
            $('#search').val('');
            $('#search').focus();
        });


        function updateQuantity(key, qty, e, variant = null) {
            debugger
            if (qty !== "") {
                var element = $(e.target);
                var minValue = parseInt(element.attr('min'));
                // maxValue = parseInt(element.attr('max'));
                var valueCurrent = parseInt(element.val());

                //var key = element.data('key');

                $.post('<?php echo e(route('admin.pos.updateQuantity')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    key: key,
                    quantity: qty,
                    variant: variant
                }, function(data) {

                    if (data.product_type === 'physical' && data.qty < 0) {
                        toastr.warning('<?php echo e(\App\CPU\translate('product_quantity_is_not_enough!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    if (data.upQty === 'zeroNegative') {
                        toastr.warning(
                            '<?php echo e(\App\CPU\translate('Product_quantity_can_not_be_zero_or_less_than_zero_in_cart!')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                    }
                    if (data.qty_update == 1) {
                        toastr.success('<?php echo e(\App\CPU\translate('Product_quantity_updated!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    $('#cart').empty().html(data.view);
                });
            } else {
                var element = $(e.target);
                var minValue = parseInt(element.attr('min'));
                var valueCurrent = parseInt(element.val());

                $.post('<?php echo e(route('admin.pos.updateQuantity')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    key: key,
                    quantity: minValue,
                    variant: variant
                }, function(data) {

                    if (data.product_type === 'physical' && data.qty < 0) {
                        toastr.warning('<?php echo e(\App\CPU\translate('product_quantity_is_not_enough!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    if (data.upQty === 'zeroNegative') {
                        toastr.warning(
                            '<?php echo e(\App\CPU\translate('Product_quantity_can_not_be_zero_or_less_than_zero_in_cart!')); ?>', {
                                CloseButton: true,
                                ProgressBar: true
                            });
                    }
                    if (data.qty_update == 1) {
                        toastr.success('<?php echo e(\App\CPU\translate('Product_quantity_updated!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                    }
                    $('#cart').empty().html(data.view);
                });
                $('#search').val('');
                $('#search').focus();
            }

            // Allow: backspace, delete, tab, escape, enter and .
            if (e.type == 'keydown') {
                if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
                    // Allow: Ctrl+A
                    (e.keyCode == 65 && e.ctrlKey === true) ||
                    // Allow: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    // let it happen, don't do anything
                    return;
                }
                // Ensure that it is a number and stop the keypress
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                    e.preventDefault();
                }
            }

        };

        // INITIALIZATION OF SELECT2
        // =======================================================
        // $('.js-select2-custom').each(function () {
        //     var select2 = $.HSCore.components.HSSelect2.init($(this));
        // });

        $('.js-data-example-ajax').select2({
            ajax: {
                url: '<?php echo e(route('admin.pos.customers')); ?>',
                data: function(params) {
                    return {
                        q: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                __port: function(params, success, failure) {
                    var $request = $.ajax(params);

                    $request.then(success);
                    $request.fail(failure);

                    return $request;
                }
            }
        });

        $('#order_place').submit(function(eventObj) {
            if ($('#customer').val()) {
                $(this).append('<input type="hidden" name="user_id" value="' + $('#customer').val() + '" /> ');
            }
            return true;
        });
    </script>
    <!-- IE Support -->
    <script>
        if (/MSIE \d|Trident.*rv:/.test(navigator.userAgent)) document.write(
            '<script src="<?php echo e(asset('public/assets/admin')); ?>/vendor/babel-polyfill/polyfill.min.js"><\/script>');
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/pos/index.blade.php ENDPATH**/ ?>