<?php $__env->startSection('title', \App\CPU\translate('Add new notification')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/push_notification.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('push_notification')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- End Page Header -->
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.notification.store')); ?>" method="post"
                              style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                              enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="title-color text-capitalize"
                                               for="exampleFormControlInput1"><?php echo e(\App\CPU\translate('Title')); ?> </label>
                                        <input type="text" name="title" class="form-control"
                                               placeholder="<?php echo e(\App\CPU\translate('New notification')); ?>"
                                               required>
                                    </div>
                                    <div class="physical_product_show">
                                        <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Product')); ?> 
                                        </label>
                                        <select class="js-example-basic-multiple form-control select2" name="product_id">
                                        <option value="" selected disabled>--Select Product--</option>
                                            <?php $__currentLoopData = \App\CPU\ProductManager::products(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($x['id'] . ':::' . $x['slug']); ?>">
                                                    <?php echo e($x['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="title-color text-capitalize"
                                               for="exampleFormControlInput1"><?php echo e(\App\CPU\translate('Description')); ?> </label>
                                        <textarea name="description" class="form-control" required></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <center>
                                            <img class="upload-img-view mb-4" id="viewer"
                                                 onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                 src="<?php echo e(asset('public/assets/admin/img/900x400/img1.jpg')); ?>"
                                                 alt="image"/>
                                        </center>
                                        <label
                                            class="title-color text-capitalize"><?php echo e(\App\CPU\translate('Image')); ?> </label>
                                        <span class="text-info">(<?php echo e(\App\CPU\translate('Ratio_1:1')); ?>)</span>
                                        <div class="custom-file text-left">
                                            <input type="file" name="image" id="customFileEg1" class="custom-file-input"
                                                   accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                            <label class="custom-file-label"
                                                   for="customFileEg1"><?php echo e(\App\CPU\translate('Choose file')); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(\App\CPU\translate('reset')); ?> </button>
                                <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Send')); ?>  <?php echo e(\App\CPU\translate('Notification')); ?>  </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <div class="card">
                    <div class="px-3 py-4">
                        <div class="row align-items-center">
                            <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                                <h5 class="mb-0 text-capitalize d-flex align-items-center gap-2">
                                    <?php echo e(\App\CPU\translate('push_notification_table')); ?>

                                    <span
                                        class="badge badge-soft-dark radius-50 fz-12 ml-1"><?php echo e($notifications->total()); ?></span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                               placeholder="<?php echo e(\App\CPU\translate('Search by Title')); ?>"
                                               aria-label="Search orders" value="<?php echo e($search); ?>" required>
                                        <button type="submit"
                                                class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="table-responsive datatable-custom">
                        <table style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                               class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Title')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Product')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Description')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Image')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('notification_count')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Status')); ?> </th>
                                <th><?php echo e(\App\CPU\translate('Resend')); ?> </th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?> </th>
                            </tr>

                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($notifications->firstItem()+ $key); ?></td>
                                    <td>
                                        <span class="d-block">
                                            <?php echo e(\Illuminate\Support\Str::limit($notification['title'],30)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if(isset($notification['product']) && $notification['product']['name'] !== null): ?>
                                            <span class="d-block">
                                                <?php echo e($notification['product']['name']); ?>

                                            </span>
                                            
                                        <?php else: ?>
                                            <span class="d-block">
                                                No Product!
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php echo e(\Illuminate\Support\Str::limit($notification['description'],40)); ?>

                                    </td>
                                    <td>
                                        <img class="min-w-75" width="75" height="75"
                                             onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img2.jpg')); ?>'"
                                             src="<?php echo e(asset('storage/app/public/notification')); ?>/<?php echo e($notification['image']); ?>">
                                    </td>
                                    <td id="count-<?php echo e($notification->id); ?>"><?php echo e($notification['notification_count']); ?></td>
                                    <td>
                                        <label class="switcher">
                                            <input type="checkbox" class="status switcher_input"
                                                   id="<?php echo e($notification['id']); ?>" <?php echo e($notification->status == 1?'checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <a href="javascript:void(0)" class="btn btn-outline-success square-btn btn-sm"
                                           onclick="resendNotification(this)" data-id="<?php echo e($notification->id); ?>">
                                            <i class="tio-refresh"></i>
                                        </a>
                                    </td>
                                    <td class="text-center">
                                        <div class="d-flex justify-content-center gap-2">
                                            <a class="btn btn-outline--primary btn-sm edit square-btn"
                                               title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                               href="<?php echo e(route('admin.notification.edit',[$notification['id']])); ?>">
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="btn btn-outline-danger btn-sm delete"
                                               title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                               href="javascript:"
                                               id="<?php echo e($notification['id']); ?>')">
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <table class="mt-4">
                            <tfoot>
                            <?php echo $notifications->links(); ?>

                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End Table -->
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).on('change', '.status', function () {
            var id = $(this).attr("id");
            if ($(this).prop("checked") == true) {
                var status = 1;
            } else if ($(this).prop("checked") == false) {
                var status = 0;
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.notification.status')); ?>",
                method: 'POST',
                data: {
                    id: id,
                    status: status
                },
                success: function () {
                    toastr.success('<?php echo e(\App\CPU\translate('Status updated successfully')); ?>');
                    location.reload();
                }
            });
        });
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure delete this')); ?> ?',
                text: "<?php echo e(\App\CPU\translate('You will not be able to revert this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete it')); ?>!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.notification.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('notification deleted successfully')); ?>');
                            location.reload();
                        }
                    });
                }
            })
        });
    </script>

    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this);
        });

        function resendNotification(t) {
            let id = $(t).data('id');

            Swal.fire({
                title: '<?php echo e(\App\CPU\translate("Are_you_sure?")); ?>',
                text: '<?php echo e(\App\CPU\translate('Resend_notification')); ?>',
                type: 'warning',
                showCancelButton: true,
                cancelButtonColor: 'default',
                confirmButtonColor: '#161853',
                cancelButtonText: '<?php echo e(\App\CPU\translate("No")); ?>',
                confirmButtonText: '<?php echo e(\App\CPU\translate("Yes")); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo e(route("admin.notification.resend-notification")); ?>',
                        type: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            id: id
                        },
                        beforeSend: function () {
                            $('#loading').show();
                        },
                        success: function (res) {
                            let toasterMessage = res.success ? toastr.success : toastr.info;

                            toasterMessage(res.message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                            $('#count-' + id).text(parseInt($('#count-' + id).text()) + 1);
                        },
                        complete: function () {
                            $('#loading').hide();
                        }
                    });
                }
            })
        }
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/notification/index.blade.php ENDPATH**/ ?>