<div class="feature_header mb-2">
    <span><?php echo e(\App\CPU\translate('shopping_cart')); ?></span>
</div>

<?php ($shippingMethod=\App\CPU\Helpers::get_business_settings('shipping_method')); ?>
<?php ($cart=\App\Model\Cart::where(['customer_id' => auth('customer')->id()])->get()->groupBy('cart_group_id')); ?>

<div class="row g-3">
    <!-- List of items-->
    <section class="col-lg-8">
            <?php if(count($cart)==0): ?>
                <?php ($physical_product = false); ?>
            <?php endif; ?>

            <?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group_key=>$group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card __card cart_information mb-3">
                <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($shippingMethod=='inhouse_shipping'): ?>
                            <?php

                            $admin_shipping = \App\Model\ShippingType::where('seller_id', 0)->first();
                            $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';

                            ?>
                    <?php else: ?>
                            <?php
                            if ($cartItem->seller_is == 'admin') {
                                $admin_shipping = \App\Model\ShippingType::where('seller_id', 0)->first();
                                $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
                            } else {
                                $seller_shipping = \App\Model\ShippingType::where('seller_id', $cartItem->seller_id)->first();
                                $shipping_type = isset($seller_shipping) == true ? $seller_shipping->shipping_type : 'order_wise';
                            }
                            ?>
                    <?php endif; ?>

                    <?php if($cart_key==0): ?>
                        <div class="card-header">
                            <?php if($cartItem->seller_is=='admin'): ?>
                            <b>
                                <span><?php echo e(\App\CPU\translate('shop_name')); ?> : </span>
                                <a href="<?php echo e(route('shopView',['id'=>0])); ?>"><?php echo e(\App\CPU\Helpers::get_business_settings('company_name')); ?></a>
                            </b>
                        <?php else: ?>
                            <b>
                                <span><?php echo e(\App\CPU\translate('shop_name')); ?>:</span>
                                <a href="<?php echo e(route('shopView',['id'=>$cartItem->seller_id])); ?>">
                                    <?php echo e(\App\Model\Shop::where(['seller_id'=>$cartItem['seller_id']])->first()->name); ?>

                                </a>
                            </b>
                        <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="table-responsive mt-3">
                    <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table __cart-table">
                        <thead class="thead-light">
                            <tr class="">
                                <th class="font-weight-bold __w-5p"><?php echo e(\App\CPU\translate('SL#')); ?></th>
                                <?php if( $shipping_type != 'order_wise'): ?>
                                <th class="font-weight-bold __w-30p"><?php echo e(\App\CPU\translate('product_details')); ?></th>
                                <?php else: ?>
                                <th class="font-weight-bold __w-45"><?php echo e(\App\CPU\translate('product_details')); ?></th>
                                <?php endif; ?>
                                <th class="font-weight-bold __w-15p"><?php echo e(\App\CPU\translate('unit_price')); ?></th>
                                <th class="font-weight-bold __w-15p"><?php echo e(\App\CPU\translate('qty')); ?></th>
                                <th class="font-weight-bold __w-15p"><?php echo e(\App\CPU\translate('price')); ?></th>
                                <?php if( $shipping_type != 'order_wise'): ?>
                                    <th class="font-weight-bold __w-15p"><?php echo e(\App\CPU\translate('shipping_cost')); ?> </th>
                                <?php endif; ?>
                                <th class="font-weight-bold __w-5p"></th>
                            </tr>
                        </thead>

                        <tbody>
                        <?php
                            $physical_product = false;
                            foreach ($group as $row) {
                                if ($row->product_type == 'physical') {
                                    $physical_product = true;
                                }
                            }
                        ?>
                        <?php $__currentLoopData = $group; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_key=>$cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($cart_key+1); ?></td>
                                <td>
                                    <div class="d-flex">
                                        <div class="__w-30p">
                                            <a href="<?php echo e(route('product',$cartItem['slug'])); ?>">
                                                <img class="rounded __img-62"
                                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                        src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($cartItem['thumbnail']); ?>"
                                                        alt="Product">
                                            </a>
                                        </div>
                                        <div class="ml-2 text-break __line-2 __w-70p">
                                            <a href="<?php echo e(route('product',$cartItem['slug'])); ?>"><?php echo e($cartItem['name']); ?></a>

                                        </div>

                                    </div>
                                    <div class="d-flex">

                                        <?php $__currentLoopData = json_decode($cartItem['variations'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-muted mr-2">
                                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?> __text-12px">
                                                    <?php echo e($key1); ?> : <?php echo e($variation); ?></span>

                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </td>
                                <td>
                                    <div
                                            class=" text-accent"><?php echo e(\App\CPU\Helpers::currency_converter($cartItem['price']-$cartItem['discount'])); ?></div>
                                        <?php if($cartItem['discount'] > 0): ?>
                                            <strike class="__inline-18">
                                                <?php echo e(\App\CPU\Helpers::currency_converter($cartItem['price'])); ?>

                                            </strike>
                                        <?php endif; ?>
                                        </div>
                                </td>
                                <td>
                                    <div>
                                        <?php ($minimum_order=\App\Model\Product::select('minimum_order_qty')->find($cartItem['product_id'])); ?>
                                        <input class="__cart-input" type="number" name="quantity[<?php echo e($cartItem['id']); ?>]" id="cartQuantity<?php echo e($cartItem['id']); ?>"
                                        onchange="updateCartQuantity('<?php echo e($minimum_order->minimum_order_qty); ?>', '<?php echo e($cartItem['id']); ?>')" min="<?php echo e($minimum_order->minimum_order_qty ?? 1); ?>" value="<?php echo e($cartItem['quantity']); ?>">
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e(\App\CPU\Helpers::currency_converter(($cartItem['price']-$cartItem['discount'])*$cartItem['quantity'])); ?>

                                    </div>
                                </td>
                                <td>
                                    <?php if( $shipping_type != 'order_wise'): ?>
                                        <?php echo e(\App\CPU\Helpers::currency_converter($cartItem['shipping_cost'])); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button class="btn btn-link px-0 text-danger"
                                            onclick="removeFromCart(<?php echo e($cartItem['id']); ?>)" type="button"><i
                                            class="czi-close-circle <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?>"></i>
                                    </button>
                                </td>
                                </tr>

                                <?php if($physical_product && $shippingMethod=='sellerwise_shipping' && $shipping_type == 'order_wise'): ?>
                                    <?php ($choosen_shipping=\App\Model\CartShipping::where(['cart_group_id'=>$cartItem['cart_group_id']])->first()); ?>

                                    <?php if(isset($choosen_shipping)==false): ?>
                                        <?php ($choosen_shipping['shipping_method_id']=0); ?>
                                    <?php endif; ?>

                                    <?php ($shippings=\App\CPU\Helpers::get_shipping_methods($cartItem['seller_id'],$cartItem['seller_is'])); ?>
                                    <tr>
                                        <td colspan="4">

                                            <?php if($cart_key==$group->count()-1): ?>

                                                <!-- choosen shipping method-->

                                                <div class="row">

                                                    <div class="col-12">
                                                        <select class="form-control"
                                                                onchange="set_shipping_id(this.value,'<?php echo e($cartItem['cart_group_id']); ?>')">
                                                            <option><?php echo e(\App\CPU\translate('choose_shipping_method')); ?></option>
                                                            <?php $__currentLoopData = $shippings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    value="<?php echo e($shipping['id']); ?>" <?php echo e($choosen_shipping['shipping_method_id']==$shipping['id']?'selected':''); ?>>
                                                                    <?php echo e($shipping['title'].' ( '.$shipping['duration'].' ) '.\App\CPU\Helpers::currency_converter($shipping['cost'])); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>

                                    <?php endif; ?>
                                </td>
                                <td colspan="3">
                                    <?php if($cart_key==$group->count()-1): ?>
                                    <div class="row">
                                        <div class="col-12">
                                            <span>
                                                <b><?php echo e(\App\CPU\translate('shipping_cost')); ?> : </b>
                                            </span>
                                            <?php echo e(\App\CPU\Helpers::currency_converter($choosen_shipping['shipping_method_id']!= 0?$choosen_shipping->shipping_cost:0)); ?>

                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php if($shippingMethod=='inhouse_shipping'): ?>
        <?php
            $admin_shipping = \App\Model\ShippingType::where('seller_id', 0)->first();
            $shipping_type = isset($admin_shipping) == true ? $admin_shipping->shipping_type : 'order_wise';
        ?>
    <?php if($shipping_type == 'order_wise' && $physical_product): ?>
        <?php ($shippings=\App\CPU\Helpers::get_shipping_methods(1,'admin')); ?>
        <?php ($choosen_shipping=\App\Model\CartShipping::where(['cart_group_id'=>$cartItem['cart_group_id']])->first()); ?>

        <?php if(isset($choosen_shipping)==false): ?>
            <?php ($choosen_shipping['shipping_method_id']=0); ?>
        <?php endif; ?>
        <div class="row">
            <div class="col-12">
                <select class="form-control" onchange="set_shipping_id(this.value,'all_cart_group')">
                    <option><?php echo e(\App\CPU\translate('choose_shipping_method')); ?></option>
                    <?php $__currentLoopData = $shippings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipping): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option
                            value="<?php echo e($shipping['id']); ?>" <?php echo e($choosen_shipping['shipping_method_id']==$shipping['id']?'selected':''); ?>>
                            <?php echo e($shipping['title'].' ( '.$shipping['duration'].' ) '.\App\CPU\Helpers::currency_converter($shipping['cost'])); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>

<?php if( $cart->count() == 0): ?>
    <div class="d-flex justify-content-center align-items-center">
        <h4 class="text-danger text-capitalize"><?php echo e(\App\CPU\translate('cart_empty')); ?></h4>
    </div>
<?php endif; ?>


        <form  method="get">
            <div class="form-group">
                <div class="row">
                    <div class="col-12">
                        <label for="phoneLabel" class="form-label input-label"><?php echo e(\App\CPU\translate('order_note')); ?> <span
                                            class="input-label-secondary">(<?php echo e(\App\CPU\translate('Optional')); ?>)</span></label>
                        <textarea class="form-control w-100" id="order_note" name="order_note"><?php echo e(session('order_note')); ?></textarea>
                    </div>
                </div>
            </div>
        </form>


        <div class="d-flex btn-full-max-sm align-items-center __gap-6px flex-wrap justify-content-between">
            <a href="<?php echo e(route('home')); ?>" class="btn btn--primary">
                <i class="fa fa-<?php echo e(Session::get('direction') === "rtl" ? 'forward' : 'backward'); ?> px-1"></i> <?php echo e(\App\CPU\translate('continue_shopping')); ?>

            </a>
            <a onclick="checkout()"
            class="btn btn--primary pull-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>">
                <?php echo e(\App\CPU\translate('checkout')); ?>

                <i class="fa fa-<?php echo e(Session::get('direction') === "rtl" ? 'backward' : 'forward'); ?> px-1"></i>
            </a>
        </div>
</section>
<!-- Sidebar-->
<?php echo $__env->make('web-views.partials._order-summary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<script>
    cartQuantityInitialize();

    function set_shipping_id(id, cart_group_id) {
        $.get({
            url: '<?php echo e(url('/')); ?>/customer/set-shipping-method',
            dataType: 'json',
            data: {
                id: id,
                cart_group_id: cart_group_id
            },
            beforeSend: function () {
                $('#loading').show();
            },
            success: function (data) {
                location.reload();
            },
            complete: function () {
                $('#loading').hide();
            },
        });
    }
</script>
<script>
    function checkout() {
        let order_note = $('#order_note').val();
        //console.log(order_note);
        $.post({
            url: "<?php echo e(route('order_note')); ?>",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                order_note: order_note,

            },
            beforeSend: function () {
                $('#loading').show();
            },
            success: function (data) {
                let url = "<?php echo e(route('checkout-details')); ?>";
                location.href = url;

            },
            complete: function () {
                $('#loading').hide();
            },
        });
    }

</script>
<?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/layouts/front-end/partials/cart_details.blade.php ENDPATH**/ ?>