<?php $__env->startSection('title',\App\CPU\translate('Shop Page')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <?php if($shop['id'] != 0): ?>
        <meta property="og:image" content="<?php echo e(asset('storage/app/public/shop')); ?>/<?php echo e($shop->image); ?>"/>
        <meta property="og:title" content="<?php echo e($shop->name); ?> "/>
        <meta property="og:url" content="<?php echo e(route('shopView',[$shop['id']])); ?>">
    <?php else: ?>
        <meta property="og:image" content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>"/>
        <meta property="og:title" content="<?php echo e($shop['name']); ?> "/>
        <meta property="og:url" content="<?php echo e(route('shopView',[$shop['id']])); ?>">
    <?php endif; ?>
    <meta property="og:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">

    <?php if($shop['id'] != 0): ?>
        <meta property="twitter:card" content="<?php echo e(asset('storage/app/public/shop')); ?>/<?php echo e($shop->image); ?>"/>
        <meta property="twitter:title" content="<?php echo e(route('shopView',[$shop['id']])); ?>"/>
        <meta property="twitter:url" content="<?php echo e(route('shopView',[$shop['id']])); ?>">
    <?php else: ?>
        <meta property="twitter:card"
              content="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>"/>
        <meta property="twitter:title" content="<?php echo e(route('shopView',[$shop['id']])); ?>"/>
        <meta property="twitter:url" content="<?php echo e(route('shopView',[$shop['id']])); ?>">
    <?php endif; ?>

    <meta property="twitter:description" content="<?php echo substr($web_config['about']->value,0,100); ?>">


    <link href="<?php echo e(asset('public/assets/front-end')); ?>/css/home.css" rel="stylesheet">
    <style>

        .page-item.active .page-link {
            background-color: <?php echo e($web_config['primary_color']); ?>                        !important;
        }

        /*  */
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <?php ($decimal_point_settings = \App\CPU\Helpers::get_business_settings('decimal_point_settings')); ?>
    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-4 __inline-67">
        <div class="row rtl">
            <!-- banner  -->
            <div class="col-lg-12 mt-2">
                <div class="bg-white">
                    <?php if($shop['id'] != 0): ?>
                        <img class="__shop-page-banner"
                             src="<?php echo e(asset('storage/app/public/shop/banner')); ?>/<?php echo e($shop->banner); ?>"
                             onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                             alt="">
                    <?php else: ?>
                        <?php ($banner=\App\CPU\Helpers::get_business_settings('shop_banner')); ?>
                        <img class="__shop-page-banner"
                             src="<?php echo e(asset("storage/app/public/shop")); ?>/<?php echo e($banner??""); ?>"
                             onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                             alt="">
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="col-md-12 mt-2 rtl"
                 style=" text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                <a class="openbtn-tab __text-20px font-semibold" onclick="openNav()">
                    <div style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>"
                         class="for-tab-display"> ☰ <?php echo e(\App\CPU\translate('categories')); ?></div>
                </a>
            </div>
            
            <div class="col-lg-12 rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                <div class="__rounded-10 bg-white"
                     style="<?php echo e(Session::get('direction') === "rtl" ? 'padding-left:5px;' : 'padding-left:5px;'); ?>">
                    <div class="row d-flex justify-content-between seller-details">
                        
                        <div class="d-flex align-items-start p-2">
                            <div class="">

                                <?php if($shop['id'] != 0): ?>
                                    <div class="position-relative">
                                        <?php if($seller_temporary_close || $inhouse_temporary_close): ?>
                                            <span class="temporary-closed-details">
                                                <span><?php echo e(\App\CPU\translate('closed_now')); ?></span>
                                            </span>
                                        <?php elseif(($seller_id==0 && $inhouse_vacation_status && $current_date >= $inhouse_vacation_start_date && $current_date <= $inhouse_vacation_end_date) ||
                                         $seller_id!=0 && $seller_vacation_status && $current_date >= $seller_vacation_start_date && $current_date <= $seller_vacation_end_date): ?>
                                            <span class="temporary-closed-details">
                                                <span><?php echo e(\App\CPU\translate('closed_now')); ?></span>
                                            </span>
                                        <?php endif; ?>
                                        <img class="__inline-68"
                                             src="<?php echo e(asset('storage/app/public/shop')); ?>/<?php echo e($shop->image); ?>"
                                             onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                             alt="">
                                    </div>
                                <?php else: ?>
                                    <div class="position-relative">
                                        <?php if($seller_temporary_close || $inhouse_temporary_close): ?>
                                            <span class="temporary-closed-details">
                                                <span><?php echo e(\App\CPU\translate('closed_now')); ?></span>
                                            </span>
                                        <?php elseif(($seller_id==0 && $inhouse_vacation_status && $current_date >= $inhouse_vacation_start_date && $current_date <= $inhouse_vacation_end_date) ||
                                         $seller_id!=0 && $seller_vacation_status && $current_date >= $seller_vacation_start_date && $current_date <= $seller_vacation_end_date): ?>
                                            <span class="temporary-closed-details">
                                                <span><?php echo e(\App\CPU\translate('closed_now')); ?></span>
                                            </span>
                                        <?php endif; ?>
                                        <img class="__inline-68"
                                             src="<?php echo e(asset('storage/app/public/company')); ?>/<?php echo e($web_config['fav_icon']->value); ?>"
                                             onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                             alt="">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-8">
                                <span class="ml-4 font-weight-bold ">
                                    <?php if($shop['id'] != 0): ?>
                                        <?php echo e($shop->name); ?>

                                    <?php else: ?>
                                        <?php echo e($web_config['name']->value); ?>

                                    <?php endif; ?>
                                </span>
                                <div class="ml-4">
                                    <div>
                                        <?php for($count=0; $count<5; $count++): ?>
                                            <?php if($avg_rating >= $count+1): ?>
                                                <i class="sr-star czi-star-filled active"></i>
                                            <?php else: ?>
                                                <i class="sr-star czi-star active __color-fea569"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        (<span class="ml-1"><?php echo e(round($avg_rating,2)); ?></span>)
                                    </div>
                                    <div class="d-flex __text-12px">
                                        <span><?php echo e($total_review); ?> <?php echo e(\App\CPU\translate('reviews')); ?> </span>

                                        <span class="__inline-69"></span>

                                        <span><?php echo e($total_order); ?> <?php echo e(\App\CPU\translate('orders')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="d-flex align-items-center">
                            <div class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-4' : 'mr-4'); ?>">
                                <?php if($seller_id!=0): ?>
                                    <?php if(auth('customer')->check()): ?>
                                        <div class="d-flex">
                                            <button class="btn btn-block __inline-70" data-toggle="modal"
                                                    data-target="#exampleModal" <?php echo e(($shop->temporary_close || ($shop->vacation_status && date('Y-m-d') >= date('Y-m-d', strtotime($shop->vacation_start_date)) && date('Y-m-d') <= date('Y-m-d', strtotime($shop->vacation_end_date)))) ? 'disabled' : ''); ?>>
                                                <i class="fa fa-envelope" aria-hidden="true"></i>
                                                <?php echo e(\App\CPU\translate('Chat with seller')); ?>

                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <div class="d-flex">
                                            <a href="<?php echo e(route('customer.auth.login')); ?>"
                                               class="btn btn-block __inline-70">
                                                <i class="fa fa-envelope" aria-hidden="true"></i>
                                                <?php echo e(\App\CPU\translate('Chat with seller')); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>


                    </div>
                </div>
                <?php if(isset($shop->temporary_close) && ($shop->temporary_close || ($shop->vacation_status && date('Y-m-d') >= date('Y-m-d', strtotime($shop->vacation_start_date)) && date('Y-m-d') <= date('Y-m-d', strtotime($shop->vacation_end_date))))): ?>
                    <span></span>
                <?php else: ?>
                    
                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                         aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="card-header">
                                    <?php echo e(\App\CPU\translate('write_something')); ?>

                                </div>
                                <div class="modal-body">
                                    <form action="<?php echo e(route('messages_store')); ?>" method="post" id="chat-form">
                                        <?php echo csrf_field(); ?>
                                        <?php if($shop['id'] != 0): ?>
                                            <input value="<?php echo e($shop->id); ?>" name="shop_id" hidden>
                                            <input value="<?php echo e($shop->seller_id); ?>}" name="seller_id" hidden>
                                        <?php endif; ?>

                                        <textarea name="message" class="form-control" required></textarea>
                                        <br>
                                        <?php if($shop['id'] != 0): ?>
                                            <button
                                                class="btn btn--primary text-white"><?php echo e(\App\CPU\translate('send')); ?></button>
                                        <?php else: ?>
                                            <button class="btn btn--primary text-white"
                                                    disabled><?php echo e(\App\CPU\translate('send')); ?></button>
                                        <?php endif; ?>
                                    </form>
                                </div>
                                <div class="card-footer justify-content-between d-flex flex-wrap">
                                    <a href="<?php echo e(route('chat', ['type' => 'seller'])); ?>" class="btn btn--primary">
                                        <?php echo e(\App\CPU\translate('go_to')); ?> <?php echo e(\App\CPU\translate('chatbox')); ?>

                                    </a>
                                    <button type="button" class="btn btn-secondary"
                                            data-dismiss="modal"><?php echo e(\App\CPU\translate('close')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>


        </div>


        <div class="row mt-1 mr-0 rtl">
            
            <div class="col-lg-3 mt-3  mr-0 <?php echo e(Session::get('direction') === "rtl" ? 'pl-4' : 'pr-4'); ?>">
                <aside class=" hidden-xs SearchParameters" id="SearchParameters">
                    <!-- Categories Sidebar-->
                    <div class=" rounded-lg " id="shop-sidebar">
                        <div class="">
                            <!-- Categories-->
                            <div class="widget widget-categories mb-4 ">
                                <div>
                                    <div class="d-inline">
                                        <h3 class="widget-title font-bold __text-18px d-inline"><?php echo e(\App\CPU\translate('categories')); ?></h3>
                                    </div>
                                </div>

                                <div class="accordion mt-2" id="shop-categories">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card __inline-71">


                                            <div class="card-header p-1 flex-between">
                                                <div class="d-flex ">
                                                    <img
                                                        class="__inline-72 <?php echo e(Session::get('direction') === "rtl" ? 'ml-2' : 'mr-2'); ?>"
                                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                        src="<?php echo e(asset('storage/app/public/category')); ?>/<?php echo e($category['icon']); ?>">
                                                    <label class="for-hover-lable cursor-pointer"
                                                           onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$category['id']])); ?>'" >
                                                        <?php echo e($category['name']); ?>

                                                    </label>
                                                </div>
                                                <strong class="pull-right for-brand-hover cursor-pointer"
                                                        onclick="$('#collapse-<?php echo e($category['id']); ?>').toggle(400);if($(this).hasClass('active')){
                                                $(this).removeClass('active');
                                                $(this).text('+')
                                            }else {$(this).addClass('active');
                                                $(this).text('-')}">
                                                    <?php echo e($category->childes->count()>0?'+':''); ?>

                                                </strong>
                                            </div>
                                            <div
                                                class="card-body <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                                id="collapse-<?php echo e($category['id']); ?>"
                                                style="display: none">
                                                <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class=" for-hover-lable card-header p-1 flex-between">
                                                        <label class="cursor-pointer"
                                                               onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$child['id']])); ?>'">
                                                            <?php echo e($child['name']); ?>

                                                        </label>
                                                        <strong class="pull-right cursor-pointer"
                                                                onclick="$('#collapse-<?php echo e($child['id']); ?>').toggle(400);if($(this).hasClass('active')){
                                                $(this).removeClass('active');
                                                $(this).text('+')
                                            }else {$(this).addClass('active');
                                                $(this).text('-')}">
                                                            <?php echo e($child->childes->count()>0?'+':''); ?>

                                                        </strong>
                                                    </div>
                                                    <div
                                                        class="card-body <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                                        id="collapse-<?php echo e($child['id']); ?>"
                                                        style="display: none">
                                                        <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="card-header p-1 flex-between">
                                                                <label class="for-hover-lable cursor-pointer"
                                                                       onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$ch['id']])); ?>'">
                                                                    <?php echo e($ch['name']); ?>

                                                                </label>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
            
            <div id="mySidepanel" class="sidepanel"
                 style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right:0; left:auto' : 'right:auto; left:0'); ?>;">
                <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">×</a>
                <div class="cz-sidebar-body">
                    <div class="widget widget-categories mb-4 pb-4 border-bottom">
                        <div>
                            <div class="d-inline">
                                <h3 class="widget-title font-700 d-inline"><?php echo e(\App\CPU\translate('categories')); ?></h3>
                            </div>
                        </div>
                        <div class="divider-role __inline-73"></div>
                        <div class="accordion mt-n1" id="shop-categories"
                             style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card">
                                    <div class="card-header p-1 flex-between">
                                        <label class="for-hover-lable cursor-pointer"
                                               onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$category['id']])); ?>'" >
                                            <?php echo e($category['name']); ?>

                                        </label>
                                        <strong class="pull-right for-brand-hover cursor-pointer"
                                                onclick="$('#collapse-m-<?php echo e($category['id']); ?>').toggle(400)">
                                            <?php echo e($category->childes->count()>0?'+':''); ?>

                                        </strong>
                                    </div>
                                    <div class="card-body <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                         id="collapse-m-<?php echo e($category['id']); ?>"
                                         style="display: none">
                                        <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class=" for-hover-lable card-header p-1 flex-between">
                                                <label class="cursor-pointer"
                                                       onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$child['id']])); ?>'">
                                                    <?php echo e($child['name']); ?>

                                                </label>
                                                <strong class="pull-right cursor-pointer"
                                                        onclick="$('#collapse-m-<?php echo e($child['id']); ?>').toggle(400)">
                                                    <?php echo e($child->childes->count()>0?'+':''); ?>

                                                </strong>
                                            </div>
                                            <div
                                                class="card-body <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : 'ml-2'); ?>"
                                                id="collapse-m-<?php echo e($child['id']); ?>"
                                                style="display: none">
                                                <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="card-header p-1 flex-between">
                                                        <label class="for-hover-lable cursor-pointer"
                                                               onclick="location.href='<?php echo e(route('shopView',['id'=> $seller_id,'category_id'=>$ch['id']])); ?>'">
                                                            <?php echo e($ch['name']); ?>

                                                        </label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-9 product-div">
                <div class="row d-flex justify-content-end">
                    <div class="col-lg-4 col-md-6 col-sm-12 col-12 pt-2 __dir-ltr">
                        <form class=" md-form form-sm mt-0" method="get"
                              action="<?php echo e(route('shopView',['id'=>$seller_id])); ?>">
                            <div class="input-group input-group-sm mb-3">
                                <input type="text" class="form-control" name="product_name"
                                       style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                       placeholder="<?php echo e(\App\CPU\translate('Search products from this store')); ?>"
                                       aria-label="Recipient's username"
                                       aria-describedby="basic-addon2">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text __bg-F3F5F9" id="basic-addon2">
                                        <i class="fa fa-search" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- Products grid-->
                <div class="row" id="ajax-products">
                    <?php echo $__env->make('web-views.products._ajax-products',['products'=>$products,'decimal_point_settings'=>$decimal_point_settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        function productSearch(seller_id, category_id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });

            $.ajax({
                type: "post",
                url: '<?php echo e(url('/')); ?>/shopView/' + seller_id + '?category_id=' + category_id,

                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (response) {
                    $('#ajax-products').html(response.view);
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        }
    </script>

    <script>
        function openNav() {

            document.getElementById("mySidepanel").style.width = "50%";
        }

        function closeNav() {
            document.getElementById("mySidepanel").style.width = "0";
        }
    </script>

    <script>
        $('#chat-form').on('submit', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });

            $.ajax({
                type: "post",
                url: '<?php echo e(route('messages_store')); ?>',
                data: $('#chat-form').serialize(),
                success: function (respons) {

                    toastr.success('<?php echo e(\App\CPU\translate('send successfully')); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                    $('#chat-form').trigger('reset');
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/shop-page.blade.php ENDPATH**/ ?>