<?php $__env->startSection('title',\App\CPU\translate('Update delivery-man')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/deliveryman.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('update_deliveryman')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <form action="<?php echo e(route('seller.delivery-man.update',[$delivery_man['id']])); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card mb-3">
                <div class="card-body">
                    <h5 class="mb-0 page-header-title d-flex align-items-center gap-2 border-bottom pb-3 mb-3">
                        <i class="tio-user"></i>
                        <?php echo e(\App\CPU\translate('General_Information')); ?>

                    </h5>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('first')); ?> <?php echo e(\App\CPU\translate('name')); ?></label>
                                <input type="text" value="<?php echo e($delivery_man['f_name']); ?>" name="f_name"
                                        class="form-control" placeholder="<?php echo e(\App\CPU\translate('New delivery-man')); ?>"
                                        required>
                            </div>

                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('last')); ?> <?php echo e(\App\CPU\translate('name')); ?></label>
                                <input type="text" value="<?php echo e($delivery_man['l_name']); ?>" name="l_name"
                                        class="form-control" placeholder="<?php echo e(\App\CPU\translate('Last Name')); ?>"
                                        required>
                            </div>

                            <div class="form-group">
                                <label class="title-color d-flex" for="exampleFormControlInput1"><?php echo e(\App\CPU\translate('phone')); ?></label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <select class=" form-control js-example-basic-multiple js-states js-example-responsive"
                                                name="country_code" id="colors-selector" required>
                                            <?php $__currentLoopData = $telephone_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($code['code']); ?>" <?php echo e($delivery_man['country_code'] == $code['code'] ? 'selected' : ''); ?>>
                                                    <?php echo e($code['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <input type="text" name="phone" value="<?php echo e($delivery_man['phone']); ?>" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex : 017********')); ?>"
                                           required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('identity')); ?> <?php echo e(\App\CPU\translate('type')); ?></label>
                                <select name="identity_type" class="form-control">
                                    <option
                                        value="passport" <?php echo e($delivery_man['identity_type']=='passport'?'selected':''); ?>>
                                        <?php echo e(\App\CPU\translate('passport')); ?>

                                    </option>
                                    <option
                                        value="driving_license" <?php echo e($delivery_man['identity_type']=='driving_license'?'selected':''); ?>>
                                        <?php echo e(\App\CPU\translate('driving')); ?> <?php echo e(\App\CPU\translate('license')); ?>

                                    </option>
                                    <option value="nid" <?php echo e($delivery_man['identity_type']=='nid'?'selected':''); ?>><?php echo e(\App\CPU\translate('nid')); ?>

                                    </option>
                                    <option
                                        value="company_id" <?php echo e($delivery_man['identity_type']=='company_id'?'selected':''); ?>>
                                        <?php echo e(\App\CPU\translate('company')); ?> <?php echo e(\App\CPU\translate('id')); ?>

                                    </option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('identity')); ?> <?php echo e(\App\CPU\translate('number')); ?></label>
                                <input type="text" name="identity_number" value="<?php echo e($delivery_man['identity_number']); ?>"
                                        class="form-control"
                                        placeholder="<?php echo e(\App\CPU\translate('Ex : DH-23434-LS')); ?>"
                                        required>
                            </div>

                            <div class="form-group">
                                <label class="title-color d-flex"><?php echo e(\App\CPU\translate('address')); ?></label>
                                <textarea name="address" class="form-control" id="address" rows="1" placeholder="Address"><?php echo e($delivery_man['address']); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <div class="d-flex mb-2 gap-2 align-items-center">
                                    <label
                                        class="title-color mb-0"><?php echo e(\App\CPU\translate('deliveryman')); ?> <?php echo e(\App\CPU\translate('image')); ?></label>
                                    <span class="text-info">* ( <?php echo e(\App\CPU\translate('ratio')); ?> 1:1 )</span>
                                </div>
                                <div class="form-group">
                                    <div class="custom-file">
                                        <input type="file" name="image" id="customFileEg1"
                                               class="custom-file-input"
                                               accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                        <label class="custom-file-label"
                                               for="customFileEg1"><?php echo e(\App\CPU\translate('choose')); ?> <?php echo e(\App\CPU\translate('file')); ?></label>
                                    </div>
                                </div>
                                <center>
                                    <img class="upload-img-view" id="viewer"
                                         src="<?php echo e(asset('storage/app/public/delivery-man').'/'.$delivery_man['image']); ?>"
                                         alt="delivery-man image"/>
                                </center>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('identity')); ?> <?php echo e(\App\CPU\translate('image')); ?></label>

                                <div>
                                    <div class="row" id="coba">
                                        <?php $__currentLoopData = json_decode($delivery_man['identity_image'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-4 mb-3">
                                                <img height="150"
                                                     src="<?php echo e(asset('storage/app/public/delivery-man').'/'.$img); ?>">
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('email')); ?></label>
                                <input type="email" value="<?php echo e($delivery_man['email']); ?>" name="email" class="form-control"
                                        placeholder="<?php echo e(\App\CPU\translate('Ex : ex@example.com')); ?>"
                                        required>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('password')); ?></label>
                                <input type="text" name="password" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex : password')); ?>">
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label class="title-color"><?php echo e(\App\CPU\translate('confirm_password')); ?></label>
                                <input type="text" name="confirm_password" class="form-control" placeholder="<?php echo e(\App\CPU\translate('Ex : password')); ?>">
                            </div>
                        </div>
                    </div>
                    <span class="d-none" id="placeholderImg" data-img="<?php echo e(asset('public/assets/back-end/img/400x400/img3.png')); ?>"></span>

                    <div class="d-flex gap-3 justify-content-end">
                        <button type="reset" id="reset" class="btn btn-secondary"><?php echo e(\App\CPU\translate('reset')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('submit')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        $(".js-example-responsive").select2({
            width: 'resolve'
        });
    </script>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this);
        });
    </script>

    <script src="<?php echo e(asset('public/assets/back-end/js/spartan-multi-image-picker.js')); ?>"></script>
    <script type="text/javascript">
        $(function () {
            $("#coba").spartanMultiImagePicker({
                fieldName: 'identity_image[]',
                maxCount: 5,
                rowHeight: 'auto',
                groupClassName: 'col-6 col-md-4',
                maxFileSize: '',
                placeholderImage: {
                    image: '<?php echo e(asset('public/assets/back-end/img/400x400/img2.jpg')); ?>',
                    width: '100%'
                },
                dropFileLabel: "Drop Here",
                onAddRow: function (index, file) {

                },
                onRenderedPreview: function (index) {

                },
                onRemoveRow: function (index) {

                },
                onExtensionErr: function (index, file) {
                    toastr.error('Please only input png or jpg type file', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function (index, file) {
                    toastr.error('File size too big', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/delivery-man/edit.blade.php ENDPATH**/ ?>