<?php $__env->startSection('title',\App\CPU\translate('Refund request')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container rtl" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
    <div class="row">
        <div class="col-md-3"></div>
        <div class="col-md-9 sidebar_heading">
            <h1 class="h3  mb-0 float-<?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?> headerTitle">
                <?php echo e(\App\CPU\translate('refund_request')); ?>

            </h1>
        </div>
    </div>
</div>

<!-- Page Content-->
<div class="container pb-5 mb-2 mb-md-4 mt-3 rtl"
     style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
    <div class="row">
        <!-- Sidebar-->
    <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content  -->
    <?php ($product = App\Model\Product::find($order_details->product_id)); ?>
    <?php ($order = App\Model\Order::find($order_details->order_id)); ?>
        <section class="col-lg-9 mt-2 col-md-9">
            <div class="card box-shadow-sm">
                <div class="overflow-auto">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-3 col-sm-2">
                                    <img class="d-block"
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($product['thumbnail']); ?>"
                                        alt="VR Collection" width="60">
                                </div>
                                <div class="col-9 col-sm-7 text-left">
                                    <p><?php echo e($product['name']); ?></p>
                                    <span><?php echo e(\App\CPU\translate('variant')); ?> : </span>
                                                <?php echo e($order_details->variant); ?>

                                </div>
                                <div class="col-4 col-sm-3 text-left d-flex flex-column pl-0 mt-2 mt-sm-0 pl-sm-5">
                                    <span ><?php echo e(\App\CPU\translate('QTY')); ?> : <?php echo e($order_details->qty); ?></span>
                                    <span><?php echo e(\App\CPU\translate('price')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($order_details->price)); ?></span>
                                    <span><?php echo e(\App\CPU\translate('discount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($order_details->discount)); ?></span>
                                    <span><?php echo e(\App\CPU\translate('tax')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($order_details->tax)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $total_product_price = 0;
                    foreach ($order->details as $key => $or_d) {
                        $total_product_price += ($or_d->qty*$or_d->price) + $or_d->tax - $or_d->discount; 
                    }
                        $refund_amount = 0;
                        $subtotal = ($order_details->price * $order_details->qty) - $order_details->discount + $order_details->tax;
                        
                        $coupon_discount = ($order->discount_amount*$subtotal)/$total_product_price;

                        $refund_amount = $subtotal - $coupon_discount;
                    ?>

                    <div class="card mt-2">
                        <div class="card-body">
                            <div class="row text-center">
                                <span class="col-sm-2"><?php echo e(\App\CPU\translate('subtotal')); ?>: <?php echo e(\App\CPU\Helpers::currency_converter($subtotal)); ?></span>
                                <span class="col-sm-5"><?php echo e(\App\CPU\translate('coupon_discount')); ?>: <?php echo e(\App\CPU\Helpers::currency_converter($coupon_discount)); ?></span>
                                <span class="col-sm-5"><?php echo e(\App\CPU\translate('total_refundable_amount')); ?>:<?php echo e(\App\CPU\Helpers::currency_converter($refund_amount)); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="card mt-2">
                        <div class="card-body">
                            <div class="row">
                                <form action="<?php echo e(route('refund-store')); ?>"  method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?> 
                                    <input type="hidden" name="order_details_id" value="<?php echo e($order_details->id); ?>">
                                    <input type="hidden" name="amount" value="<?php echo e($refund_amount); ?>">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="input-label" for="name"><?php echo e(\App\CPU\translate('refund_reason')); ?></label>
                                            <textarea class="form-control" name="refund_reason" cols="120" 
                                                   required><?php echo e(old('details')); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="exampleInputEmail1"><?php echo e(\App\CPU\translate('attachment')); ?></label>
                                            <div class="row coba"></div>
                                        </div>
    
                                    </div>
                                    <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('submit')); ?></button>
                                    
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('public/assets/front-end/js/spartan-multi-image-picker.js')); ?>"></script>
    <script type="text/javascript">
        $(function () {
            $(".coba").spartanMultiImagePicker({
                fieldName: 'images[]',
                maxCount: 5,
                rowHeight: '150px',
                groupClassName: 'col-md-4',
                maxFileSize: '',
                placeholderImage: {
                    image: '<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>',
                    width: '100%'
                },
                dropFileLabel: "<?php echo e(\App\CPU\translate('drop_here')); ?>",
                onAddRow: function (index, file) {

                },
                onRenderedPreview: function (index) {

                },
                onRemoveRow: function (index) {

                },
                onExtensionErr: function (index, file) {
                    toastr.error('<?php echo e(\App\CPU\translate('input_png_or_jpg')); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                },
                onSizeErr: function (index, file) {
                    toastr.error('<?php echo e(\App\CPU\translate('file_size_too_big')); ?>', {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/refund-request.blade.php ENDPATH**/ ?>