<?php $__env->startSection('title', \App\CPU\translate('refund_list')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="">
        <div class="d-flex flex-wrap justify-content-between align-items-center gap-3 mb-3">
            <!-- Page Title -->
            <div class="">
                <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                    <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/refund-request-list.png')); ?>" alt="">
                    <?php echo e(\App\CPU\translate('refund_request_list')); ?>

                    <span class="badge badge-soft-dark radius-50"><?php echo e($refund_list->total()); ?></span>
                </h2>
            </div>
            <!-- End Page Title -->

            <div>
                <i class="tio-shopping-cart title-color fz-30"></i>
            </div>
        </div>
        <!-- End Row -->
    </div>
    <!-- End Page Header -->

    <!-- Card -->
    <div class="card">
        <!-- Header -->
        <div class="card-header">
            <div class="flex-between justify-content-between align-items-center flex-grow-1">
                <div class="col-12 col-md-4">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <!-- Search -->
                        <div class="input-group input-group-merge input-group-custom">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="tio-search"></i>
                                </div>
                            </div>
                            <input id="datatableSearch_" type="search" name="search" class="form-control"
                                   placeholder="<?php echo e(\App\CPU\translate('Search_by_order_id_or_refund_id')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>"
                                   required>
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                        </div>
                        <!-- End Search -->
                    </form>
                </div>
            </div>
            <!-- End Row -->
        </div>
        <!-- End Header -->

        <!-- Table -->
        <div class="table-responsive datatable-custom">
            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                   style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>">
                <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th class="">
                            <?php echo e(\App\CPU\translate('SL')); ?>

                        </th>
                        <th><?php echo e(\App\CPU\translate('order_ID')); ?> </th>
                        <th><?php echo e(\App\CPU\translate('product_Info')); ?></th>
                        <th><?php echo e(\App\CPU\translate('customer_Info')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Total_Amount')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Order_Status')); ?></th>
                        <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                    </tr>
                </thead>

                <tbody>
                <?php $__currentLoopData = $refund_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php echo e($refund_list->firstItem()+$key); ?>

                        </td>
                        <td>
                            <a class="title-color hover-c1" href="<?php echo e(route('seller.orders.details',[$refund->order_id])); ?>">
                                <?php echo e($refund->order_id); ?>

                            </a>
                        </td>
                        <td>
                            <?php if($refund->product!=null): ?>
                                <div class="d-flex flex-wrap gap-2">
                                    <a href="<?php echo e(route('seller.product.view',[$refund->product->id])); ?>">
                                        <img onerror="this.src='<?php echo e(asset('/public/assets/back-end/img/brand-logo.png')); ?>'"
                                             src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($refund->product->thumbnail); ?>"
                                             class="avatar border" alt="">
                                    </a>
                                    <div class="d-flex flex-column gap-1">
                                        <a href="<?php echo e(route('seller.product.view',[$refund->product->id])); ?>" class="title-color font-weight-bold hover-c1">
                                            <?php echo e(\Illuminate\Support\Str::limit($refund->product->name,35)); ?>

                                        </a>
                                        <span class="fz-12"><?php echo e(\App\CPU\translate('qty')); ?> : <?php echo e($refund->order_details->qty); ?></span>
                                    </div>
                                </div>
                            <?php else: ?>
                                <?php echo e(\App\CPU\translate('product_name_not_found')); ?>

                            <?php endif; ?>

                        </td>
                        <td>
                            <?php if($refund->customer !=null): ?>
                                <div class="d-flex flex-column gap-1">
                                    <a href="javascript:void(0)" class="title-color font-weight-bold hover-c1">
                                        <?php echo e($refund->customer->f_name. ' '.$refund->customer->l_name); ?>

                                    </a>
                                    <a href="tel:<?php echo e($refund->customer->phone); ?>" class="title-color hover-c1 fz-12"><?php echo e($refund->customer->phone); ?></a>
                                </div>
                            <?php else: ?>
                                <a href="#" class="title-color hover-c1">
                                    <?php echo e(\App\CPU\translate('customer_not_found')); ?>

                                </a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e(\App\CPU\Helpers::currency_converter($refund->amount)); ?>

                        </td>
                        <td>
                            <?php echo e(\App\CPU\translate($refund->status)); ?>

                        </td>
                        <td>
                            <div class="d-flex justify-content-center gap-2">
                                <a  class="btn btn--primary btn-sm square-btn"
                                    title="<?php echo e(\App\CPU\translate('view')); ?>"
                                    href="<?php echo e(route('seller.refund.details',['id'=>$refund['id']])); ?>">
                                    <i class="tio-invisible"></i>
                                </a>
                            </div>
                        </td>
                    </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- End Table -->

        <div class="table-responsive mt-4">
            <div class="px-4 d-flex justify-content-lg-end">
                <!-- Pagination -->
                <?php echo $refund_list->links(); ?>

            </div>
        </div>

        <?php if(count($refund_list)==0): ?>
            <div class="text-center p-4">
                <img class="mb-3 __w-7rem" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
            </div>
        <?php endif; ?>
        <!-- End Footer -->
    </div>
    <!-- End Card -->
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/refund/list.blade.php ENDPATH**/ ?>