<?php $__env->startSection('title', \App\CPU\translate('Bank Info View')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/my-bank-info.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('my_bank_info')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="row mt-3">
            <div class="col-md-12">
                <div class="card" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                    <!-- Card Header -->
                    <div class="border-bottom d-flex gap-3 flex-wrap justify-content-between align-items-center px-4 py-3">
                        <div class="d-flex gap-2 align-items-center">
                            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/bank.png')); ?>" alt="" />
                            <h3 class="mb-0"><?php echo e(\App\CPU\translate('Bank Information')); ?></h3>
                        </div>

                        <div class="d-flex gap-2 align-items-center">
                            <a href="<?php echo e(route('seller.profile.bankInfo',[$data->id])); ?>" class="btn btn--primary">
                                <?php echo e(\App\CPU\translate('Edit')); ?>

                            </a>
                        </div>
                    </div>
                    <!-- End Card Header -->

                    <!-- Card Body -->
                    <div class="card-body p-30">
                        <div class="row justify-content-center">
                            <div class="col-sm-6 col-md-8 col-lg-6 col-xl-5">
                                <!-- Bank Info Card -->
                                <div class="card bank-info-card bg-bottom bg-contain bg-img" style="background-image: url(<?php echo e(asset('/public/assets/back-end/img/bank-info-card-bg.png')); ?>);">
                                    <div class="border-bottom p-3">
                                        <h4 class="mb-0 fw-semibold"><?php echo e(\App\CPU\translate('Holder_Name')); ?> : <strong><?php echo e($data->holder_name ?? 'No Data found'); ?></strong></h4>
                                    </div>

                                    <div class="card-body position-relative">
                                        <img class="bank-card-img" width="78" src="<?php echo e(asset('/public/assets/back-end/img/bank-card.png')); ?>" alt="">

                                        <ul class="list-unstyled d-flex flex-column gap-4">
                                            <li>
                                                <h3 class="mb-2"><?php echo e(\App\CPU\translate('Bank_Name')); ?> :</h3>
                                                <div><?php echo e($data->bank_name ?? 'No Data found'); ?></div>
                                            </li>
                                            <li>
                                                <h3 class="mb-2"><?php echo e(\App\CPU\translate('Branch_Name')); ?> :</h3>
                                                <div><?php echo e($data->branch ?? 'No Data found'); ?></div>
                                            </li>
                                            <li>
                                                <h3 class="mb-2"><?php echo e(\App\CPU\translate('Account_Number')); ?> : </h3>
                                                <div><?php echo e($data->account_no ?? 'No Data found'); ?></div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- End Bank Info Card -->
                            </div>
                        </div>
                    </div>
                    <!-- End Card Body -->
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/profile/view.blade.php ENDPATH**/ ?>