<?php $__env->startSection('title', \App\CPU\translate('Update Notification')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/push_notification.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('push_notification_update')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- End Page Header -->
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.notification.update',[$notification['id']])); ?>" method="post"
                        style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                        enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(\App\CPU\translate('Title')); ?></label>
                                <input type="text" value="<?php echo e($notification['title']); ?>" name="title" class="form-control"
                                        placeholder="<?php echo e(\App\CPU\translate('New notification')); ?>" required>
                            </div>
                            <div class="physical_product_show">
                                        <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Product')); ?> 
                                        </label>
                                        <select class="js-example-basic-multiple form-control select2" name="product_id">
                                            <option value="" selected disabled>--Select Product--</option>
                                            <?php $__currentLoopData = \App\CPU\ProductManager::products(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($x['id'] . ':::' . $x['slug']); ?>"  <?php echo e($x->id == $notification['product_id'] ? "selected"  : ""); ?>>
                                                    <?php echo e($x['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                            <div class="form-group mb-0">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(\App\CPU\translate('Description')); ?></label>
                                <textarea name="description" class="form-control"
                                            required><?php echo e($notification['description']); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <center>
                                <img class="upload-img-view mt-4" 
                                    id="viewer"
                                    onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img2.jpg')); ?>'"
                                    src="<?php echo e(asset('storage/app/public/notification')); ?>/<?php echo e($notification['image']); ?>"
                                        alt="image"/>
                            </center>
                            <label class="title-color"><?php echo e(\App\CPU\translate('Image')); ?></label>
                            <span class="text-info"> ( <?php echo e(\App\CPU\translate('Ratio_1:1')); ?>  )</span>
                            <div class="custom-file">
                                <input type="file" name="image" id="customFileEg1" class="custom-file-input"
                                        accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                <label class="custom-file-label" for="customFileEg1"><?php echo e(\App\CPU\translate('Choose file')); ?></label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="d-flex justify-content-end gap-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(\App\CPU\translate('reset')); ?></button>
                                <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Update')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- End Table -->
    </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this);
        });
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/notification/edit.blade.php ENDPATH**/ ?>