<?php $__env->startSection('title', \App\CPU\translate('Support Ticket')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/support_ticket.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('support_ticket')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="card">
            <div class="card-header flex-wrap gap-3">
            <?php $__currentLoopData = $supportTicket; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $userDetails = \App\User::where('id', $ticket['customer_id'])->first();
                $conversations = \App\Model\SupportTicketConv::where('support_ticket_id', $ticket['id'])->get();
                $admin = \App\Model\Admin::get();
                ?>
                <div class="media d-flex gap-3">
                    <img class="rounded-circle avatar" src="<?php echo e(asset('storage/app/public/profile')); ?>/<?php echo e(isset($userDetails)?$userDetails['image']:''); ?>"
                            onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img1.jpg')); ?>"
                            alt="<?php echo e(isset($userDetails)?$userDetails['name']:'not found'); ?>"/>
                    <div class="media-body">
                        <h6 class="font-size-md mb-1"><?php echo e(isset($userDetails)?$userDetails['f_name'].' '.$userDetails['l_name']:'not found'); ?></h6>
                        <div class="fz-12"><?php echo e(isset($userDetails)?$userDetails['phone']:''); ?></div>
                    </div>
                </div>
                <div class="d-flex align-items-center flex-wrap gap-3">
                    <div class="type font-weight-bold bg-soft--primary c1 px-2 rounded"><?php echo e(\App\CPU\translate(str_replace('_',' ',$ticket['type']))); ?></div>
                    <div class="priority d-flex flex-wrap align-items-center gap-3">
                        <span class="title-color"><?php echo e(\App\CPU\translate('Priority')); ?>:</span>
                        <span class="font-weight-bold badge-soft-info rounded px-2"><?php echo e(\App\CPU\translate(str_replace('_',' ',$ticket['priority']))); ?></span>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <p class="font-size-md message-box message-box_incoming mb-1"><?php echo e($ticket['description']); ?></p>
                    <span class="fz-12 text-muted d-flex"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$ticket['created_at'])->format('Y-m-d h:i A')); ?></span>
                </div>
                <?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($conversation['admin_message'] ==null ): ?>
                        <div class="mb-4">
                            <p class="font-size-md message-box message-box_incoming mb-1"><?php echo e($conversation['customer_message']); ?></p>
                            <span class="fz-12 text-muted d-flex"><?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['created_at'])->format('Y-m-d h:i A')); ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if($conversation['customer_message'] ==null ): ?>
                        <div class="mb-4 d-flex flex-column align-items-end">
                            <div>
                                <p class="font-size-md message-box mb-1"><?php echo e($conversation['admin_message']); ?></p>
                                <span class="fz-12 text-muted d-flex"> <?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$conversation['updated_at'])->format('Y-m-d h:i A')); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- Leave message-->
                <h5 class="pt-4 pb-1 d-flex"><?php echo e(\App\CPU\translate('Leave_a_Message')); ?></h5>
                <?php $__currentLoopData = $supportTicket; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <form class="needs-validation" href="<?php echo e(route('admin.support-ticket.replay',$reply['id'])); ?>" method="post"
                        >
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($reply['id']); ?>">
                        <input type="hidden" name="adminId" value="1">
                        <div class="form-group">
                        <textarea class="form-control" name="replay" rows="8" placeholder="<?php echo e(\App\CPU\translate('Write_your_message_here')); ?>..."
                                required></textarea>
                            <div class="invalid-tooltip"><?php echo e(\App\CPU\translate('Please write the message')); ?>!</div>
                        </div>
                        <div class="d-flex flex-wrap justify-content-between align-items-center">
                            <div class="custom-control custom-checkbox d-block">
                            </div>
                            <button class="btn btn--primary px-4" type="submit"><?php echo e(\App\CPU\translate('Reply')); ?></button>
                        </div>
                    </form>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/demo/datatables-demo.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end/js/croppie.js')); ?>"></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/support-ticket/singleView.blade.php ENDPATH**/ ?>