<?php $__env->startSection('title', \App\CPU\translate('Shop Edit')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
     <!-- Custom styles for this page -->
     <link href="<?php echo e(asset('public/assets/back-end/css/croppie.css')); ?>" rel="stylesheet">
     <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Row -->
    <div class="content container-fluid">

    <!-- Page Title -->
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/shop-info.png')); ?>" alt="">
            <?php echo e(\App\CPU\translate('Edit_Shop_Info')); ?>

        </h2>
    </div>
    <!-- End Page Title -->

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 "><?php echo e(\App\CPU\translate('Edit_Shop_Info')); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('seller.shop.update',[$shop->id])); ?>" method="post"
                          style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                          enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Shop Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" name="name" value="<?php echo e($shop->name); ?>" class="form-control" id="name"
                                            required>
                                </div>
                                <div class="form-group">
                                    <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Contact')); ?> <span class="text-info">( * <?php echo e(\App\CPU\translate('country_code_is_must')); ?> <?php echo e(\App\CPU\translate('like_for_BD_880')); ?> )</span></label>
                                    <input type="number" name="contact" value="<?php echo e($shop->contact); ?>" class="form-control" id="name"
                                            required>
                                </div>
                                <div class="form-group">
                                    <label for="address" class="title-color"><?php echo e(\App\CPU\translate('Address')); ?> <span class="text-danger">*</span></label>
                                    <textarea type="text" rows="4" name="address" value="" class="form-control" id="address"
                                            required><?php echo e($shop->address); ?></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Upload')); ?> <?php echo e(\App\CPU\translate('image')); ?></label>
                                    <div class="custom-file text-left">
                                        <input type="file" name="image" id="customFileUpload" class="custom-file-input"
                                            accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                        <label class="custom-file-label" for="customFileUpload"><?php echo e(\App\CPU\translate('choose')); ?> <?php echo e(\App\CPU\translate('file')); ?></label>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <img class="upload-img-view" id="viewer"
                                    onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                    src="<?php echo e(asset('storage/app/public/shop/'.$shop->image)); ?>" alt="Product thumbnail"/>
                                </div>
                            </div>
                            <div class="col-md-6 mb-4 mt-2">
                                <div class="form-group">
                                    <div class="flex-start">
                                        <label for="name" class="title-color"><?php echo e(\App\CPU\translate('Upload')); ?> <?php echo e(\App\CPU\translate('Banner')); ?> </label>
                                        <div class="mx-1" for="ratio">
                                            <span class="text-info"><?php echo e(\App\CPU\translate('Ratio')); ?> : ( 6:1 )</span>
                                        </div>
                                    </div>
                                    <div class="custom-file text-left">
                                        <input type="file" name="banner" id="BannerUpload" class="custom-file-input"
                                               accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                        <label class="custom-file-label" for="BannerUpload"><?php echo e(\App\CPU\translate('choose')); ?> <?php echo e(\App\CPU\translate('file')); ?></label>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <center>
                                        <img class="upload-img-view upload-img-view__banner" id="viewerBanner"
                                             onerror="this.src='<?php echo e(asset('public/assets/back-end/img/400x400/img2.jpg')); ?>'"
                                             src="<?php echo e(asset('storage/app/public/shop/banner/'.$shop->banner)); ?>"alt="banner image"/>
                                    </center>
                                </div>
                            </div>

                            <?php if(theme_root_path() == "theme_aster"): ?>
                            <div class="col-md-6 mb-4 mt-2">
                                <div class="form-group">
                                    <div class="flex-start">
                                        <label for="name" class="title-color"><?php echo e(translate('Upload')); ?> <?php echo e(translate('Secondary')); ?> <?php echo e(translate('Banner')); ?> </label>
                                        <div class="mx-1" for="ratio">
                                            <span class="text-info"><?php echo e(translate('Ratio')); ?> : ( 6:1 )</span>
                                        </div>
                                    </div>
                                    <div class="custom-file text-left">
                                        <input type="file" name="bottom_banner" id="BottomBannerUpload" class="custom-file-input"
                                               accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*">
                                        <label class="custom-file-label" for="BottomBannerUpload"><?php echo e(translate('choose')); ?> <?php echo e(translate('file')); ?></label>
                                    </div>
                                </div>
                                <div class="text-center">
                                    <center>
                                        <img class="upload-img-view upload-img-view__banner" id="viewerBottomBanner"
                                             onerror="this.src='<?php echo e(asset('public/assets/back-end/img/400x400/img2.jpg')); ?>'"
                                             src="<?php echo e(asset('storage/app/public/shop/banner/'.$shop->bottom_banner)); ?>"alt="banner image"/>
                                    </center>
                                </div>
                            </div>
                            <?php endif; ?>

                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a class="btn btn-danger" href="<?php echo e(route('seller.shop.view')); ?>"><?php echo e(\App\CPU\translate('Cancel')); ?></a>
                            <button type="submit" class="btn btn--primary" id="btn_update"><?php echo e(\App\CPU\translate('Update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

   <script>
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        function readBannerURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewerBanner').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        function readBottomBannerURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewerBottomBanner').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileUpload").change(function () {
            readURL(this);
        });

        $("#BannerUpload").change(function () {
            readBannerURL(this);
        });
        $("#BottomBannerUpload").change(function () {
            readBottomBannerURL(this);
        });
   </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/shop/edit.blade.php ENDPATH**/ ?>