<?php $__env->startSection('title', \App\CPU\translate('Product Preview')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <!-- Page Header -->
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-10 mb-3">
            <!-- Page Title -->
            <div class="">
                <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                    <img src="<?php echo e(asset('/public/assets/back-end/img/inhouse-product-list.png')); ?>" alt="">
                    <?php echo e($product['name']); ?>

                </h2>
            </div>
            <!-- End Page Title -->

            <div class="d-flex justify-content-end flex-wrap gap-10">
                <a href="<?php echo e(url()->previous()); ?>" class="btn btn--primary">
                    <i class="tio-back-ui"></i> <?php echo e(\App\CPU\translate('Back')); ?>

                </a>
                <a href="<?php echo e(route('product',$product['slug'])); ?>" class="btn btn--primary " target="_blank"><i
                        class="tio-globe"></i> <?php echo e(\App\CPU\translate('View')); ?> <?php echo e(\App\CPU\translate('from')); ?> <?php echo e(\App\CPU\translate('Website')); ?>

                </a>
            </div>
        </div>

        <?php if($product['added_by'] == 'seller' && ($product['request_status'] == 0 || $product['request_status'] == 1)): ?>
        <div class="d-flex justify-content-sm-end flex-wrap gap-2 mb-3">
            <div>
                <?php if($product['request_status'] == 0): ?>
                    <a href="<?php echo e(route('admin.product.approve-status', ['id'=>$product['id']])); ?>"
                        class="btn btn--primary">
                        <?php echo e(\App\CPU\translate('Approve')); ?>

                    </a>
                <?php endif; ?>
            </div>
            <div>
                <button class="btn btn-warning" data-toggle="modal" data-target="#publishNoteModal">
                    <?php echo e(\App\CPU\translate('deny')); ?>

                </button>
                <!-- Modal -->
                <div class="modal fade" id="publishNoteModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title"
                                    id="exampleModalLabel"><?php echo e(\App\CPU\translate('denied_note')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form class="form-group"
                                    action="<?php echo e(route('admin.product.deny', ['id'=>$product['id']])); ?>"
                                    method="post">
                                <div class="modal-body">
                                    <textarea class="form-control" name="denied_note" rows="3"></textarea>
                                    <input type="hidden" name="_token" id="csrf-token"
                                            value="<?php echo e(csrf_token()); ?>"/>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(\App\CPU\translate('Close')); ?>

                                    </button>
                                    <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('Save changes')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php elseif($product['request_status'] == 2): ?>
        <!-- Card -->
        <div class="card mb-3 mb-lg-5 mt-2 mt-lg-3 bg-warning">
            <!-- Body -->
            <div class="card-body text-center">
                <span class="text-dark"><?php echo e($product['denied_note']); ?></span>
            </div>
        </div>
        <?php endif; ?>

        <!-- Card -->
        <div class="card">
            <!-- Body -->
            <div class="card-body">
                <div class="row align-items-md-center gx-md-5">
                    <div class="col-md-auto mb-3 mb-md-0">
                        <div class="d-flex align-items-center">
                            <img
                                class="avatar avatar-xxl avatar-4by3 <?php echo e(Session::get('direction') === "rtl" ? 'ml-4' : 'mr-4'); ?>"
                                onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($product['thumbnail']); ?>"
                                alt="Image Description">

                            <div class="d-block">
                                <h4 class="display-2 text-dark mb-0"><?php echo e(count($product->rating)>0?number_format($product->rating[0]->average, 2, '.', ' '):0); ?></h4>
                                <p> <?php echo e(\App\CPU\translate('of')); ?> <?php echo e($product->reviews->count()); ?> <?php echo e(\App\CPU\translate('reviews')); ?>

                                    <span class="badge badge-soft-dark badge-pill <?php echo e(Session::get('direction') === "rtl" ? 'mr-1' : 'ml-1'); ?>"></span>
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md">
                        <ul class="list-unstyled list-unstyled-py-2 mb-0">
                        <?php ($total=$product->reviews->count()); ?>
                        <!-- Review Ratings -->
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($five=\App\CPU\Helpers::rating_count($product['id'],5)); ?>
                                <span
                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(\App\CPU\translate('5 star')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($five/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($five/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($five); ?></span>
                            </li>
                            <!-- End Review Ratings -->

                            <!-- Review Ratings -->
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($four=\App\CPU\Helpers::rating_count($product['id'],4)); ?>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(\App\CPU\translate('4 star')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($four/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($four/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($four); ?></span>
                            </li>
                            <!-- End Review Ratings -->

                            <!-- Review Ratings -->
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($three=\App\CPU\Helpers::rating_count($product['id'],3)); ?>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(\App\CPU\translate('3 star')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($three/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($three/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span
                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($three); ?></span>
                            </li>
                            <!-- End Review Ratings -->

                            <!-- Review Ratings -->
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($two=\App\CPU\Helpers::rating_count($product['id'],2)); ?>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(\App\CPU\translate('2 star')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($two/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($two/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($two); ?></span>
                            </li>
                            <!-- End Review Ratings -->

                            <!-- Review Ratings -->
                            <li class="d-flex align-items-center font-size-sm">
                                <?php ($one=\App\CPU\Helpers::rating_count($product['id'],1)); ?>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(\App\CPU\translate('1 star')); ?></span>
                                <div class="progress flex-grow-1">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo e($total==0?0:($one/$total)*100); ?>%;"
                                         aria-valuenow="<?php echo e($total==0?0:($one/$total)*100); ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <span class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($one); ?></span>
                            </li>
                            <!-- End Review Ratings -->
                        </ul>
                    </div>

                    <div class="col-12">
                        <hr>
                    </div>

                    <div class="col-lg-4 mb-5 mb-lg-0 d-flex flex-column gap-1">
                        <div class="flex-start">
                            <h5 class=""><?php echo e($product['name']); ?></h5>
                        </div>
                        <div class="flex-start">
                            <span><?php echo e(\App\CPU\translate('Price')); ?> : </span>
                            <span
                                class="mx-1"><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($product['unit_price']))); ?></span>
                        </div>
                        <div class="flex-start">
                            <span><?php echo e(\App\CPU\translate('TAX')); ?> : </span>
                            <span class="mx-1"><?php echo e(($product['tax'])); ?>% (<?php echo e(ucfirst($product->tax_model)); ?>)</span>
                        </div>
                        <div class="flex-start">
                            <span><?php echo e(\App\CPU\translate('Discount')); ?> : </span>
                            <span
                                class="mx-1"><?php echo e($product->discount_type=='flat'?(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($product['discount']))): $product->discount.''.'%'); ?> </span>
                        </div>
                        <?php if($product->product_type == 'physical'): ?>
                        <div class="flex-start">
                            <span><?php echo e(\App\CPU\translate('shipping Cost')); ?> : </span>
                            <span class="mx-1"><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($product->shipping_cost))); ?></span>
                        </div>
                        <div class="flex-start">
                            <span><?php echo e(\App\CPU\translate('Current Stock')); ?> : </span>
                            <span class="mx-1"><?php echo e($product->current_stock); ?></span>
                        </div>
                        <?php endif; ?>

                        <?php if(($product->product_type == 'digital') && ($product->digital_product_type == 'ready_product')): ?>
                            <div>
                                <a href="<?php echo e(asset("storage/app/public/product/digital-product/$product->digital_file_ready")); ?>" class="btn btn--primary py-1 mt-3" download><?php echo e(\App\CPU\translate('download')); ?></a>
                            </div>
                        <?php endif; ?>

                    </div>

                    <div class="col-lg-8 border-lg-left">
                        <div> <?php if(count(json_decode($product->colors)) > 0): ?>
                                <div class="d-flex align-items-center flex-wrap gap-10 mb-4">
                                    <div class="">
                                        <div class="product-description-label"><?php echo e(\App\CPU\translate('Available color')); ?>:
                                        </div>
                                    </div>
                                    <div class="">
                                        <ul class="align-items-center d-flex flex-wrap gap-2 list-inline mb-0">
                                            <?php $__currentLoopData = json_decode($product->colors); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>

                                                    <label class="d-block p-2" style="background: <?php echo e($color); ?>;"
                                                        for="<?php echo e($product->id); ?>-color-<?php echo e($key); ?>"
                                                        ></label>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div>
                            <div class="mb-2"><?php echo e(\App\CPU\translate('Product Image')); ?></div>
                            <div class="row g-2">
                                <?php $__currentLoopData = json_decode($product->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-6 col-md-4 col-lg-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <img class="width-100"
                                                    onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                                    src="<?php echo e(asset("storage/app/public/product/$photo")); ?>" alt="Product image">

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Body -->
        </div>
        <!-- End Card -->

        <!-- Card -->
        <div class="card mt-3">
            <!-- Table -->
            <div class="table-responsive datatable-custom">
                <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                       style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(\App\CPU\translate('Reviewer')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Review')); ?></th>
                        <th><?php echo e(\App\CPU\translate('Date')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($review->customer)): ?>
                        <tr>
                            <td>
                                <a class="d-flex align-items-center"
                                   href="<?php echo e(route('admin.customer.view',[$review['customer_id']])); ?>">
                                    <div class="avatar avatar-circle">
                                        <img
                                            class="avatar-img"
                                            onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                            src="<?php echo e(asset('storage/app/public/profile/'.$review->customer->image)); ?>"
                                            alt="Image Description">
                                    </div>
                                    <div class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>">
                                    <span class="d-block h5 text-hover-primary mb-0"><?php echo e($review->customer['f_name']." ".$review->customer['l_name']); ?> <i
                                            class="tio-verified text-primary" data-toggle="tooltip" data-placement="top"
                                            title="Verified Customer"></i></span>
                                        <span class="d-block font-size-sm text-body"><?php echo e($review->customer->email??""); ?></span>
                                    </div>
                                </a>
                            </td>
                            <td>
                                <div class="text-wrap">
                                    <div class="d-flex mb-2">
                                        <label class="badge badge-soft-info">
                                            <span><?php echo e($review->rating); ?> <i class="tio-star"></i> </span>
                                        </label>
                                    </div>

                                    <p>
                                        <?php echo e($review['comment']); ?>

                                    </p>
                                    <?php $__currentLoopData = json_decode($review->attachment); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <a class="float-left" href="<?php echo e(asset('storage/app/public/review')); ?>/<?php echo e($img); ?>" data-lightbox="mygallery">
                                            <img class="p-2" width="60" height="60" src="<?php echo e(asset('storage/app/public/review')); ?>/<?php echo e($img); ?>" alt="">
                                        </a>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </td>
                            <td>
                                <?php echo e(date('d M Y H:i:s',strtotime($review['updated_at']))); ?>

                            </td>
                        </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!-- End Table -->

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <!-- Pagination -->
                    <?php echo $reviews->links(); ?>

                </div>
            </div>

            <?php if(count($reviews)==0): ?>
                <div class="text-center p-4">
                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                </div>
            <?php endif; ?>
        </div>
        <!-- End Card -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/tags-input.min.js"></script>
    <script src="<?php echo e(asset('public/assets/select2/js/select2.min.js')); ?>"></script>
    <script>
        $('input[name="colors_active"]').on('change', function () {
            if (!$('input[name="colors_active"]').is(':checked')) {
                $('#colors-selector').prop('disabled', true);
            } else {
                $('#colors-selector').prop('disabled', false);
            }
        });
        $(document).ready(function () {
            $('.color-var-select').select2({
                templateResult: colorCodeSelect,
                templateSelection: colorCodeSelect,
                escapeMarkup: function (m) {
                    return m;
                }
            });

            function colorCodeSelect(state) {
                var colorCode = $(state.element).val();
                if (!colorCode) return state.text;
                return "<span class='color-preview' style='background-color:" + colorCode + ";'></span>" + state.text;
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/product/view.blade.php ENDPATH**/ ?>