
<!-- Edited by dSMART -->


<?php $__env->startSection('title', \App\CPU\translate('blogs')); ?>

<?php $__env->startPush('css_or_js'); ?>
<link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/message.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('blogs')); ?>

                <span class="badge badge-soft-dark radius-50 fz-14 ml-1"><?php echo e($blog->total()); ?></span>
            </h2>
        </div>
    <div class="row mt-20">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row justify-content-between align-items-center flex-grow-1">
                    <!-- <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                                <h5 class="d-flex gap-2 align-items-center">
                                    <?php echo e(\App\CPU\translate('Blogs')); ?> <?php echo e(\App\CPU\translate('Table')); ?> 
                                    <span
                                    
                                        class="badge badge-soft-dark radius-50 fz-12"></span>
                                </h5>
                    </div> -->
                        <div class="col-sm-8 col-md-6 col-lg-4 mb-2 mb-sm-0">
                            <!-- Edited by dSMART -->
                                <!-- Search -->
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <!-- Edited by dSMART -->
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                               placeholder="<?php echo e(\App\CPU\translate('Search_by_Title')); ?>"
                                               aria-label="Search orders" value="<?php echo e($search); ?>">

                                               <!-- Edited by dSMART -->
                                            <input type="hidden" name="status">
                                            <button type="submit"
                                                class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?>

                                            </button>
                                    </div>
                                </form>
                                <!-- End Search -->
                        </div>

                        <!-- Edited by dSMART -->
                        <div class="mt-3 mt-lg-0">
                            <!-- href="<?php echo e(route('admin.product.add-new')); ?>" -->
                                <a  class="btn btn--primary" href="<?php echo e(route('admin.blog.add-new')); ?>">
                                    <i class="tio-add"></i>
                                    <span class="text"><?php echo e(\App\CPU\translate('Add_New_Blog')); ?></span>
                                </a>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                        <table id="datatable"
                               style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;"
                               class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Image')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Title')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Date')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('Active_Status')); ?></th>
                                <th><?php echo e(\App\CPU\translate('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $blog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$blog_post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($k + 1); ?></td>
                                    <td><img class="rounded" width="100" onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img2.jpg')); ?>'" src="<?php echo e(asset('storage/app/public/blog')); ?>/<?php echo e($blog_post['img']); ?>" alt=""></td>
                                    <td><?php echo e($blog_post['title']); ?></td>
                                    <td>
                                        <div><?php echo e(date('d M Y',strtotime($blog_post['created_at']))); ?>,</div>
                                        <div><?php echo e(date("h:i A",strtotime($blog_post['created_at']))); ?></div>
                                    </td>
                                    <td>
                                        <label class="mx-auto text-center switcher">
                                            <input class="switcher_input" type="checkbox"
                                            onclick="change_status('<?php echo e($blog_post['id']); ?>')" <?php echo e($blog_post->isActive == 1 ? 'Checked':''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-10">
                                            <a class="btn btn-outline--primary btn-sm cursor-pointer edit"
                                               title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                               href="<?php echo e(route('admin.blog.edit',[$blog_post['id']])); ?>"
                                               >
                                                <i class="tio-edit"></i>
                                            </a>
                                            <a class="btn btn-outline-danger btn-sm cursor-pointer delete"
                                               title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                               id="<?php echo e($blog_post['id']); ?>"
                                               >
                                                <i class="tio-delete"></i>
                                            </a>
                                        </div>
                                    </td>
                                        <!-- <td class="text-wrap"><?php echo e($blog_post['isActive']); ?></td> -->
                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                </div>
                <div class="table-responsive mt-4">
                    <div class="px-4 d-flex justify-content-lg-end">
                        <!-- Pagination -->
                        <?php echo e($blog->links()); ?>

                    </div>
                </div>
                <?php if(count($blog)==0): ?>
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                        <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level custom scripts -->
    <script>

        function change_status(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.blog.update-status')); ?>",
                method: 'POST',
                data: {
                    id: id
                },
                success: function () {
                    toastr.success('<?php echo e(\App\CPU\translate('blog status updated successfully')); ?>');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: "<?php echo e(\App\CPU\translate('Are_you_sure_delete_this_blog')); ?>?",
                text: "<?php echo e(\App\CPU\translate('You_will_not_be_able_to_revert_this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete_it')); ?>!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.blog.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function (response) {
                            console.log(response);
                            window.location.reload();
                            toastr.success('<?php echo e(\App\CPU\translate('Blog_deleted_successfully')); ?>');
                            $('#data-' + id).hide();
                        }
                    });
                }
            })
        });
    </script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/blog/list.blade.php ENDPATH**/ ?>