
<?php $__env->startSection('title', \App\CPU\translate('pet_medical_history')); ?>
<?php $__env->startPush('css_or_js'); ?>
<link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
<!-- Page Title -->
    <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/message.png')); ?>" alt="">
                <?php echo e($pet['pet_name']); ?>

            </h2>
    </div>
    <div class="row">
                <div class="col-lg-6">
                    <div class="card mb-3">
                        <div class="card-header">
                            <h5 class="mb-0 text-capitalize d-flex">
                                <?php echo e(\App\CPU\translate('Pet_details')); ?>

                            </h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-user-information table-borderless mb-0">
                                <tbody>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('name')); ?>:</td>
                                        <td><?php echo e($pet['pet_name']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('type')); ?>:</td>
                                        <td><?php echo e($pet['type']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('gender')); ?>:</td>
                                        <td><?php echo e($pet['gender']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('age')); ?>:</td>
                                        <td><?php echo e($pet['age']); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card mb-3">
                        <div class="card-header">
                            <h5 class="mb-0 text-capitalize d-flex">
                                <?php echo e(\App\CPU\translate('User_details')); ?>

                            </h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-user-information table-borderless mb-0">
                                <tbody>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('name')); ?>:</td>
                                        <td><?php echo e($pet['customer']['f_name']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('phone')); ?>:</td>
                                        <td><?php echo e($pet['customer']['phone']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('email')); ?>:</td>
                                        <td><?php echo e($pet['customer']['email']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(\App\CPU\translate('street_address')); ?>:</td>
                                        <td><?php echo e($pet['customer']['street_address']); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <nav>
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                    <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true"><?php echo e(\App\CPU\translate('Vaccine')); ?></a>
                    <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false"><?php echo e(\App\CPU\translate('Allergy')); ?></a>
                    <a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact" role="tab" aria-controls="nav-contact" aria-selected="false"><?php echo e(\App\CPU\translate('Parasites Treatment')); ?></a>
                </div>
            </nav>
            <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                    <div class="card mt-3">
                        <!-- Table -->
                        <div class="table-responsive datatable-custom">
                            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                            style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;">
                            <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                        <a id="btnAddVaccine" class="btn btn--primary addBtn" data-toggle="modal" data-target="#vaccineModal">
                            <i class="tio-add"></i>
                            <span class="text"><?php echo e(\App\CPU\translate('Add_Vaccine_History')); ?></span>
                        </a>
                        <!-- Modal -->
                        <div class="modal fade" id="vaccineModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(\App\CPU\translate('Vaccine')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                            <div class="modal-body">
                                <form action="<?php echo e(route('admin.pet-medical-history.store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                            <input type="hidden" name="type" value="vaccine" class="form-control">
                                            <input type="hidden" name="pet_id" value="<?php echo e($pet['id']); ?>" class="form-control">
                                            <input type="hidden" id="vaccineId" name="id" value="" class="form-control">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('vaccine_name')); ?></label>
                                            <input type="text" id="vaccineTitle" required name="title" class="form-control" placeholder="Vaccine Name">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('date')); ?></label>
                                            <input type="date" required id="vaccinedate" name="date" class="form-control" placeholder="date">
                                    </div>
                                    <div class="form-group d-flex">
                                        <div class="w-100">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('next_appointment')); ?></label>
                                            <input type="number" id="vaccinenext_due_in" name="next_due_in" required class="form-control" placeholder="Next appointment">
                                        </div>
                                            <select class="js-example-basic-multiple form-control" name="unit">
                                            <?php $__currentLoopData = \App\CPU\Helpers::dateTime(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($x); ?>" <?php echo e(old('unit') == $x ? 'selected' : ''); ?>>
                                                    <?php echo e($x); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="title-color"><?php echo e(\App\CPU\translate('notes')); ?></label>
                                        <textarea name="notes" id="vaccinenotes" class="textarea editor-textarea"></textarea>
                                    </div>
                                    <div class="form-group d-flex justify-content-between">
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>
                                </form>
                            </div>
                            </div>
                        </div>
                        </div>
                    </div>
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('vaccine_name')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('date')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('next_appointment')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('notes')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Action')); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                    $serialNumber = 1;
                                ?>
                                <?php $__currentLoopData = $vaccineData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($serialNumber); ?></td>
                                        <td><?php echo e($item->title); ?></td>
                                        <td><?php echo e(date('d M Y',strtotime($item['date']))); ?></td>
                                        <td><?php echo e($item->next_due_in); ?> month</td>
                                        <td><?php echo e(strip_tags($item->notes)); ?></td>
                                        <td>
                                            <div class="d-flex gap-10">
                                                <a class="btn btn-outline-danger btn-sm cursor-pointer delete"
                                                title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                id="<?php echo e($item['id']); ?>"
                                                >
                                                <i class="tio-delete"></i>
                                                </a>
                                                <button id="editVaccine" class="btn btn-outline--primary btn-sm square-btn"
                                                    type="button"
                                                    title="<?php echo e(\App\CPU\translate('Edit')); ?>" 
                                                    value="<?php echo e($item->id); ?>"
                                                    data-toggle="modal" data-target="#vaccineModal">
                                                    <i class="tio-edit"></i>
                                                </button>
                                        </div>
                                        </td>
                                    </tr>
                                    <?php
                                    $serialNumber++;
                                    ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <!-- Modal 4 -->
                            <div class="table-responsive mt-4">
                                <div class="px-4 d-flex justify-content-lg-end">
                                    <!-- Pagination -->
                                    <?php echo e($vaccineData->links()); ?>

                                </div>
                            </div>
                            <?php if(count($vaccineData)==0): ?>
                                <div class="text-center p-4">
                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                        <div class="card mt-3">
                        <div class="col-lg-12 mt-3 mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                        <a class="btn btn--primary" id="addAllergy" data-toggle="modal" data-target="#allergyModal">
                            <i class="tio-add"></i>
                            <span class="text"><?php echo e(\App\CPU\translate('Add_Allergy_History')); ?></span>
                        </a>
                        <!-- Modal -->
                        <div class="modal fade" id="allergyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(\App\CPU\translate('Allergy')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                            <div class="modal-body">
                                <form action="<?php echo e(route('admin.pet-medical-history.store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                            <input type="hidden" name="type" value="alergy" class="form-control">
                                            <input type="hidden" name="pet_id" value="<?php echo e($pet['id']); ?>" class="form-control">
                                            <input type="hidden" id="allergyid" name="id" value="" class="form-control">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('allergy_name')); ?></label>
                                            <input required type="text" id="allergytitle" name="title" class="form-control" placeholder="Allergy Name">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('date')); ?></label>
                                            <input required type="date" id="allergydate" name="date" class="form-control" placeholder="date">
                                    </div>
                                    <div class="form-group d-flex justify-content-between">
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>
                                </form>
                            </div>
                              
                            </div>
                        </div>
                        </div>
                    </div>
                        <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                                style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;">
                                    <thead class="thead-light thead-50 text-capitalize">
                                        <tr>
                                            <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('allergy_name')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('date')); ?></th>
                                            <th><?php echo e(\App\CPU\translate('Action')); ?></th>
                                        </tr>
                                    </thead>

                                <tbody>
                                <?php
                                    $serialNumber = 1;
                                ?>
                                <?php $__currentLoopData = $alergy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($serialNumber); ?></td>
                                        <td><?php echo e($item->title); ?></td>
                                        <td><?php echo e(date('d M Y',strtotime($item['date']))); ?></td>
                                        <td>
                                            <div class="d-flex gap-10">
                                                <a class="btn btn-outline-danger btn-sm cursor-pointer delete"
                                                title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                id="<?php echo e($item['id']); ?>"
                                                >
                                                <i class="tio-delete"></i>
                                                </a>
                                                <button class="btn btn-outline--primary btn-sm square-btn"
                                                    type="button"
                                                    id="editAllergy"
                                                    title="<?php echo e(\App\CPU\translate('Edit')); ?>" 
                                                    value="<?php echo e($item->id); ?>"
                                                    data-toggle="modal" data-target="#allergyModal">
                                                    <i class="tio-edit"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                        $serialNumber++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                </table>
                                <div class="table-responsive mt-4">
                                <div class="px-4 d-flex justify-content-lg-end">
                                    <!-- Pagination -->
                                    <?php echo e($alergy->links()); ?>

                                </div>
                            </div>
                            <?php if(count($alergy)==0): ?>
                                <div class="text-center p-4">
                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                                </div>
                            <?php endif; ?>
                            </div>
                        </div>
            </div>
            <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                <div class="card mt-3">
                <div class="col-lg-12 mt-3  mb-3 d-flex flex-wrap gap-3 justify-content-lg-end">
                <a class="btn btn--primary" id="addParasite" data-toggle="modal" data-target="#parasiteModal">
                            <i class="tio-add"></i>
                            <span class="text"><?php echo e(\App\CPU\translate('Add_Parasite_History')); ?></span>
                        </a>
                        <!-- Modal -->
                        <div class="modal fade" id="parasiteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                          <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLongTitle"><?php echo e(\App\CPU\translate('Parasite_Treatment')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                  <span aria-hidden="true">&times;</span>
                                </button>
                              </div>
                            <div class="modal-body">
                                <form action="<?php echo e(route('admin.pet-medical-history.store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                            <input type="hidden" name="type" value="parasite" class="form-control">
                                            <input type="hidden" name="pet_id" value="<?php echo e($pet['id']); ?>" class="form-control">
                                            <input type="hidden" id="parasiteid" name="id" value="" class="form-control">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('parasite_name')); ?></label>
                                            <input required name="title" id="parasitetitle" type="text" class="form-control" placeholder="Parasite Name">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('date')); ?></label>
                                            <input required name="date" id="parasitedate" type="date" class="form-control" placeholder="date">
                                    </div>
                                    <div class="form-group">
                                            <label class="title-color"><?php echo e(\App\CPU\translate('next_appointment')); ?></label>
                                            <input required name="next_due_in" id="parasitenext_due_in" type="number" class="form-control" placeholder="Next appointment">
                                    </div>
                                    <div class="form-group">
                                        <label class="title-color"><?php echo e(\App\CPU\translate('notes')); ?></label>
                                        <textarea required name="notes" id="parasitenotes" class="textarea editor-textarea"></textarea>
                                    </div>
                                    <div class="form-group d-flex justify-content-between">
                                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>
                                </form>
                            </div>
                            </div>
                        </div>
                        </div>
                    </div>
                        <!-- Table -->
                        <div class="table-responsive datatable-custom">
                            <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100"
                            style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>;">
                                <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('parasite_name')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('date')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('next_appointment')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('notes')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Action')); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                    $serialNumber = 1;
                                ?>
                                <?php $__currentLoopData = $parasite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($serialNumber); ?></td>
                                        <td><?php echo e($item->title); ?></td>
                                        <td><?php echo e(date('d M Y',strtotime($item['date']))); ?></td>
                                        <td><?php echo e($item->next_due_in); ?> month </td>
                                        <td><?php echo e(strip_tags($item->notes)); ?></td>
                                        <td>
                                            <div class="d-flex gap-10">
                                                <a class="btn btn-outline-danger btn-sm cursor-pointer delete"
                                                title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                id="<?php echo e($item['id']); ?>"
                                                >
                                                <i class="tio-delete"></i>
                                                </a>
                                                <button id="editParasite" class="btn btn-outline--primary btn-sm square-btn"
                                                    type="button"
                                                    title="<?php echo e(\App\CPU\translate('Edit')); ?>" 
                                                    value="<?php echo e($item->id); ?>"
                                                    data-toggle="modal" data-target="#parasiteModal">
                                                    <i class="tio-edit"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>

                                    <?php
                                        $serialNumber++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <div class="table-responsive mt-4">
                                <div class="px-4 d-flex justify-content-lg-end">
                                    <!-- Pagination -->
                                    <?php echo e($parasite->links()); ?>

                                </div>
                            </div>
                            <?php if(count($parasite)==0): ?>
                                <div class="text-center p-4">
                                    <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                    <p class="mb-0"><?php echo e(\App\CPU\translate('No data to show')); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
            </div>

                        <?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>

    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/ckeditor.js"></script>
    <script src="<?php echo e(asset('/')); ?>vendor/ckeditor/ckeditor/adapters/jquery.js"></script>
    <script>
        $('.textarea').ckeditor({
            contentsLangDirection: '<?php echo e(Session::get('direction')); ?>',
        });

        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: "<?php echo e(\App\CPU\translate('Are_you_sure_delete_this_blog')); ?>?",
                text: "<?php echo e(\App\CPU\translate('You_will_not_be_able_to_revert_this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete_it')); ?>!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.pet-medical-history.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function (response) {
                            console.log(response);
                            window.location.reload();
                            $('#data-' + id).hide();
                        }
                    });
                }
            })
        });

        //vaccine
        $(document).on('click', '#btnAddVaccine', function() {
          $('#vaccineId').val("")
          $('#vaccineTitle').val("")
          $('#vaccinedate').val("")
          $('#vaccinenext_due_in').val("")
          $('#vaccinenotes').val("")
        });

        $(document).on('click', '#editVaccine', function () {
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
              url: url,
              method: 'GET',
              success: function (response) {
                console.log(response);
                $('#vaccineId').val(id)
                $('#vaccineTitle').val(response.data.title)
                $('#vaccinedate').val(response.data.date)
                $('#vaccinenext_due_in').val(response.data.next_due_in)
                $('#vaccinenotes').val(response.data.notes)
              }
            });
        });

        //Alergy
        $(document).on('click', '#addAllergy', function() {
          $('#allergyid').val('')
          $('#allergytitle').val('')
          $('#allergydate').val('')
        });
        $(document).on('click', '#editAllergy', function () {
            var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
                url: url,
                method: 'GET',
                success: function (response) {
                    console.log(response);
                    $('#allergyid').val(id)
                    $('#allergytitle').val(response.data.title)
                    $('#allergydate').val(response.data.date)
                }
            });
        });
        
        //parasite
        $(document).on('click', '#addParasite', function() {
          $('#parasiteid').val("")
          $('#parasitetitle').val("")
          $('#parasitedate').val("")
          $('#parasitenext_due_in').val("")
          $('#parasitenotes').val("")
        });
        $(document).on('click', '#editParasite', function() {
          var id = $(this).val();
            var url = "/admin/pet-medical-history/edit/" + id;
            $.ajax({
              url: url,
              method: 'GET',
              success: function (response) {
                console.log(response);
                $('#parasiteid').val(id)
                $('#parasitetitle').val(response.data.title)
                $('#parasitedate').val(response.data.date)
                $('#parasitenext_due_in').val(response.data.next_due_in)
                $('#parasitenotes').val(response.data.notes)
              }
            });
        });

        function clearVaccineFields(){
          alert("hello ");
          return true;
        }
        
    </script>

    
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/pet-list-approval/history.blade.php ENDPATH**/ ?>