<?php $__env->startSection('title', \App\CPU\translate('refund_details')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<div class="content container-fluid">

    <!-- Page Title -->
    <div class="mb-3">
        <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/refund-request-list.png')); ?>" alt="">
            <?php echo e(\App\CPU\translate('refund_details')); ?>

        </h2>
    </div>
    <!-- End Page Title -->

    <div class="row gy-2">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row gy-1 justify-content-between align-items-center flex-grow-1">
                        <div class="col-md-4">
                            <h5 class="mb-0"><?php echo e(\App\CPU\translate('refund_id')); ?> : <?php echo e($refund->id); ?></h5>
                        </div>

                        <h5 class="col-md-4 mb-0 text-capitalize"><?php echo e(\App\CPU\translate('refund_status')); ?>:
                            <?php if($refund->status == 'pending'): ?>
                                <span class="text--primary"> <?php echo e(\App\CPU\translate($refund->status)); ?></span>
                            <?php elseif($refund->status == 'approved'): ?>
                                <span class="text-success"> <?php echo e(\App\CPU\translate($refund->status)); ?></span>
                            <?php elseif($refund->status == 'refunded'): ?>
                                <span class="text-info"> <?php echo e(\App\CPU\translate($refund->status)); ?></span>
                            <?php elseif($refund->status == 'rejected'): ?>
                                <span class="text-danger"> <?php echo e(\App\CPU\translate($refund->status)); ?></span>
                            <?php endif; ?>
                        </h5>

                        <div class="col-md-4 d-flex justify-content-md-end">
                            <?php if($refund->change_by != 'admin'): ?>
                                <button class="btn btn--primary" data-toggle="modal"
                                        data-target="#refund-status"><?php echo e(\App\CPU\translate('change_refund_status')); ?></button>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
                <?php ($order = App\Model\Order::find($refund->order_id)); ?>
                <?php
                    $total_product_price = 0;
                    foreach ($order->details as $key => $or_d) {
                        $total_product_price += ($or_d->qty*$or_d->price) + $or_d->tax - $or_d->discount;
                    }
                        $refund_amount = 0;
                        $subtotal = $refund->order_details->price*$refund->order_details->qty - $refund->order_details->discount + $refund->order_details->tax;

                        $coupon_discount = ($order->discount_amount*$subtotal)/$total_product_price;

                        $refund_amount = $subtotal - $coupon_discount;
                ?>
                <div class="card-body">
                    <div class="row gy-2">
                        <div class="col-sm-4 col-lg-2">
                            <img onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($refund->product!=null?$refund->product->thumbnail:''); ?>"
                                alt="VR Collection">
                        </div>
                        <div class="col-sm-8 col-md-4 col-lg-6">
                            <h4>
                                <?php if($refund->product!=null): ?>
                                    <a href="<?php echo e(route('seller.product.view',[$refund->product->id])); ?>">
                                        <?php echo e($refund->product->name); ?>

                                    </a>
                                <?php else: ?>
                                    <?php echo e(\App\CPU\translate('product_name_not_found')); ?>

                                <?php endif; ?>
                            </h4>
                            <div ><?php echo e(\App\CPU\translate('QTY')); ?> : <?php echo e($refund->order_details->qty); ?></div>
                            <div><?php echo e(\App\CPU\translate('price')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->price)); ?></div>
                            <?php if($refund->order_details->variant): ?>
                                <strong><u><?php echo e(\App\CPU\translate('Variation')); ?> : </u></strong>

                                <div class="font-size-sm text-body">
                                    <span class="font-weight-bold"><?php echo e($refund->order_details->variant); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-4 col-lg-4">
                            <div class="row justify-content-md-end mb-3">
                                <div class="col-md-10">
                                    <dl class="row text-md-right">
                                        <dt class="col-md-7"><?php echo e(\App\CPU\translate('total_price')); ?> : </dt>
                                        <dd class="col-md-5 ">
                                            <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->price*$refund->order_details->qty)); ?></strong>
                                        </dd>

                                        <dt class="col-sm-7"><?php echo e(\App\CPU\translate('total_discount')); ?> :</dt>
                                        <dd class="col-sm-5 ">
                                            <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->discount)); ?></strong>
                                        </dd>

                                        <dt class="col-sm-7"><?php echo e(\App\CPU\translate('total_tax')); ?> :</dt>
                                        <dd class="col-sm-5">
                                            <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->tax)); ?></strong>
                                        </dd>
                                    </dl>
                                    <!-- End Row -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="d-flex flex-wrap flex-column flex-md-row gap-10 justify-content-between">
                        <span class="title-color"><?php echo e(\App\CPU\translate('subtotal')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($subtotal)); ?></span>
                        <span class="title-color"><?php echo e(\App\CPU\translate('coupon_discount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($coupon_discount)); ?></span>
                        <span class="title-color"><?php echo e(\App\CPU\translate('total_refund_amount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($refund_amount)); ?></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 ">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0"><?php echo e(\App\CPU\translate('additional_information')); ?></h4>
                </div>

                <div class="card-body">
                    <div class="row gy-2">
                        <div class="col-sm-6 col-md-4 d-flex flex-column gap-10">
                            <h5><?php echo e(\App\CPU\translate('deliveryman_info')); ?> : </h5>
                            <span><?php echo e(\App\CPU\translate('deliveryman_name')); ?> : <?php echo e($order->delivery_man!=null?$order->delivery_man->f_name . ' ' .$order->delivery_man->l_name:\App\CPU\translate('not_assigned')); ?></span>
                            <span><?php echo e(\App\CPU\translate('deliveryman_email')); ?> : <?php echo e($order->delivery_man!=null?$order->delivery_man->email :\App\CPU\translate('not_found')); ?></span>
                            <span><?php echo e(\App\CPU\translate('deliveryman_phone')); ?> : <?php echo e($order->delivery_man!=null?$order->delivery_man->phone :\App\CPU\translate('not_found')); ?></span>
                        </div>

                        <div class="col-sm-6 col-md-4 d-flex flex-column gap-10">
                            <span><?php echo e(\App\CPU\translate('payment_method')); ?> : <?php echo e(str_replace('_',' ',$order->payment_method)); ?></span>
                            <span><?php echo e(\App\CPU\translate('order_details')); ?> : <a class="btn btn--primary btn-sm" href="<?php echo e(route('seller.orders.details',['id'=>$order->id])); ?>"><?php echo e(\App\CPU\translate('click_here')); ?></a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0"><?php echo e(\App\CPU\translate('refund_status_changed_log')); ?></h4>
                </div>
                <div class="table-responsive datatable-custom">
                    <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                            style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>">
                        <thead class="thead-light thead-50 text-capitalize">
                        <tr>
                            <th>
                                <?php echo e(\App\CPU\translate('SL')); ?>#
                            </th>
                            <th><?php echo e(\App\CPU\translate('changed_by')); ?> </th>
                            <th><?php echo e(\App\CPU\translate('status')); ?></th>
                            <th><?php echo e(\App\CPU\translate('note')); ?></th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $refund->refund_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$r_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($key+1); ?>

                                </td>
                                <td>
                                    <?php echo e($r_status->change_by); ?>

                                </td>
                                <td>
                                    <?php echo e(\App\CPU\translate($r_status->status)); ?>

                                </td>
                                <td class="text-break">
                                    <div class="word-break max-w-360px">
                                        <?php echo e($r_status->message); ?>

                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php if(count($refund->refund_status)==0): ?>
                        <div class="text-center p-4">
                            <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                            <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0"><?php echo e(\App\CPU\translate('refund_reason')); ?></h4>
                </div>
                <div class="card-body">
                    <div class="col-12">
                        <p>
                            <?php echo e($refund->refund_reason); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="mb-0"><?php echo e(\App\CPU\translate('attachment')); ?></h4>
                </div>
                <div class="card-body">
                    <div class="col-12">

                        <?php if($refund->images !=null): ?>
                            <div class="gallery grid-gallery">
                                <?php $__currentLoopData = json_decode($refund->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(asset('storage/app/public/refund')); ?>/<?php echo e($photo); ?>" data-lightbox="mygallery">
                                        <img src="<?php echo e(asset('storage/app/public/refund')); ?>/<?php echo e($photo); ?>" alt="">
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           </div>
                        <?php else: ?>
                            <p><?php echo e(\App\CPU\translate('no_attachment_found')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<div class="modal fade" id="refund-status" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(\App\CPU\translate('change_refund_status')); ?></h5>
                <button id="payment_close" type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('seller.refund.refund-status-update')); ?>" id='order_place' method="post" class="row">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($refund->id); ?>">
                    <div class="form-group col-12">
                        <label class="input-label" for=""><?php echo e(\App\CPU\translate('refund_status')); ?></label>
                        <select name="refund_status" class="form-control" onchange="refund_status_change(this.value)">
                            <option
                                value="pending" <?php echo e($refund->status=='pending'?'selected':''); ?>>
                                <?php echo e(\App\CPU\translate('pending')); ?>

                            </option>
                            
                                <option
                                    value="approved" <?php echo e($refund->status=='approved'?'selected':''); ?>>
                                    <?php echo e(\App\CPU\translate("approved")); ?>

                                </option>

                                <option
                                    value="rejected" <?php echo e($refund->status=='rejected'?'selected':''); ?>>
                                    <?php echo e(\App\CPU\translate("rejected")); ?>

                                </option>
                            
                        </select>
                    </div>
                    <div class="form-group col-12" id="approved">
                        <label class="input-label" for=""><?php echo e(\App\CPU\translate('approved_note')); ?></label>
                        <input type="text" class="form-control" id="approved_note" name="approved_note">
                    </div>
                    <div class="form-group col-12" id="rejected">
                        <label class="input-label" for=""><?php echo e(\App\CPU\translate('rejected_note')); ?></label>
                        <input type="text" class="form-control" id="rejected_note" name="rejected_note">
                    </div>
                    <div class="form-group col-12 d-flex justify-content-end">
                        <button class="btn btn--primary" type="submit"><?php echo e(\App\CPU\translate('submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
<script>
    $( document ).ready(function() {

        $('#approved').hide();
        $("#approved_note").prop("required", false);
        $('#rejected').hide();
        $("#rejected_note").prop("required", false);
});

function refund_status_change(val)
{
    if(val === 'approved'){
        $('#rejected').hide();
        $("#rejected_note").prop("required", false);

        $('#approved').show();
        $("#approved_note").prop("required", true);

    }else if(val === 'rejected'){
        $('#approved').hide();
        $("#approved_note").prop("required", false);

        $('#rejected').show();
        $("#rejected_note").prop("required", true);

    }else{
        $('#approved').hide();
        $("#approved_note").prop("required", false);
        $('#rejected').hide();
        $("#rejected_note").prop("required", false);

    }
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/refund/details.blade.php ENDPATH**/ ?>