<?php $__env->startSection('title',\App\CPU\translate('My Wallet')); ?>

<?php $__env->startSection('content'); ?>

    <div class="container text-center">
        <h3 class="headerTitle my-3"><?php echo e(\App\CPU\translate('my_wallet')); ?></h3>
    </div>

    <!-- Page Content-->
    <div class="container pb-5 mb-2 mb-md-4 mt-3 rtl"
         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
        <div class="row">
            <!-- Sidebar-->
        <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Content  -->
            <section class="col-lg-9 col-md-9">
                <div class="card __card">
                    <div class="card-header border-0">
                        <div class="d-flex __gap-6px flex-wrap justify-content-between">
                            <div>
                                <span>
                                    <?php echo e(\App\CPU\translate('transaction_history')); ?>

                                </span>
                            </div>
                            <div>
                                <span>
                                    <?php echo e(\App\CPU\translate('wallet_amount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($total_wallet_balance)); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table __table">
                                <thead class="thead-light">
                                    <tr>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO "><?php echo e(\App\CPU\translate('SL')); ?></span></div>
                                        </td>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO"><?php echo e(\App\CPU\translate('transaction_type')); ?> </span>
                                            </div>
                                        </td>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO"><?php echo e(\App\CPU\translate('credit')); ?> </span>
                                            </div>
                                        </td>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('debit')); ?></span></div>
                                        </td>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('balance')); ?></span></div>
                                        </td>
                                        <td class="tdBorder">
                                            <div class="py-2"><span
                                                    class="d-block spandHeadO"> <?php echo e(\App\CPU\translate('date')); ?></span></div>
                                        </td>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $wallet_transactio_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="bodytr">
                                            <?php echo e($wallet_transactio_list->firstItem()+$key); ?>

                                        </td>
                                        <td class="bodytr"><span class="text-capitalize"><?php echo e(\App\CPU\translate(str_replace('_',' ',$item['transaction_type']))); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e(\App\CPU\Helpers::currency_converter($item['credit'])); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e(\App\CPU\Helpers::currency_converter($item['debit'])); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e(\App\CPU\Helpers::currency_converter($item['balance'])); ?></span></td>
                                        <td class="bodytr"><span class=""><?php echo e($item['created_at']); ?></span></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php if($wallet_transactio_list->count()==0): ?>
                                <center class="mt-3 mb-2"><?php echo e(\App\CPU\translate('no_transaction_found')); ?></center>
                            <?php endif; ?>

                            <div class="card-footer border-0">
                                <?php echo e($wallet_transactio_list->links()); ?>

                            </div>
                        </div>

                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/user-wallet.blade.php ENDPATH**/ ?>