<?php $__env->startSection('title',$seller->shop ? $seller->shop->name : \App\CPU\translate("shop name not found")); ?>
<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex gap-2 align-items-center">
                <img src="<?php echo e(asset('/public/assets/back-end/img/coupon_setup.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Seller_details')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Page Heading -->
        <div class="flex-between d-sm-flex row align-items-center justify-content-between mb-2 mx-1">
            <div>
                <a href="<?php echo e(route('admin.sellers.seller-list')); ?>"
                   class="btn btn--primary my-3"><?php echo e(\App\CPU\translate('Back_to_seller_list')); ?></a>
            </div>
            <div>
                <?php if($seller->status=="pending"): ?>
                    <div class="mt-4 pr-2">
                        <div class="flex-start">
                            <div class="mx-1"><h4><i class="tio-shop-outlined"></i></h4></div>
                            <div><?php echo e(\App\CPU\translate('Seller_request_for_open_a_shop.')); ?></div>
                        </div>
                        <div class="text-center">
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="approved">
                                <button type="submit"
                                        class="btn btn--primary btn-sm"><?php echo e(\App\CPU\translate('Approve')); ?></button>
                            </form>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="rejected">
                                <button type="submit"
                                        class="btn btn-danger btn-sm"><?php echo e(\App\CPU\translate('reject')); ?></button>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Page Header -->
        <div class="page-header">
            <div class="flex-between row mx-1">
                <div>
                    <h1 class="page-header-title"><?php echo e($seller->shop ? $seller->shop->name : "Shop Name : Update Please"); ?></h1>
                </div>

            </div>
            <!-- Nav Scroller -->
            <div class="js-nav-scroller hs-nav-scroller-horizontal">
                <!-- Nav -->
                <ul class="nav nav-tabs flex-wrap page-header-tabs">
                    <li class="nav-item">
                        <a class="nav-link "
                           href="<?php echo e(route('admin.sellers.view',$seller->id)); ?>"><?php echo e(\App\CPU\translate('Shop')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link "
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'order'])); ?>"><?php echo e(\App\CPU\translate('Order')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'product'])); ?>"><?php echo e(\App\CPU\translate('Product')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'setting'])); ?>"><?php echo e(\App\CPU\translate('Setting')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'transaction'])); ?>"><?php echo e(\App\CPU\translate('Transaction')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'review'])); ?>"><?php echo e(\App\CPU\translate('Review')); ?></a>
                    </li>
                </ul>
                <!-- End Nav -->
            </div>
            <!-- End Nav Scroller -->
        </div>
        <!-- End Page Header -->

        <div class="content container-fluid p-0">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="px-3 py-4">
                            <div class="row align-items-center">
                                <div class="col-lg-4 mb-3 mb-lg-0">
                                    <h5 class="mb-0 text-capitalize d-flex gap-1 align-items-center"><?php echo e(\App\CPU\translate('transaction_table')); ?>

                                        <span class="badge badge-soft-dark fz-12"><?php echo e($transactions->total()); ?></span>
                                    </h5>
                                </div>
                                <div class="col-md-6 col-lg-4 mb-3 mb-md-0">
                                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                                        <!-- Search -->
                                        <div class="input-group input-group-merge input-group-custom">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text">
                                                    <i class="tio-search"></i>
                                                </div>
                                            </div>
                                            <input id="datatableSearch_" type="search" name="search"
                                                   class="form-control"
                                                   placeholder="<?php echo e(\App\CPU\translate('Search by orders id or transaction id')); ?>"
                                                   aria-label="Search orders" value="<?php echo e($search); ?>">
                                            <button type="submit"
                                                    class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                                        </div>
                                        <!-- End Search -->
                                    </form>
                                </div>
                                <div class="col-md-6 col-lg-4">
                                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                                        <div class="d-flex justify-content-end align-items-center gap-10">
                                            <select class="form-control" name="status">
                                                <option value="0" selected disabled>
                                                    ---<?php echo e(\App\CPU\translate('select_status')); ?>---
                                                </option>
                                                <option class="text-capitalize"
                                                        value="all" <?php echo e($status == 'all'? 'selected' : ''); ?> ><?php echo e(\App\CPU\translate('all')); ?> </option>
                                                <option class="text-capitalize"
                                                        value="disburse" <?php echo e($status == 'disburse'? 'selected' : ''); ?> ><?php echo e(\App\CPU\translate('disburse')); ?> </option>
                                                <option class="text-capitalize"
                                                        value="hold" <?php echo e($status == 'hold'? 'selected' : ''); ?>><?php echo e(\App\CPU\translate('hold')); ?></option>
                                            </select>
                                            <button type="submit" class="btn btn-success">
                                                <?php echo e(\App\CPU\translate('filter')); ?>

                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table id="datatable"
                               style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                               class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                <th><?php echo e(\App\CPU\translate('seller_name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('customer_name')); ?></th>
                                <th><?php echo e(\App\CPU\translate('order_id')); ?></th>
                                <th><?php echo e(\App\CPU\translate('transaction_id')); ?></th>
                                <th><?php echo e(\App\CPU\translate('order_amount')); ?></th>
                                <th><?php echo e(\App\CPU\translate('seller_amount')); ?></th>
                                <th><?php echo e(\App\CPU\translate('admin_commission')); ?></th>
                                <th><?php echo e(\App\CPU\translate('received_by')); ?></th>
                                <th><?php echo e(\App\CPU\translate('delivered_by')); ?></th>
                                <th><?php echo e(\App\CPU\translate('delivery_charge')); ?></th>
                                <th><?php echo e(\App\CPU\translate('payment_method')); ?></th>
                                <th><?php echo e(\App\CPU\translate('tax')); ?></th>
                                <th class="text-center"><?php echo e(\App\CPU\translate('status')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($transactions->firstItem()+$key); ?></td>
                                    <td>
                                        <?php if($transaction['seller_is'] == 'admin'): ?>
                                            <?php echo e(App\Model\BusinessSetting::where(['type' => 'company_name'])->first()->value); ?>

                                        <?php else: ?>
                                            <?php echo e(App\Model\Seller::find($transaction['seller_id'])->f_name); ?> <?php echo e(App\Model\Seller::find($transaction['seller_id'])->l_name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e(App\User::find($transaction['customer_id'])->f_name??''); ?> <?php echo e(App\User::find($transaction['customer_id'])->l_name??''); ?>

                                    </td>
                                    <td><?php echo e($transaction['order_id']); ?></td>
                                    <td><?php echo e($transaction['transaction_id']); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['order_amount']))); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['seller_amount']))); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['admin_commission']))); ?></td>
                                    <td><?php echo e($transaction['received_by']); ?></td>
                                    <td><?php echo e($transaction['delivered_by']); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['delivery_charge']))); ?></td>
                                    <td><?php echo e(str_replace('_',' ',$transaction['payment_method'])); ?></td>
                                    <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($transaction['tax']))); ?></td>
                                    <td class="text-center">
                                        <?php if($transaction['status'] == 'disburse'): ?>
                                            <span class="badge badge-soft-success">
                                                <?php echo e($transaction['status']); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-soft-warning ">
                                                <?php echo e($transaction['status']); ?>

                                            </span>
                                        <?php endif; ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php if(count($transactions)==0): ?>
                            <div class="text-center p-4">
                                <img class="mb-3 w-160"
                                     src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                     alt="Image Description">
                                <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="px-4 d-flex justify-content-lg-end">
                            <!-- Pagination -->
                            <?php echo e($transactions->links()); ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        function status_filter(type) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('admin.withdraw.status-filter')); ?>',
                data: {
                    withdraw_status_filter: type
                },
                beforeSend: function () {
                    $('#loading').show()
                },
                success: function (data) {
                    location.reload();
                },
                complete: function () {
                    $('#loading').hide()
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/seller/view/transaction.blade.php ENDPATH**/ ?>