<?php $__env->startSection('title', $seller->shop? $seller->shop->name : \App\CPU\translate("Shop Name")); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/add-new-seller.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('seller_details')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Page Heading -->
        <div class="flex-between d-sm-flex row align-items-center justify-content-between mb-2 mx-1">
            <div>
                <a href="<?php echo e(route('admin.sellers.seller-list')); ?>"
                   class="btn btn--primary mt-3 mb-3"><?php echo e(\App\CPU\translate('Back_to_seller_list')); ?></a>
            </div>
            <div>
                <?php if($seller->status=="pending"): ?>
                    <div class="mt-4 pr-2 float-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>">
                        <div class="flex-start">
                            <h4 class="mx-1"><i class="tio-shop-outlined"></i></h4>
                            <div><h4><?php echo e(\App\CPU\translate('Seller_request_for_open_a_shop.')); ?></h4></div>
                        </div>
                        <div class="text-center">
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="approved">
                                <button type="submit"
                                        class="btn btn--primary btn-sm"><?php echo e(\App\CPU\translate('Approve')); ?></button>
                            </form>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="rejected">
                                <button type="submit"
                                        class="btn btn-danger btn-sm"><?php echo e(\App\CPU\translate('reject')); ?></button>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Page Header -->
        <div class="page-header">
            <div class="flex-between row mx-1">
                <div>
                    <h1 class="page-header-title"><?php echo e($seller->shop? $seller->shop->name : "Shop Name : Update Please"); ?></h1>
                </div>
            </div>
            <!-- Nav Scroller -->
            <div class="js-nav-scroller hs-nav-scroller-horizontal">
                <!-- Nav -->
                <ul class="nav nav-tabs flex-wrap page-header-tabs">
                    <li class="nav-item">
                        <a class="nav-link active"
                           href="<?php echo e(route('admin.sellers.view',$seller->id)); ?>"><?php echo e(\App\CPU\translate('Shop')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'order'])); ?>"><?php echo e(\App\CPU\translate('Order')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'product'])); ?>"><?php echo e(\App\CPU\translate('Product')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'setting'])); ?>"><?php echo e(\App\CPU\translate('Setting')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'transaction'])); ?>"><?php echo e(\App\CPU\translate('Transaction')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'review'])); ?>"><?php echo e(\App\CPU\translate('Review')); ?></a>
                    </li>

                </ul>
                <!-- End Nav -->
            </div>
            <!-- End Nav Scroller -->
        </div>
        <!-- End Page Header -->
        <?php if($seller->shop->temporary_close || ($seller->shop->vacation_status && $current_date >= date('Y-m-d', strtotime($seller->shop->vacation_start_date)) && $current_date <= date('Y-m-d', strtotime($seller->shop->vacation_end_date)))): ?>
        <div class="card mb-3">
            <div class="card-body">
                <span class="text-danger">
                    <?php if($seller->shop->temporary_close): ?>
                        <h3 class="text-danger"><?php echo e(\App\CPU\translate('This_shop_is_in_temporary_closed')); ?>.</h3>
                    <?php elseif($seller->shop->vacation_status && $current_date >= date('Y-m-d', strtotime($seller->shop->vacation_start_date)) && $current_date <= date('Y-m-d', strtotime($seller->shop->vacation_end_date))): ?>
                        <h3 class="text-danger"><?php echo e(\App\CPU\translate('This_shop_is_in_vacation_mode')); ?></h3>
                        <span class="text-dark"><strong><?php echo e(\App\CPU\translate('note_from_seller')); ?> :</strong> <?php echo e($seller->shop->vacation_note); ?></span>
                    <?php endif; ?>
                </span>
            </div>
        </div>
        <?php endif; ?>

        <div class="card mb-3">
            <div class="card-body">

                <div class="row justify-content-between align-items-center g-2 mb-3">
                    <div class="col-sm-6">
                        <h4 class="d-flex align-items-center text-capitalize gap-10 mb-0">
                            <img width="20" class="mb-1" src="<?php echo e(asset('/public/assets/back-end/img/admin-wallet.png')); ?>" alt="">
                            <?php echo e(\App\CPU\translate('Seller_Wallet')); ?>

                        </h4>
                    </div>
                </div>

                <div class="row g-2" id="order_stats">
                    <div class="col-lg-4">
                        <!-- Card -->
                        <div class="card h-100 d-flex justify-content-center align-items-center">
                            <div class="card-body d-flex flex-column gap-10 align-items-center justify-content-center">
                                <img width="48" class="mb-2" src="<?php echo e(asset('/public/assets/back-end/img/withdraw.png')); ?>" alt="">
                                <h3 class="for-card-count mb-0 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->total_earning)) : 0); ?></h3>
                                <div class="font-weight-bold text-capitalize mb-30">
                                    <?php echo e(\App\CPU\translate('Withdrawable_balance')); ?>

                                </div>
                            </div>
                        </div>
                        <!-- End Card -->
                    </div>
                    <div class="col-lg-8">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->pending_withdraw)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('Pending_Withdraw')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" class="mb-2" src="<?php echo e(asset('/public/assets/back-end/img/pw.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->commission_given)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('Total_Commission_given')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" src="<?php echo e(asset('/public/assets/back-end/img/tcg.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->withdrawn)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('Aready_Withdrawn')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" src="<?php echo e(asset('/public/assets/back-end/img/aw.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->delivery_charge_earned)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('total_delivery_charge_earned')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" src="<?php echo e(asset('/public/assets/back-end/img/tdce.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->total_tax_collected)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('total_tax_given')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" src="<?php echo e(asset('/public/assets/back-end/img/ttg.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card card-body h-100 justify-content-center">
                                    <div class="d-flex gap-2 justify-content-between align-items-center">
                                        <div class="d-flex flex-column align-items-start">
                                            <h3 class="mb-1 fz-24"><?php echo e($seller->wallet ? \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($seller->wallet->collected_cash)) : 0); ?></h3>
                                            <div class="text-capitalize mb-0"><?php echo e(\App\CPU\translate('collected_cash')); ?></div>
                                        </div>
                                        <div>
                                            <img width="40" src="<?php echo e(asset('/public/assets/back-end/img/cc.png')); ?>" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header text-capitalize">
                        <h5 class="mb-0"><?php echo e(\App\CPU\translate('Seller')); ?> <?php echo e(\App\CPU\translate('Account')); ?></h5>
                        <?php if($seller->status=='approved'): ?>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="suspended">
                                <button type="submit"
                                        class="btn btn-sm btn-outline-danger"><?php echo e(\App\CPU\translate('suspend')); ?></button>
                            </form>
                        <?php elseif($seller->status=='rejected' || $seller->status=='suspended'): ?>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="approved">
                                <button type="submit"
                                        class="btn btn-outline-success"><?php echo e(\App\CPU\translate('activate')); ?></button>
                            </form>
                        <?php endif; ?>
                    </div>
                    <div class="card-body"
                         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <div class="flex-start">
                            <div><h4><?php echo e(\App\CPU\translate('Status')); ?> : </h4></div>
                            <div class="mx-1">
                                <h4><?php echo $seller->status=='approved'?'<label class="badge badge-success">Active</label>':'<label class="badge badge-danger">In-Active</label>'; ?></h4>
                            </div>
                        </div>
                        <div class="flex-start">
                            <div><h5><?php echo e(\App\CPU\translate('name')); ?> : </h5></div>
                            <div class="mx-1"><h5><?php echo e($seller->f_name); ?> <?php echo e($seller->l_name); ?></h5></div>
                        </div>
                        <div class="flex-start">
                            <div><h5><?php echo e(\App\CPU\translate('Email')); ?> : </h5></div>
                            <div class="mx-1"><h5><?php echo e($seller->email); ?></h5></div>
                        </div>
                        <div class="flex-start">
                            <div><h5><?php echo e(\App\CPU\translate('Phone')); ?> : </h5></div>
                            <div class="mx-1"><h5><?php echo e($seller->phone); ?></h5></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if($seller->shop): ?>
                <div class="col-md-6 mt-2 mt-md-0">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><?php echo e(\App\CPU\translate('Shop')); ?> <?php echo e(\App\CPU\translate('info')); ?></h5>
                        </div>
                        <div class="card-body"
                             style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                            <div class="flex-start">
                                <div><h5><?php echo e(\App\CPU\translate('seller')); ?> : </h5></div>
                                <div class="mx-1"><h5><?php echo e($seller->shop->name); ?></h5></div>
                            </div>
                            <div class="flex-start">
                                <div><h5><?php echo e(\App\CPU\translate('Phone')); ?> : </h5></div>
                                <div class="mx-1"><h5><?php echo e($seller->shop->contact); ?></h5></div>
                            </div>
                            <div class="flex-start">
                                <div><h5><?php echo e(\App\CPU\translate('address')); ?> : </h5></div>
                                <div class="mx-1"><h5><?php echo e($seller->shop->address); ?></h5></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-md-6 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"> <?php echo e(\App\CPU\translate('bank_info')); ?></h5>
                    </div>
                    <div class="card-body"
                         style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <div class="mt-2">
                            <div class="flex-start">
                                <div><h4><?php echo e(\App\CPU\translate('bank_name')); ?> : </h4></div>
                                <div class="mx-1">
                                    <h4><?php echo e($seller->bank_name ? $seller->bank_name : \App\CPU\translate('No Data found')); ?></h4>
                                </div>
                            </div>
                            <div class="flex-start">
                                <div><h6><?php echo e(\App\CPU\translate('Branch')); ?> : </h6></div>
                                <div class="mx-1">
                                    <h6><?php echo e($seller->branch ? $seller->branch : \App\CPU\translate('No Data found')); ?></h6>
                                </div>
                            </div>
                            <div class="flex-start">
                                <div><h6><?php echo e(\App\CPU\translate('holder_name')); ?> : </h6></div>
                                <div class="mx-1">
                                    <h6><?php echo e($seller->holder_name ? $seller->holder_name : \App\CPU\translate('No Data found')); ?></h6>
                                </div>
                            </div>
                            <div class="flex-start">
                                <div><h6><?php echo e(\App\CPU\translate('account_no')); ?> : </h6></div>
                                <div class="mx-1">
                                    <h6><?php echo e($seller->account_no ? $seller->account_no : \App\CPU\translate('No Data found')); ?></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/seller/view.blade.php ENDPATH**/ ?>