<?php $__env->startSection('title', \App\CPU\translate('FAQ')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/Pages.png')); ?>" width="20" alt="">
                <?php echo e(\App\CPU\translate('pages')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
    <?php echo $__env->make('admin-views.business-settings.pages-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Inlile Menu -->

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><?php echo e(\App\CPU\translate('help_topic')); ?> <?php echo e(\App\CPU\translate('Table')); ?> </h5>
                        <button class="btn btn--primary btn-icon-split for-addFaq" data-toggle="modal"
                                data-target="#addModal">
                            <i class="tio-add"></i>
                            <span class="text"><?php echo e(\App\CPU\translate('Add')); ?> <?php echo e(\App\CPU\translate('faq')); ?>  </span>
                        </button>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table
                                class="table table-hover table-borderless table-thead-bordered table-align-middle card-table w-100"
                                id="dataTable" cellspacing="0"
                                style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                                <thead class="thead-light thead-50 text-capitalize">
                                <tr>
                                    <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Question')); ?></th>
                                    <th class="min-w-200"><?php echo e(\App\CPU\translate('Answer')); ?></th>
                                    <th><?php echo e(\App\CPU\translate('Ranking')); ?></th>
                                    <th class="text-center"><?php echo e(\App\CPU\translate('Status')); ?> </th>
                                    <th class="text-center"><?php echo e(\App\CPU\translate('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $helps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$help): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="data-<?php echo e($help->id); ?>">
                                        <td><?php echo e($k+1); ?></td>
                                        <td><?php echo e($help['question']); ?></td>
                                        <td><?php echo e($help['answer']); ?></td>
                                        <td><?php echo e($help['ranking']); ?></td>

                                        <td>
                                            <label class="switcher mx-auto">
                                                <input type="checkbox" class="switcher_input status_id"
                                                       data-id="<?php echo e($help->id); ?>" <?php echo e($help->status == 1?'checked':''); ?>>
                                                <span class="switcher_control"></span>
                                            </label>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-10">
                                                <a class="btn btn-outline--primary btn-sm edit"
                                                   data-toggle="modal" data-target="#editModal"
                                                   title="<?php echo e(\App\CPU\translate('Edit')); ?>"
                                                   data-id="<?php echo e($help->id); ?>">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <a class="btn btn-outline-danger btn-sm delete"
                                                   title="<?php echo e(\App\CPU\translate('Delete')); ?>"
                                                   id="<?php echo e($help['id']); ?>">
                                                    <i class="tio-delete"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="modal fade" tabindex="-1" role="dialog" id="addModal">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(\App\CPU\translate('Add Help Topic')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span
                                aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('admin.helpTopic.add-new')); ?>" method="post" id="addForm">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body"
                             style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">

                            <div class="form-group">
                                <label><?php echo e(\App\CPU\translate('Question')); ?></label>
                                <input type="text" class="form-control" name="question"
                                       placeholder="<?php echo e(\App\CPU\translate('Type Question')); ?>">
                            </div>


                            <div class="form-group">
                                <label><?php echo e(\App\CPU\translate('Answer')); ?></label>
                                <textarea class="form-control" name="answer" cols="5"
                                          rows="5" placeholder="<?php echo e(\App\CPU\translate('Type Answer')); ?>"></textarea>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="control-label"><?php echo e(\App\CPU\translate('Status')); ?></div>
                                        <label class="mt-2">
                                            <input type="checkbox" name="status" id="e_status" value="1"
                                                   class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                            <span
                                                class="custom-switch-description"><?php echo e(\App\CPU\translate('Active')); ?></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="ranking"><?php echo e(\App\CPU\translate('Ranking')); ?></label>
                                    <input type="number" name="ranking" class="form-control">
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer bg-whitesmoke br">
                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal"><?php echo e(\App\CPU\translate('Close')); ?></button>
                            <button class="btn btn--primary"><?php echo e(\App\CPU\translate('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    

    <div class="modal fade" tabindex="-1" role="dialog" id="editModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(\App\CPU\translate('Edit Modal Help Topic')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span
                            aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post" id="editForm"
                      style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                    <?php echo csrf_field(); ?>
                    
                    <div class="modal-body">

                        <div class="form-group">
                            <label><?php echo e(\App\CPU\translate('Question')); ?></label>
                            <input type="text" class="form-control" name="question"
                                   placeholder="<?php echo e(\App\CPU\translate('Type Question')); ?>"
                                   id="e_question" class="e_name">
                        </div>


                        <div class="form-group">
                            <label><?php echo e(\App\CPU\translate('Answer')); ?></label>
                            <textarea class="form-control" name="answer" cols="5"
                                      rows="5" placeholder="<?php echo e(\App\CPU\translate('Type Answer')); ?>"
                                      id="e_answer"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="ranking"><?php echo e(\App\CPU\translate('Ranking')); ?></label>
                                <input type="number" name="ranking" class="form-control" id="e_ranking" required>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer bg-whitesmoke br">
                        <button type="button" class="btn btn-secondary"
                                data-dismiss="modal"><?php echo e(\App\CPU\translate('Close')); ?></button>
                        <button class="btn btn--primary"><?php echo e(\App\CPU\translate('update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/js/demo/datatables-demo.js"></script>

    <script>
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });
        $(document).on('click', ".status_id", function () {
            let id = $(this).attr('data-id');

            $.ajax({
                url: "status/" + id,
                type: 'get',
                dataType: 'json',
                success: function (res) {
                    toastr.success(res.success);
                }

            });

        });
        $(document).on('click', '.edit', function () {
            let id = $(this).attr("data-id");
            console.log(id);
            $.ajax({
                url: "edit/" + id,
                type: "get",
                data: {"_token": "<?php echo e(csrf_token()); ?>"},
                dataType: "json",
                success: function (data) {
                    // console.log(data);
                    $("#e_question").val(data.question);
                    $("#e_answer").val(data.answer);
                    $("#e_ranking").val(data.ranking);


                    $("#editForm").attr("action", "update/" + data.id);


                }
            });
        });
        $(document).on('click', '.delete', function () {
            var id = $(this).attr("id");
            Swal.fire({
                title: '<?php echo e(\App\CPU\translate('Are you sure delete this FAQ')); ?>?',
                text: "<?php echo e(\App\CPU\translate('You will not be able to revert this')); ?>!",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '<?php echo e(\App\CPU\translate('Yes')); ?>, <?php echo e(\App\CPU\translate('delete it')); ?>!',
                type: 'warning',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(route('admin.helpTopic.delete')); ?>",
                        method: 'POST',
                        data: {id: id},
                        success: function () {
                            toastr.success('<?php echo e(\App\CPU\translate('FAQ deleted successfully')); ?>');
                            $('#data-' + id).hide();
                        }
                    });
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/help-topics/list.blade.php ENDPATH**/ ?>