<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><?php echo e(\App\CPU\translate("product")); ?> <?php echo e(\App\CPU\translate("barcode")); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/back-end')); ?>/css/bootstrap.css" />
    <style>
        body {
            line-height: 1.2;
        }
        .text-capitalize {
            text-transform: uppercase;
        }
        .text-bold {
            font-weight: bold;
        }
        .currency {
            font-family: DejaVuSans;
        }
    </style>
</head>

<body>
    <?php if($quantity): ?>
        <div class="container">
            <div class="row">
                <?php for($i = 0; $i < $quantity; $i++): ?>
                    <?php if($i % 3 == 0 && $i != 0): ?>
            </div>
            <div class="row">
    <?php endif; ?>
    <div align="center" class="col-xs-4" style="border: 1px dotted #CCC; margin: 5px; width: 27%;">
        <span
            class="text-capitalize text-bold"><?php echo e(\App\Model\BusinessSetting::where('type', 'company_name')->first()->value); ?></span>
        <span class="product-name" style="display: block"><?php echo e(Str::limit($product->name, 30)); ?></span>
        <span class="currency">
            <?php echo e($product['selling_price'] . ' ' . \App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($product->unit_price))); ?></span>
        <br>
        <div class="bar-code" style="margin-left: 10px !important; font-weight:bold"><?php echo DNS1D::getBarcodeHTML($product->code, 'C128'); ?></div>
        <p class=""><?php echo e(\App\CPU\translate('code')); ?> :
            <?php echo e($product->code); ?></p>
    </div>
    <?php endfor; ?>
    </div>
    </div>
    <?php endif; ?>
</body>

</html>
<?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/product/barcode-pdf.blade.php ENDPATH**/ ?>