<?php $__env->startSection('title',$seller->shop ? $seller->shop->name : \App\CPU\translate("shop name not found")); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/coupon_setup.png')); ?>" alt="">
                <?php echo e(\App\CPU\translate('Seller_Details')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Page Heading -->
        <div class="flex-between d-sm-flex row align-items-center justify-content-between mb-2 mx-1">
            <div>
                <a href="<?php echo e(route('admin.sellers.seller-list')); ?>"
                   class="btn btn--primary mt-3 mb-3"><?php echo e(\App\CPU\translate('Back_to_seller_list')); ?></a>
            </div>
            <div>
                <?php if($seller->status=="pending"): ?>
                    <div class="mt-4 pr-2 float-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>">
                        <div class="flex-start">
                            <div class="mx-1"><h4><i class="tio-shop-outlined"></i></h4></div>
                            <div><?php echo e(\App\CPU\translate('Seller_request_for_open_a_shop.')); ?></div>
                        </div>
                        <div class="text-center">
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="approved">
                                <button type="submit"
                                        class="btn btn--primary btn-sm"><?php echo e(\App\CPU\translate('Approve')); ?></button>
                            </form>
                            <form class="d-inline-block" action="<?php echo e(route('admin.sellers.updateStatus')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($seller->id); ?>">
                                <input type="hidden" name="status" value="rejected">
                                <button type="submit"
                                        class="btn btn-danger btn-sm"><?php echo e(\App\CPU\translate('reject')); ?></button>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- Page Header -->
        <div class="page-header">
            <div class="flex-between row mx-1">
                <div>
                    <h1 class="page-header-title"><?php echo e($seller->shop ? $seller->shop->name : "Shop Name : Update Please"); ?></h1>
                </div>
            </div>

            <!-- Nav Scroller -->
            <div class="js-nav-scroller hs-nav-scroller-horizontal">
                <!-- Nav -->
                <ul class="nav nav-tabs flex-wrap page-header-tabs">
                    <li class="nav-item">
                        <a class="nav-link "
                           href="<?php echo e(route('admin.sellers.view',$seller->id)); ?>"><?php echo e(\App\CPU\translate('Shop')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'order'])); ?>"><?php echo e(\App\CPU\translate('Order')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'product'])); ?>"><?php echo e(\App\CPU\translate('Product')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'setting'])); ?>"><?php echo e(\App\CPU\translate('Setting')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'transaction'])); ?>"><?php echo e(\App\CPU\translate('Transaction')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link"
                           href="<?php echo e(route('admin.sellers.view',['id'=>$seller->id, 'tab'=>'review'])); ?>"><?php echo e(\App\CPU\translate('Review')); ?></a>
                    </li>

                </ul>
                <!-- End Nav -->
            </div>
            <!-- End Nav Scroller -->
        </div>
        <!-- End Page Header -->

        <!-- Page Heading -->
        <div class="tab-content">
            <div class="tab-pane fade show active" id="order">
                <div class="row pt-2">
                    <div class="col-md-12">
                        <div class="card w-100">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo e(\App\CPU\translate('Order')); ?> <?php echo e(\App\CPU\translate('info')); ?></h5>
                            </div>
                            <!-- Card -->
                            <?php ($pending_order = App\Model\Order::where(['seller_is'=>'seller'])->where(['seller_id'=>$seller->id])->where('order_status','pending')->where('order_type','default_type')->get()); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-3 mb-md-0">
                                        <div class="order-stats order-stats_pending">
                                            <div class="order-stats__content"
                                                 style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                                                <i class="tio-airdrop"></i>
                                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('pending')); ?></h6>
                                            </div>
                                            <div class="order-stats__title">
                                                <?php echo e($pending_order->count()); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <?php ($delivered_order = App\Model\Order::where(['seller_is'=>'seller'])->where(['seller_id'=>$seller->id])->where('order_status','delivered')->where('order_type','default_type')->get()); ?>
                                    <div class="col-md-4 mb-3 mb-md-0">
                                        <div class="order-stats order-stats_delivered">
                                            <div class="order-stats__content"
                                                 style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                                                <i class="tio-checkmark-circle"></i>
                                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('delivered')); ?></h6>
                                            </div>
                                            <div class="order-stats__title">
                                                <?php echo e($delivered_order->count()); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <?php ($total_order = App\Model\Order::where(['seller_is'=>'seller'])->where(['seller_id'=>$seller->id])->where('order_type','default_type')->get()); ?>
                                    <div class="col-md-4">
                                        <div class="order-stats order-stats_all">
                                            <div class="order-stats__content"
                                                 style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                                                <i class="tio-table"></i>
                                                <h6 class="order-stats__subtitle"><?php echo e(\App\CPU\translate('All')); ?></h6>
                                            </div>
                                            <div class="order-stats__title">
                                                <?php echo e($total_order->count()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Table -->
                            <div class="table-responsive datatable-custom">
                                <table id="datatable"
                                       style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                                       class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                                    <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th class="">
                                            <?php echo e(\App\CPU\translate('SL')); ?>

                                        </th>
                                        <th><?php echo e(\App\CPU\translate('Order')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Date')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Customer')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Payment')); ?> <?php echo e(\App\CPU\translate('status')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('total')); ?></th>
                                        <th><?php echo e(\App\CPU\translate('Order')); ?> <?php echo e(\App\CPU\translate('status')); ?></th>
                                        <th class="text-center"><?php echo e(\App\CPU\translate('action')); ?></th>
                                    </tr>
                                    </thead>

                                    <tbody id="set-rows">

                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr class="status class-all">
                                            <td>
                                                <?php echo e($orders->firstItem()+$key); ?>

                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.sellers.order-details',['order_id'=>$order['id'],'seller_id'=>$order['seller_id']])); ?>"
                                                   class="title-color hover-c1"><?php echo e($order['id']); ?></a>
                                            </td>
                                            <td><?php echo e(date('d M Y',strtotime($order['created_at']))); ?></td>
                                            <td>
                                                <?php if($order->customer): ?>
                                                    <a class="text-body text-capitalize"
                                                       href="<?php echo e(route('admin.customer.view',['user_id'=>$order->customer['id']])); ?>">
                                                        <?php echo e(isset($order->customer)?$order->customer['f_name']:''); ?> <?php echo e(isset($order->customer)?$order->customer['l_name']:''); ?>

                                                    </a>
                                                <?php else: ?>
                                                    <label
                                                        class="badge badge-soft-danger fz-12"><?php echo e(\App\CPU\translate('Removed')); ?></label>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($order->payment_status=='paid'): ?>
                                                    <span
                                                        class="badge badge-soft-info fz-12"><?php echo e(\App\CPU\translate('paid')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-soft-danger fz-12"><?php echo e(\App\CPU\translate('unpaid')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order['order_amount']))); ?></td>
                                            <td class="text-capitalize">
                                                <?php if($order['order_status']=='pending'): ?>
                                                    <span
                                                        class="badge badge-soft-info fz-12"><?php echo e(\App\CPU\translate('pending')); ?></span>
                                                <?php elseif($order['order_status']=='confirmed'): ?>
                                                    <span
                                                        class="badge badge-soft-info fz-12"><?php echo e(\App\CPU\translate('confirmed')); ?></span>
                                                <?php elseif($order['order_status']=='processing'): ?>
                                                    <span
                                                        class="badge badge-soft-warning fz-12"><?php echo e(\App\CPU\translate('processing')); ?></span>
                                                <?php elseif($order['order_status']=='out_for_delivery'): ?>
                                                    <span
                                                        class="badge badge-soft-warning fz-12"><?php echo e(\App\CPU\translate('out_for_delivery')); ?></span>
                                                <?php elseif($order['order_status']=='delivered'): ?>
                                                    <span
                                                        class="badge badge-soft-success fz-12"><?php echo e(\App\CPU\translate('delivered')); ?></span>
                                                <?php else: ?>
                                                    <span
                                                        class="badge badge-soft-danger fz-12"><?php echo e(\App\CPU\translate(str_replace('_',' ',$order['order_status']))); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="d-flex justify-content-center">
                                                    <a title="<?php echo e(\App\CPU\translate('View')); ?>"
                                                       class="btn btn-outline-info btn-sm square-btn"
                                                       href="<?php echo e(route('admin.sellers.order-details',['order_id'=>$order['id'],'seller_id'=>$order['customer_id']])); ?>"><i
                                                            class="tio-invisible"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- End Table -->

                            <div class="table-responsive mt-4">
                                <div class="px-4 d-flex justify-content-lg-end">
                                    <!-- Pagination -->
                                    <?php echo $orders->links(); ?>

                                </div>
                            </div>

                            <?php if(count($orders)==0): ?>
                                <div class="text-center p-4">
                                    <img class="mb-3 w-160"
                                         src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                                         alt="Image Description">
                                    <p class="mb-0"><?php echo e(\App\CPU\translate('No_data_to_show')); ?></p>
                                </div>
                            <?php endif; ?>
                            <!-- End Card -->
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/admin-views/seller/view/order.blade.php ENDPATH**/ ?>