<?php $__env->startSection('title',\App\CPU\translate('Refund Details')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link href="<?php echo e(asset('public/assets/back-end/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/select2/css/select2.min.css')); ?>" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container text-center">
        <h2 class="headerTitle my-3"><?php echo e(\App\CPU\translate('refund_request')); ?></h2>
    </div>
<!-- Page Content-->
<div class="container pb-5 mb-2 mb-md-4 mt-3 rtl __inline-50"
     style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
    <div class="row">
        <!-- Sidebar-->
    <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content  -->
    <?php ($product = App\Model\Product::find($order_details->product_id)); ?>
    <?php ($order = App\Model\Order::find($order_details->order_id)); ?>
        <section class="col-lg-9 col-md-9">
            <div class="card box-shadow-sm">
                <div class="overflow-auto">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6 col-sm-6 col-md-2">
                                    <div>
                                        <img  class="__w-70px __h-70p" onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($refund->product!=null?$refund->product->thumbnail:''); ?>"
                                        alt="VR Collection">
                                    </div>
                                </div>
                                <div class="col-6 col-sm-6 col-md-6">
                                    <span class="font-bold __text-18px">
                                        <?php if($refund->product!=null): ?>
                                            <a href="<?php echo e(route('product',$refund->product->slug)); ?>">
                                                <?php echo e($refund->product->name); ?>

                                            </a>
                                        <?php else: ?>
                                            <?php echo e(\App\CPU\translate('product_name_not_found')); ?>

                                        <?php endif; ?>
                                    </span> <br>
                                    <span ><?php echo e(\App\CPU\translate('QTY')); ?> : <?php echo e($refund->order_details->qty); ?></span><br>
                                    <span><?php echo e(\App\CPU\translate('price')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->price)); ?></span><br>
                                    <?php if($order_details->variant!=null): ?>
                                        <span><?php echo e(\App\CPU\translate('variant')); ?> : </span>
                                        <?php echo e($order_details->variant); ?>

                                    <?php endif; ?>
                                </div>
                                <div class="col-12 col-sm-10 col-md-4 text-center d-flex flex-column pl-0 mt-4 mt-sm-4 pl-sm-5">
                                    <div class="row justify-content-md-end mb-3">
                                        <div class="col-md-10 col-lg-10">
                                            <div class="row text-sm-right">
                                                <div class="col-sm-7"><?php echo e(\App\CPU\translate('total_price')); ?> : </div>
                                                <div class="col-sm-5 ">
                                                    <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->price*$refund->order_details->qty)); ?></strong>
                                                </div>

                                                <div class="col-sm-7"><?php echo e(\App\CPU\translate('total_discount')); ?> :</div>
                                                <div class="col-sm-5 ">
                                                    <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->discount)); ?></strong>
                                                </div>

                                                <div class="col-sm-7"><?php echo e(\App\CPU\translate('total_tax')); ?> :</div>
                                                <div class="col-sm-5">
                                                    <strong><?php echo e(\App\CPU\Helpers::currency_converter($refund->order_details->tax)); ?></strong>
                                                </div>
                                            </div>
                                            <!-- End Row -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $total_product_price = 0;
                    foreach ($order->details as $key => $or_d) {
                        $total_product_price += ($or_d->qty*$or_d->price) + $or_d->tax - $or_d->discount;
                    }
                        $refund_amount = 0;
                        $subtotal = ($order_details->price * $order_details->qty) - $order_details->discount + $order_details->tax;

                        $coupon_discount = ($order->discount_amount*$subtotal)/$total_product_price;

                        $refund_amount = $subtotal - $coupon_discount;
                    ?>

                    <div class="card mt-2">
                        <div class="card-body">
                            <div class="row text-center">
                                <span class="col-sm-2"><?php echo e(\App\CPU\translate('subtotal')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($subtotal)); ?></span>
                                <span class="col-sm-5"><?php echo e(\App\CPU\translate('coupon_discount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($coupon_discount)); ?></span>
                                <span class="col-sm-5"><?php echo e(\App\CPU\translate('total_refund_amount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($refund_amount)); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="card mt-2">
                        <div class="card-body">
                            <div class="col-12">
                                <b><?php echo e(\App\CPU\translate('refund_id')); ?></b> :
                                <span><?php echo e($refund->id); ?></span>
                            </div>
                            <div class="col-12">
                                <b><?php echo e(\App\CPU\translate('refund_status')); ?></b> :
                                <?php if($refund->status == 'pending'): ?>
                                <span class="text-capitalize __color-coral"> <?php echo e($refund->status); ?></span>
                                <?php elseif($refund->status == 'approved'): ?>
                                <span class="text-capitalize __color-1573ff"> <?php echo e($refund->status); ?></span>
                                <?php elseif($refund->status == 'refunded'): ?>
                                <span class="text-capitalize __color-01ff2cfa"> <?php echo e($refund->status); ?></span>
                                <?php elseif($refund->status == 'rejected'): ?>
                                <span class="text-capitalize __color-ff2a05fa"> <?php echo e($refund->status); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if($refund->status == 'rejected'): ?>
                            <div class="col-12">
                               <span><b><?php echo e(\App\CPU\translate('rejected_reason')); ?></b> : </span> <?php echo e($refund->rejected_note); ?>

                            </div>
                            <?php endif; ?>
                            <?php if($refund->status == 'refunded'): ?>
                            <div class="col-12">
                               <span><b><?php echo e(\App\CPU\translate('payment_info')); ?></b> : </span> <?php echo e($refund->payment_info); ?>

                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card box-shadow-sm ">
                        <div class="overflow-auto">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-6">
                                            <h5><?php echo e(\App\CPU\translate('refund_reason')); ?></h5>
                                        </div>

                                    </div>
                                </div>
                                <div class="card-body">
                                    <p>
                                        <?php echo e($refund->refund_reason); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div>
                <div class="card">
                    <div class="card-header">
                        <h5><?php echo e(\App\CPU\translate('attachment')); ?></h5>
                    </div>
                    <div class="row">
                        <div class="card-body">
                            <?php if($refund->images !=null): ?>
                                <div class="gallery">
                                    <?php $__currentLoopData = json_decode($refund->images); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(asset('storage/app/public/refund')); ?>/<?php echo e($photo); ?>" data-lightbox="mygallery">
                                            <img src="<?php echo e(asset('storage/app/public/refund')); ?>/<?php echo e($photo); ?>" alt="">
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php else: ?>
                                <p><?php echo e(\App\CPU\translate('no_attachment_found')); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
            </div>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/themes/default/web-views/users-profile/refund-details.blade.php ENDPATH**/ ?>