<?php $__env->startSection('title', \App\CPU\translate('Review List')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/product-review.png')); ?>" class="mb-1 mr-1" alt="">
                <?php echo e(\App\CPU\translate('Product_reviews')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <div class="card card-body">
            <div class="row border-bottom pb-3 align-items-center mb-20">
                <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                    <h5 class="text-capitalize mb-0 d-flex gap-1">
                        <?php echo e(\App\CPU\translate('review_table')); ?>

                        <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($reviews->total()); ?></span>
                    </h5>
                </div>
                <div class="col-sm-8 col-md-6 col-lg-4">
                    <!-- Search -->
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group input-group-merge input-group-custom">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="tio-search"></i>
                                </div>
                            </div>
                            <input id="datatableSearch_" type="search" name="search" class="form-control"
                                placeholder="<?php echo e(\App\CPU\translate('Search by Product or Customer')); ?>"
                                aria-label="Search orders" value="<?php echo e($search); ?>" required>
                            <button type="submit" class="btn btn--primary"><?php echo e(\App\CPU\translate('search')); ?></button>
                        </div>
                    </form>
                    <!-- End Search -->
                </div>
            </div>
            <form action="<?php echo e(url()->current()); ?>" method="GET">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="product" class="title-color"><?php echo e(\App\CPU\translate('choose')); ?>

                                <?php echo e(\App\CPU\translate('product')); ?></label>
                            <select class="form-control" name="product_id">
                                <option value="" selected>
                                    --<?php echo e(\App\CPU\translate('select_product')); ?>--</option>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>"
                                        <?php echo e($product_id == $product->id ? 'selected' : ''); ?>>
                                        <?php echo e(Str::limit($product->name, 20)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="customer" class="title-color"><?php echo e(\App\CPU\translate('choose')); ?>

                                <?php echo e(\App\CPU\translate('customer')); ?></label>
                            <select class="form-control" name="customer_id">
                                <option value="" selected>
                                    --<?php echo e(\App\CPU\translate('select_customer')); ?>--</option>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e(isset($item->id) ? $item->id : $customer_id); ?>"
                                        <?php echo e($customer_id != null && $customer_id == $item->id ? 'selected' : ''); ?>>
                                        <?php echo e(Str::limit($item->f_name)); ?>

                                        <?php echo e(Str::limit($item->l_name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">

                            <label for="status" class="title-color"><?php echo e(\App\CPU\translate('choose')); ?>

                                <?php echo e(\App\CPU\translate('status')); ?></label>
                            <select class="form-control" name="status">
                                <option value="" selected>
                                    --<?php echo e(\App\CPU\translate('select_status')); ?>--</option>
                                <option value="1" <?php echo e($status != null && $status == 1 ? 'selected' : ''); ?>>
                                    <?php echo e(\App\CPU\translate('active')); ?></option>
                                <option value="0" <?php echo e($status != null && $status == 0 ? 'selected' : ''); ?>>
                                    <?php echo e(\App\CPU\translate('inactive')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="from" class="title-color"><?php echo e(\App\CPU\translate('from')); ?></label>
                            <input type="date" name="from" id="from_date" value="<?php echo e($from); ?>"
                                class="form-control"
                                title="<?php echo e(\App\CPU\translate('from')); ?> <?php echo e(\App\CPU\translate('date')); ?>">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="to" class="title-color"><?php echo e(\App\CPU\translate('to')); ?></label>
                            <input type="date" name="to" id="to_date" value="<?php echo e($to); ?>"
                                class="form-control"
                                title="<?php echo e(ucfirst(\App\CPU\translate('to'))); ?> <?php echo e(\App\CPU\translate('date')); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <button id="filter" type="submit" class="btn btn--primary btn-block mt-5 filter">
                                <i class="tio-filter-list nav-icon"></i><?php echo e(\App\CPU\translate('filter')); ?>

                            </button>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <button type="button" class="btn btn-outline--primary mt-5" data-toggle="dropdown">
                                <i class="tio-download-to"></i>
                                <?php echo e(\App\CPU\translate('export')); ?>

                                <i class="tio-chevron-down"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a type="submit" class="dropdown-item" href="<?php echo e(route('seller.reviews.export', ['product_id' => $product_id, 'customer_id' => $customer_id, 'status' => $status, 'from' => $from, 'to' => $to])); ?>">
                                        <?php echo e(\App\CPU\translate('Excel')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="card mt-20">
            <div class="table-responsive datatable-custom">
                <table
                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                    style="text-align: <?php echo e(Session::get('direction') === 'rtl' ? 'right' : 'left'); ?>">
                    <thead class="thead-light thead-50 text-capitalize">
                        <tr>
                            <th><?php echo e(\App\CPU\translate('SL')); ?></th>
                            <th><?php echo e(\App\CPU\translate('Product')); ?></th>
                            <th><?php echo e(\App\CPU\translate('Customer')); ?></th>
                            <th><?php echo e(\App\CPU\translate('Rating')); ?></th>
                            <th><?php echo e(\App\CPU\translate('Review')); ?></th>
                            <th><?php echo e(\App\CPU\translate('date')); ?></th>
                            <th class="text-center"><?php echo e(\App\CPU\translate('status')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($review->product): ?>
                                <tr>
                                    <td>
                                        <?php echo e($reviews->firstItem()+$key); ?>

                                    </td>
                                    <td>
                                        <a class="title-color hover-c1" href="<?php echo e(route('seller.product.view', [$review['product_id']])); ?>">
                                            <?php echo e(Str::limit($review->product['name'], 25)); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <?php if($review->customer): ?>
                                            <?php echo e($review->customer->f_name . ' ' . $review->customer->l_name); ?>

                                        <?php else: ?>
                                            <label class="badge badge-soft-danger"><?php echo e(\App\CPU\translate('customer_removed')); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <label class="badge badge-soft-info mb-0">
                                            <span class="fz-12 d-flex align-items-center gap-1"><?php echo e($review->rating); ?> <i class="tio-star"></i>
                                            </span>
                                        </label>
                                    </td>
                                    <td>
                                        <div class="mb-1">
                                            <?php echo e($review->comment ? Str::limit($review->comment, 35) : 'No Comment Found'); ?>

                                        </div>
                                        <div class="gap-1">
                                        <?php if($review->attachment): ?>
                                            <?php $__currentLoopData = json_decode($review->attachment); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class=""
                                                    href="<?php echo e(asset('storage/app/public/review')); ?>/<?php echo e($img); ?>"
                                                    data-lightbox="mygallery">
                                                    <img clsss="p-2" width="60" height="60"
                                                        onerror="this.src='<?php echo e(asset('public/assets/back-end/img/160x160/img2.jpg')); ?>'"
                                                        src="<?php echo e(asset('storage/app/public/review')); ?>/<?php echo e($img); ?>"
                                                        alt="Image">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        </div>
                                    </td>
                                    <td><?php echo e(date('d M Y', strtotime($review->created_at))); ?></td>
                                    <td>
                                        <label class="switcher mx-auto">
                                            <input type="checkbox" class="switcher_input"
                                                onclick="location.href='<?php echo e(route('seller.reviews.status', [$review['id'], $review->status ? 0 : 1])); ?>'"
                                                class="toggle-switch-input" <?php echo e($review->status ? 'checked' : ''); ?>>
                                            <span class="switcher_control"></span>
                                        </label>
                                    </td>

                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <!-- Pagination -->
                    <?php echo $reviews->links(); ?>

                </div>
            </div>
            <!-- End Pagination -->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script_2'); ?>
    <script>
        $(document).on('change', '#from_date', function() {
            from_date = $(this).val();
            if (from_date) {
                $("#to_date").prop('required', true);
            }
        });
    </script>
    <script>
        $('#from_date , #to_date').change(function() {
            let fr = $('#from_date').val();
            let to = $('#to_date').val();
            if (fr != '' && to != '') {
                if (fr > to) {
                    $('#from_date').val('');
                    $('#to_date').val('');
                    toastr.error('Invalid date range!', Error, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                }
            }

        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /media/umer/UserData/Umer_WorkSpace/Vetsa_WorkSpace/vetsa-web/resources/views/seller-views/reviews/list.blade.php ENDPATH**/ ?>